<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UNIT StructType
 * @subpackage Structs
 */
class UNIT extends AbstractStructBase
{
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $NAME;
    /**
     * The CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * @var string
     */
    public $CODE;
    /**
     * The UNITID
     * @var float
     */
    public $UNITID;
    /**
     * Constructor method for UNIT
     * @uses UNIT::setNAME()
     * @uses UNIT::setCODE()
     * @uses UNIT::setUNITID()
     * @param string $nAME
     * @param string $cODE
     * @param float $uNITID
     */
    public function __construct($nAME = null, $cODE = null, $uNITID = null)
    {
        $this
            ->setNAME($nAME)
            ->setCODE($cODE)
            ->setUNITID($uNITID);
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \Ys\ArasOrder\StructType\UNIT
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($nAME) && mb_strlen($nAME) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \Ys\ArasOrder\StructType\UNIT
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODE, true), gettype($cODE)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($cODE) && mb_strlen($cODE) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get UNITID value
     * @return float|null
     */
    public function getUNITID()
    {
        return $this->UNITID;
    }
    /**
     * Set UNITID value
     * @param float $uNITID
     * @return \Ys\ArasOrder\StructType\UNIT
     */
    public function setUNITID($uNITID = null)
    {
        // validation for constraint: float
        if (!is_null($uNITID) && !(is_float($uNITID) || is_numeric($uNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uNITID, true), gettype($uNITID)), __LINE__);
        }
        $this->UNITID = $uNITID;
        return $this;
    }
}
