<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentSortInfo StructType
 * @subpackage Structs
 */
class ShipmentSortInfo extends AbstractStructBase
{
    /**
     * The DOCUMENT_NUMBER
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 11
     * - minOccurs: 0
     * @var string
     */
    public $DOCUMENT_NUMBER;
    /**
     * The DELIVERY_UNIT_NAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $DELIVERY_UNIT_NAME;
    /**
     * The CARGO_TYPE
     * @var string
     */
    public $CARGO_TYPE;
    /**
     * The AMOUNT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 81
     * - minOccurs: 0
     * @var string
     */
    public $AMOUNT;
    /**
     * The SENDERNAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $SENDERNAME;
    /**
     * The RECEIVERNAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $RECEIVERNAME;
    /**
     * The RECEIVER_ADDRESS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 129
     * - minOccurs: 0
     * @var string
     */
    public $RECEIVER_ADDRESS;
    /**
     * The PRICE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PRICE;
    /**
     * The SHIPMENT_CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $SHIPMENT_CODE;
    /**
     * Constructor method for ShipmentSortInfo
     * @uses ShipmentSortInfo::setDOCUMENT_NUMBER()
     * @uses ShipmentSortInfo::setDELIVERY_UNIT_NAME()
     * @uses ShipmentSortInfo::setCARGO_TYPE()
     * @uses ShipmentSortInfo::setAMOUNT()
     * @uses ShipmentSortInfo::setSENDERNAME()
     * @uses ShipmentSortInfo::setRECEIVERNAME()
     * @uses ShipmentSortInfo::setRECEIVER_ADDRESS()
     * @uses ShipmentSortInfo::setPRICE()
     * @uses ShipmentSortInfo::setSHIPMENT_CODE()
     * @param string $dOCUMENT_NUMBER
     * @param string $dELIVERY_UNIT_NAME
     * @param string $cARGO_TYPE
     * @param string $aMOUNT
     * @param string $sENDERNAME
     * @param string $rECEIVERNAME
     * @param string $rECEIVER_ADDRESS
     * @param float $pRICE
     * @param string $sHIPMENT_CODE
     */
    public function __construct($dOCUMENT_NUMBER = null, $dELIVERY_UNIT_NAME = null, $cARGO_TYPE = null, $aMOUNT = null, $sENDERNAME = null, $rECEIVERNAME = null, $rECEIVER_ADDRESS = null, $pRICE = null, $sHIPMENT_CODE = null)
    {
        $this
            ->setDOCUMENT_NUMBER($dOCUMENT_NUMBER)
            ->setDELIVERY_UNIT_NAME($dELIVERY_UNIT_NAME)
            ->setCARGO_TYPE($cARGO_TYPE)
            ->setAMOUNT($aMOUNT)
            ->setSENDERNAME($sENDERNAME)
            ->setRECEIVERNAME($rECEIVERNAME)
            ->setRECEIVER_ADDRESS($rECEIVER_ADDRESS)
            ->setPRICE($pRICE)
            ->setSHIPMENT_CODE($sHIPMENT_CODE);
    }
    /**
     * Get DOCUMENT_NUMBER value
     * @return string|null
     */
    public function getDOCUMENT_NUMBER()
    {
        return $this->DOCUMENT_NUMBER;
    }
    /**
     * Set DOCUMENT_NUMBER value
     * @param string $dOCUMENT_NUMBER
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setDOCUMENT_NUMBER($dOCUMENT_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($dOCUMENT_NUMBER) && !is_string($dOCUMENT_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOCUMENT_NUMBER, true), gettype($dOCUMENT_NUMBER)), __LINE__);
        }
        // validation for constraint: maxLength(11)
        if (!is_null($dOCUMENT_NUMBER) && mb_strlen($dOCUMENT_NUMBER) > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 11', mb_strlen($dOCUMENT_NUMBER)), __LINE__);
        }
        $this->DOCUMENT_NUMBER = $dOCUMENT_NUMBER;
        return $this;
    }
    /**
     * Get DELIVERY_UNIT_NAME value
     * @return string|null
     */
    public function getDELIVERY_UNIT_NAME()
    {
        return $this->DELIVERY_UNIT_NAME;
    }
    /**
     * Set DELIVERY_UNIT_NAME value
     * @param string $dELIVERY_UNIT_NAME
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setDELIVERY_UNIT_NAME($dELIVERY_UNIT_NAME = null)
    {
        // validation for constraint: string
        if (!is_null($dELIVERY_UNIT_NAME) && !is_string($dELIVERY_UNIT_NAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dELIVERY_UNIT_NAME, true), gettype($dELIVERY_UNIT_NAME)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($dELIVERY_UNIT_NAME) && mb_strlen($dELIVERY_UNIT_NAME) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($dELIVERY_UNIT_NAME)), __LINE__);
        }
        $this->DELIVERY_UNIT_NAME = $dELIVERY_UNIT_NAME;
        return $this;
    }
    /**
     * Get CARGO_TYPE value
     * @return string|null
     */
    public function getCARGO_TYPE()
    {
        return $this->CARGO_TYPE;
    }
    /**
     * Set CARGO_TYPE value
     * @param string $cARGO_TYPE
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setCARGO_TYPE($cARGO_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($cARGO_TYPE) && !is_string($cARGO_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cARGO_TYPE, true), gettype($cARGO_TYPE)), __LINE__);
        }
        $this->CARGO_TYPE = $cARGO_TYPE;
        return $this;
    }
    /**
     * Get AMOUNT value
     * @return string|null
     */
    public function getAMOUNT()
    {
        return $this->AMOUNT;
    }
    /**
     * Set AMOUNT value
     * @param string $aMOUNT
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setAMOUNT($aMOUNT = null)
    {
        // validation for constraint: string
        if (!is_null($aMOUNT) && !is_string($aMOUNT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aMOUNT, true), gettype($aMOUNT)), __LINE__);
        }
        // validation for constraint: maxLength(81)
        if (!is_null($aMOUNT) && mb_strlen($aMOUNT) > 81) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 81', mb_strlen($aMOUNT)), __LINE__);
        }
        $this->AMOUNT = $aMOUNT;
        return $this;
    }
    /**
     * Get SENDERNAME value
     * @return string|null
     */
    public function getSENDERNAME()
    {
        return $this->SENDERNAME;
    }
    /**
     * Set SENDERNAME value
     * @param string $sENDERNAME
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setSENDERNAME($sENDERNAME = null)
    {
        // validation for constraint: string
        if (!is_null($sENDERNAME) && !is_string($sENDERNAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sENDERNAME, true), gettype($sENDERNAME)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($sENDERNAME) && mb_strlen($sENDERNAME) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($sENDERNAME)), __LINE__);
        }
        $this->SENDERNAME = $sENDERNAME;
        return $this;
    }
    /**
     * Get RECEIVERNAME value
     * @return string|null
     */
    public function getRECEIVERNAME()
    {
        return $this->RECEIVERNAME;
    }
    /**
     * Set RECEIVERNAME value
     * @param string $rECEIVERNAME
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setRECEIVERNAME($rECEIVERNAME = null)
    {
        // validation for constraint: string
        if (!is_null($rECEIVERNAME) && !is_string($rECEIVERNAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rECEIVERNAME, true), gettype($rECEIVERNAME)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($rECEIVERNAME) && mb_strlen($rECEIVERNAME) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($rECEIVERNAME)), __LINE__);
        }
        $this->RECEIVERNAME = $rECEIVERNAME;
        return $this;
    }
    /**
     * Get RECEIVER_ADDRESS value
     * @return string|null
     */
    public function getRECEIVER_ADDRESS()
    {
        return $this->RECEIVER_ADDRESS;
    }
    /**
     * Set RECEIVER_ADDRESS value
     * @param string $rECEIVER_ADDRESS
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setRECEIVER_ADDRESS($rECEIVER_ADDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($rECEIVER_ADDRESS) && !is_string($rECEIVER_ADDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rECEIVER_ADDRESS, true), gettype($rECEIVER_ADDRESS)), __LINE__);
        }
        // validation for constraint: maxLength(129)
        if (!is_null($rECEIVER_ADDRESS) && mb_strlen($rECEIVER_ADDRESS) > 129) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 129', mb_strlen($rECEIVER_ADDRESS)), __LINE__);
        }
        $this->RECEIVER_ADDRESS = $rECEIVER_ADDRESS;
        return $this;
    }
    /**
     * Get PRICE value
     * @return float|null
     */
    public function getPRICE()
    {
        return $this->PRICE;
    }
    /**
     * Set PRICE value
     * @param float $pRICE
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setPRICE($pRICE = null)
    {
        // validation for constraint: float
        if (!is_null($pRICE) && !(is_float($pRICE) || is_numeric($pRICE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pRICE, true), gettype($pRICE)), __LINE__);
        }
        $this->PRICE = $pRICE;
        return $this;
    }
    /**
     * Get SHIPMENT_CODE value
     * @return string|null
     */
    public function getSHIPMENT_CODE()
    {
        return $this->SHIPMENT_CODE;
    }
    /**
     * Set SHIPMENT_CODE value
     * @param string $sHIPMENT_CODE
     * @return \Ys\ArasOrder\StructType\ShipmentSortInfo
     */
    public function setSHIPMENT_CODE($sHIPMENT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($sHIPMENT_CODE) && !is_string($sHIPMENT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sHIPMENT_CODE, true), gettype($sHIPMENT_CODE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($sHIPMENT_CODE) && mb_strlen($sHIPMENT_CODE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($sHIPMENT_CODE)), __LINE__);
        }
        $this->SHIPMENT_CODE = $sHIPMENT_CODE;
        return $this;
    }
}
