<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetOrder StructType
 * @subpackage Structs
 */
class SetOrder extends AbstractStructBase
{
    /**
     * The orderInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\ArasOrder\ArrayType\ArrayOfOrder
     */
    public $orderInfo;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for SetOrder
     * @uses SetOrder::setOrderInfo()
     * @uses SetOrder::setUserName()
     * @uses SetOrder::setPassword()
     * @param \Ys\ArasOrder\ArrayType\ArrayOfOrder $orderInfo
     * @param string $userName
     * @param string $password
     */
    public function __construct(\Ys\ArasOrder\ArrayType\ArrayOfOrder $orderInfo = null, $userName = null, $password = null)
    {
        $this
            ->setOrderInfo($orderInfo)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get orderInfo value
     * @return \Ys\ArasOrder\ArrayType\ArrayOfOrder|null
     */
    public function getOrderInfo()
    {
        return $this->orderInfo;
    }
    /**
     * Set orderInfo value
     * @param \Ys\ArasOrder\ArrayType\ArrayOfOrder $orderInfo
     * @return \Ys\ArasOrder\StructType\SetOrder
     */
    public function setOrderInfo(\Ys\ArasOrder\ArrayType\ArrayOfOrder $orderInfo = null)
    {
        $this->orderInfo = $orderInfo;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \Ys\ArasOrder\StructType\SetOrder
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\ArasOrder\StructType\SetOrder
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
}
