<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetAddress StructType
 * @subpackage Structs
 */
class SetAddress extends AbstractStructBase
{
    /**
     * The addressDtoList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\ArasOrder\ArrayType\ArrayOfAddressDto
     */
    public $addressDtoList;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for SetAddress
     * @uses SetAddress::setAddressDtoList()
     * @uses SetAddress::setUserName()
     * @uses SetAddress::setPassword()
     * @param \Ys\ArasOrder\ArrayType\ArrayOfAddressDto $addressDtoList
     * @param string $userName
     * @param string $password
     */
    public function __construct(\Ys\ArasOrder\ArrayType\ArrayOfAddressDto $addressDtoList = null, $userName = null, $password = null)
    {
        $this
            ->setAddressDtoList($addressDtoList)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get addressDtoList value
     * @return \Ys\ArasOrder\ArrayType\ArrayOfAddressDto|null
     */
    public function getAddressDtoList()
    {
        return $this->addressDtoList;
    }
    /**
     * Set addressDtoList value
     * @param \Ys\ArasOrder\ArrayType\ArrayOfAddressDto $addressDtoList
     * @return \Ys\ArasOrder\StructType\SetAddress
     */
    public function setAddressDtoList(\Ys\ArasOrder\ArrayType\ArrayOfAddressDto $addressDtoList = null)
    {
        $this->addressDtoList = $addressDtoList;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \Ys\ArasOrder\StructType\SetAddress
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\ArasOrder\StructType\SetAddress
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
}
