<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeferData StructType
 * @subpackage Structs
 */
class SeferData extends AbstractStructBase
{
    /**
     * The SEFER_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * @var string
     */
    public $SEFER_KODU;
    /**
     * The CIKIS_BIRIM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $CIKIS_BIRIM;
    /**
     * The VARIS_BIRIM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $VARIS_BIRIM;
    /**
     * The ARAC_TIPI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $ARAC_TIPI;
    /**
     * The KULLANIM_TIPI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 20
     * - minOccurs: 0
     * @var string
     */
    public $KULLANIM_TIPI;
    /**
     * The HAT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $HAT;
    /**
     * The CIKIS_TARIHI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 19
     * - minOccurs: 0
     * @var string
     */
    public $CIKIS_TARIHI;
    /**
     * The TOPLAM_KM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 4000
     * - minOccurs: 0
     * @var string
     */
    public $TOPLAM_KM;
    /**
     * The MALIYET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MALIYET;
    /**
     * The PLAKA
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $PLAKA;
    /**
     * The ARAC_KAPASITESI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ARAC_KAPASITESI;
    /**
     * The BITIS_ZAMANI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 19
     * - minOccurs: 0
     * @var string
     */
    public $BITIS_ZAMANI;
    /**
     * Constructor method for SeferData
     * @uses SeferData::setSEFER_KODU()
     * @uses SeferData::setCIKIS_BIRIM()
     * @uses SeferData::setVARIS_BIRIM()
     * @uses SeferData::setARAC_TIPI()
     * @uses SeferData::setKULLANIM_TIPI()
     * @uses SeferData::setHAT()
     * @uses SeferData::setCIKIS_TARIHI()
     * @uses SeferData::setTOPLAM_KM()
     * @uses SeferData::setMALIYET()
     * @uses SeferData::setPLAKA()
     * @uses SeferData::setARAC_KAPASITESI()
     * @uses SeferData::setBITIS_ZAMANI()
     * @param string $sEFER_KODU
     * @param string $cIKIS_BIRIM
     * @param string $vARIS_BIRIM
     * @param string $aRAC_TIPI
     * @param string $kULLANIM_TIPI
     * @param string $hAT
     * @param string $cIKIS_TARIHI
     * @param string $tOPLAM_KM
     * @param float $mALIYET
     * @param string $pLAKA
     * @param float $aRAC_KAPASITESI
     * @param string $bITIS_ZAMANI
     */
    public function __construct($sEFER_KODU = null, $cIKIS_BIRIM = null, $vARIS_BIRIM = null, $aRAC_TIPI = null, $kULLANIM_TIPI = null, $hAT = null, $cIKIS_TARIHI = null, $tOPLAM_KM = null, $mALIYET = null, $pLAKA = null, $aRAC_KAPASITESI = null, $bITIS_ZAMANI = null)
    {
        $this
            ->setSEFER_KODU($sEFER_KODU)
            ->setCIKIS_BIRIM($cIKIS_BIRIM)
            ->setVARIS_BIRIM($vARIS_BIRIM)
            ->setARAC_TIPI($aRAC_TIPI)
            ->setKULLANIM_TIPI($kULLANIM_TIPI)
            ->setHAT($hAT)
            ->setCIKIS_TARIHI($cIKIS_TARIHI)
            ->setTOPLAM_KM($tOPLAM_KM)
            ->setMALIYET($mALIYET)
            ->setPLAKA($pLAKA)
            ->setARAC_KAPASITESI($aRAC_KAPASITESI)
            ->setBITIS_ZAMANI($bITIS_ZAMANI);
    }
    /**
     * Get SEFER_KODU value
     * @return string|null
     */
    public function getSEFER_KODU()
    {
        return $this->SEFER_KODU;
    }
    /**
     * Set SEFER_KODU value
     * @param string $sEFER_KODU
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setSEFER_KODU($sEFER_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($sEFER_KODU) && !is_string($sEFER_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEFER_KODU, true), gettype($sEFER_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($sEFER_KODU) && mb_strlen($sEFER_KODU) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($sEFER_KODU)), __LINE__);
        }
        $this->SEFER_KODU = $sEFER_KODU;
        return $this;
    }
    /**
     * Get CIKIS_BIRIM value
     * @return string|null
     */
    public function getCIKIS_BIRIM()
    {
        return $this->CIKIS_BIRIM;
    }
    /**
     * Set CIKIS_BIRIM value
     * @param string $cIKIS_BIRIM
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setCIKIS_BIRIM($cIKIS_BIRIM = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_BIRIM) && !is_string($cIKIS_BIRIM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_BIRIM, true), gettype($cIKIS_BIRIM)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cIKIS_BIRIM) && mb_strlen($cIKIS_BIRIM) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($cIKIS_BIRIM)), __LINE__);
        }
        $this->CIKIS_BIRIM = $cIKIS_BIRIM;
        return $this;
    }
    /**
     * Get VARIS_BIRIM value
     * @return string|null
     */
    public function getVARIS_BIRIM()
    {
        return $this->VARIS_BIRIM;
    }
    /**
     * Set VARIS_BIRIM value
     * @param string $vARIS_BIRIM
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setVARIS_BIRIM($vARIS_BIRIM = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_BIRIM) && !is_string($vARIS_BIRIM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_BIRIM, true), gettype($vARIS_BIRIM)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($vARIS_BIRIM) && mb_strlen($vARIS_BIRIM) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($vARIS_BIRIM)), __LINE__);
        }
        $this->VARIS_BIRIM = $vARIS_BIRIM;
        return $this;
    }
    /**
     * Get ARAC_TIPI value
     * @return string|null
     */
    public function getARAC_TIPI()
    {
        return $this->ARAC_TIPI;
    }
    /**
     * Set ARAC_TIPI value
     * @param string $aRAC_TIPI
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setARAC_TIPI($aRAC_TIPI = null)
    {
        // validation for constraint: string
        if (!is_null($aRAC_TIPI) && !is_string($aRAC_TIPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aRAC_TIPI, true), gettype($aRAC_TIPI)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aRAC_TIPI) && mb_strlen($aRAC_TIPI) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aRAC_TIPI)), __LINE__);
        }
        $this->ARAC_TIPI = $aRAC_TIPI;
        return $this;
    }
    /**
     * Get KULLANIM_TIPI value
     * @return string|null
     */
    public function getKULLANIM_TIPI()
    {
        return $this->KULLANIM_TIPI;
    }
    /**
     * Set KULLANIM_TIPI value
     * @param string $kULLANIM_TIPI
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setKULLANIM_TIPI($kULLANIM_TIPI = null)
    {
        // validation for constraint: string
        if (!is_null($kULLANIM_TIPI) && !is_string($kULLANIM_TIPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kULLANIM_TIPI, true), gettype($kULLANIM_TIPI)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($kULLANIM_TIPI) && mb_strlen($kULLANIM_TIPI) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($kULLANIM_TIPI)), __LINE__);
        }
        $this->KULLANIM_TIPI = $kULLANIM_TIPI;
        return $this;
    }
    /**
     * Get HAT value
     * @return string|null
     */
    public function getHAT()
    {
        return $this->HAT;
    }
    /**
     * Set HAT value
     * @param string $hAT
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setHAT($hAT = null)
    {
        // validation for constraint: string
        if (!is_null($hAT) && !is_string($hAT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hAT, true), gettype($hAT)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($hAT) && mb_strlen($hAT) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($hAT)), __LINE__);
        }
        $this->HAT = $hAT;
        return $this;
    }
    /**
     * Get CIKIS_TARIHI value
     * @return string|null
     */
    public function getCIKIS_TARIHI()
    {
        return $this->CIKIS_TARIHI;
    }
    /**
     * Set CIKIS_TARIHI value
     * @param string $cIKIS_TARIHI
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setCIKIS_TARIHI($cIKIS_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_TARIHI) && !is_string($cIKIS_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_TARIHI, true), gettype($cIKIS_TARIHI)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($cIKIS_TARIHI) && mb_strlen($cIKIS_TARIHI) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($cIKIS_TARIHI)), __LINE__);
        }
        $this->CIKIS_TARIHI = $cIKIS_TARIHI;
        return $this;
    }
    /**
     * Get TOPLAM_KM value
     * @return string|null
     */
    public function getTOPLAM_KM()
    {
        return $this->TOPLAM_KM;
    }
    /**
     * Set TOPLAM_KM value
     * @param string $tOPLAM_KM
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setTOPLAM_KM($tOPLAM_KM = null)
    {
        // validation for constraint: string
        if (!is_null($tOPLAM_KM) && !is_string($tOPLAM_KM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tOPLAM_KM, true), gettype($tOPLAM_KM)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($tOPLAM_KM) && mb_strlen($tOPLAM_KM) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($tOPLAM_KM)), __LINE__);
        }
        $this->TOPLAM_KM = $tOPLAM_KM;
        return $this;
    }
    /**
     * Get MALIYET value
     * @return float|null
     */
    public function getMALIYET()
    {
        return $this->MALIYET;
    }
    /**
     * Set MALIYET value
     * @param float $mALIYET
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setMALIYET($mALIYET = null)
    {
        // validation for constraint: float
        if (!is_null($mALIYET) && !(is_float($mALIYET) || is_numeric($mALIYET))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mALIYET, true), gettype($mALIYET)), __LINE__);
        }
        $this->MALIYET = $mALIYET;
        return $this;
    }
    /**
     * Get PLAKA value
     * @return string|null
     */
    public function getPLAKA()
    {
        return $this->PLAKA;
    }
    /**
     * Set PLAKA value
     * @param string $pLAKA
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setPLAKA($pLAKA = null)
    {
        // validation for constraint: string
        if (!is_null($pLAKA) && !is_string($pLAKA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pLAKA, true), gettype($pLAKA)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pLAKA) && mb_strlen($pLAKA) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($pLAKA)), __LINE__);
        }
        $this->PLAKA = $pLAKA;
        return $this;
    }
    /**
     * Get ARAC_KAPASITESI value
     * @return float|null
     */
    public function getARAC_KAPASITESI()
    {
        return $this->ARAC_KAPASITESI;
    }
    /**
     * Set ARAC_KAPASITESI value
     * @param float $aRAC_KAPASITESI
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setARAC_KAPASITESI($aRAC_KAPASITESI = null)
    {
        // validation for constraint: float
        if (!is_null($aRAC_KAPASITESI) && !(is_float($aRAC_KAPASITESI) || is_numeric($aRAC_KAPASITESI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aRAC_KAPASITESI, true), gettype($aRAC_KAPASITESI)), __LINE__);
        }
        $this->ARAC_KAPASITESI = $aRAC_KAPASITESI;
        return $this;
    }
    /**
     * Get BITIS_ZAMANI value
     * @return string|null
     */
    public function getBITIS_ZAMANI()
    {
        return $this->BITIS_ZAMANI;
    }
    /**
     * Set BITIS_ZAMANI value
     * @param string $bITIS_ZAMANI
     * @return \Ys\ArasOrder\StructType\SeferData
     */
    public function setBITIS_ZAMANI($bITIS_ZAMANI = null)
    {
        // validation for constraint: string
        if (!is_null($bITIS_ZAMANI) && !is_string($bITIS_ZAMANI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bITIS_ZAMANI, true), gettype($bITIS_ZAMANI)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($bITIS_ZAMANI) && mb_strlen($bITIS_ZAMANI) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($bITIS_ZAMANI)), __LINE__);
        }
        $this->BITIS_ZAMANI = $bITIS_ZAMANI;
        return $this;
    }
}
