<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderPiecesResultInfo StructType
 * @subpackage Structs
 */
class OrderPiecesResultInfo extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * The BarcodeNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeNumber;
    /**
     * The IntegrationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegrationCode;
    /**
     * Constructor method for OrderPiecesResultInfo
     * @uses OrderPiecesResultInfo::setResultCode()
     * @uses OrderPiecesResultInfo::setResultMessage()
     * @uses OrderPiecesResultInfo::setBarcodeNumber()
     * @uses OrderPiecesResultInfo::setIntegrationCode()
     * @param string $resultCode
     * @param string $resultMessage
     * @param string $barcodeNumber
     * @param string $integrationCode
     */
    public function __construct($resultCode = null, $resultMessage = null, $barcodeNumber = null, $integrationCode = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage)
            ->setBarcodeNumber($barcodeNumber)
            ->setIntegrationCode($integrationCode);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \Ys\ArasOrder\StructType\OrderPiecesResultInfo
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \Ys\ArasOrder\StructType\OrderPiecesResultInfo
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get BarcodeNumber value
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->BarcodeNumber;
    }
    /**
     * Set BarcodeNumber value
     * @param string $barcodeNumber
     * @return \Ys\ArasOrder\StructType\OrderPiecesResultInfo
     */
    public function setBarcodeNumber($barcodeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeNumber) && !is_string($barcodeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeNumber, true), gettype($barcodeNumber)), __LINE__);
        }
        $this->BarcodeNumber = $barcodeNumber;
        return $this;
    }
    /**
     * Get IntegrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->IntegrationCode;
    }
    /**
     * Set IntegrationCode value
     * @param string $integrationCode
     * @return \Ys\ArasOrder\StructType\OrderPiecesResultInfo
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationCode, true), gettype($integrationCode)), __LINE__);
        }
        $this->IntegrationCode = $integrationCode;
        return $this;
    }
}
