<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingCargoInfo StructType
 * @subpackage Structs
 */
class IncomingCargoInfo extends AbstractStructBase
{
    /**
     * The DepartureUnitID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DepartureUnitID;
    /**
     * The DeliveryUnitID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryUnitID;
    /**
     * The TotalDesiKg
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDesiKg;
    /**
     * The TotalCargo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalCargo;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPrice;
    /**
     * The TotalVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalVat;
    /**
     * The TotalPriceVat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalPriceVat;
    /**
     * The DocCargoID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocCargoID;
    /**
     * The DocID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocID;
    /**
     * The DocNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocNumber;
    /**
     * The CargoType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CargoType;
    /**
     * The DepartureUnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartureUnitName;
    /**
     * The DocumentDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentDate;
    /**
     * The DocumentTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTime;
    /**
     * The DeliveryUnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryUnitName;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTime;
    /**
     * The DeliveryPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryPerson;
    /**
     * The OrgReceiverCustID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrgReceiverCustID;
    /**
     * The SenderCustID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderCustID;
    /**
     * The SenderCustName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderCustName;
    /**
     * The SenderCustAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderCustAddress;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The CustName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustName;
    /**
     * Constructor method for IncomingCargoInfo
     * @uses IncomingCargoInfo::setDepartureUnitID()
     * @uses IncomingCargoInfo::setDeliveryUnitID()
     * @uses IncomingCargoInfo::setTotalDesiKg()
     * @uses IncomingCargoInfo::setTotalCargo()
     * @uses IncomingCargoInfo::setTotalPrice()
     * @uses IncomingCargoInfo::setTotalVat()
     * @uses IncomingCargoInfo::setTotalPriceVat()
     * @uses IncomingCargoInfo::setDocCargoID()
     * @uses IncomingCargoInfo::setDocID()
     * @uses IncomingCargoInfo::setDocNumber()
     * @uses IncomingCargoInfo::setCargoType()
     * @uses IncomingCargoInfo::setDepartureUnitName()
     * @uses IncomingCargoInfo::setDocumentDate()
     * @uses IncomingCargoInfo::setDocumentTime()
     * @uses IncomingCargoInfo::setDeliveryUnitName()
     * @uses IncomingCargoInfo::setDeliveryDate()
     * @uses IncomingCargoInfo::setDeliveryTime()
     * @uses IncomingCargoInfo::setDeliveryPerson()
     * @uses IncomingCargoInfo::setOrgReceiverCustID()
     * @uses IncomingCargoInfo::setSenderCustID()
     * @uses IncomingCargoInfo::setSenderCustName()
     * @uses IncomingCargoInfo::setSenderCustAddress()
     * @uses IncomingCargoInfo::setPaymentType()
     * @uses IncomingCargoInfo::setCustName()
     * @param int $departureUnitID
     * @param int $deliveryUnitID
     * @param float $totalDesiKg
     * @param int $totalCargo
     * @param float $totalPrice
     * @param float $totalVat
     * @param float $totalPriceVat
     * @param string $docCargoID
     * @param string $docID
     * @param string $docNumber
     * @param string $cargoType
     * @param string $departureUnitName
     * @param string $documentDate
     * @param string $documentTime
     * @param string $deliveryUnitName
     * @param string $deliveryDate
     * @param string $deliveryTime
     * @param string $deliveryPerson
     * @param string $orgReceiverCustID
     * @param string $senderCustID
     * @param string $senderCustName
     * @param string $senderCustAddress
     * @param string $paymentType
     * @param string $custName
     */
    public function __construct($departureUnitID = null, $deliveryUnitID = null, $totalDesiKg = null, $totalCargo = null, $totalPrice = null, $totalVat = null, $totalPriceVat = null, $docCargoID = null, $docID = null, $docNumber = null, $cargoType = null, $departureUnitName = null, $documentDate = null, $documentTime = null, $deliveryUnitName = null, $deliveryDate = null, $deliveryTime = null, $deliveryPerson = null, $orgReceiverCustID = null, $senderCustID = null, $senderCustName = null, $senderCustAddress = null, $paymentType = null, $custName = null)
    {
        $this
            ->setDepartureUnitID($departureUnitID)
            ->setDeliveryUnitID($deliveryUnitID)
            ->setTotalDesiKg($totalDesiKg)
            ->setTotalCargo($totalCargo)
            ->setTotalPrice($totalPrice)
            ->setTotalVat($totalVat)
            ->setTotalPriceVat($totalPriceVat)
            ->setDocCargoID($docCargoID)
            ->setDocID($docID)
            ->setDocNumber($docNumber)
            ->setCargoType($cargoType)
            ->setDepartureUnitName($departureUnitName)
            ->setDocumentDate($documentDate)
            ->setDocumentTime($documentTime)
            ->setDeliveryUnitName($deliveryUnitName)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryTime($deliveryTime)
            ->setDeliveryPerson($deliveryPerson)
            ->setOrgReceiverCustID($orgReceiverCustID)
            ->setSenderCustID($senderCustID)
            ->setSenderCustName($senderCustName)
            ->setSenderCustAddress($senderCustAddress)
            ->setPaymentType($paymentType)
            ->setCustName($custName);
    }
    /**
     * Get DepartureUnitID value
     * @return int
     */
    public function getDepartureUnitID()
    {
        return $this->DepartureUnitID;
    }
    /**
     * Set DepartureUnitID value
     * @param int $departureUnitID
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDepartureUnitID($departureUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($departureUnitID) && !(is_int($departureUnitID) || ctype_digit($departureUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($departureUnitID, true), gettype($departureUnitID)), __LINE__);
        }
        $this->DepartureUnitID = $departureUnitID;
        return $this;
    }
    /**
     * Get DeliveryUnitID value
     * @return int
     */
    public function getDeliveryUnitID()
    {
        return $this->DeliveryUnitID;
    }
    /**
     * Set DeliveryUnitID value
     * @param int $deliveryUnitID
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDeliveryUnitID($deliveryUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryUnitID) && !(is_int($deliveryUnitID) || ctype_digit($deliveryUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryUnitID, true), gettype($deliveryUnitID)), __LINE__);
        }
        $this->DeliveryUnitID = $deliveryUnitID;
        return $this;
    }
    /**
     * Get TotalDesiKg value
     * @return float
     */
    public function getTotalDesiKg()
    {
        return $this->TotalDesiKg;
    }
    /**
     * Set TotalDesiKg value
     * @param float $totalDesiKg
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setTotalDesiKg($totalDesiKg = null)
    {
        // validation for constraint: float
        if (!is_null($totalDesiKg) && !(is_float($totalDesiKg) || is_numeric($totalDesiKg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDesiKg, true), gettype($totalDesiKg)), __LINE__);
        }
        $this->TotalDesiKg = $totalDesiKg;
        return $this;
    }
    /**
     * Get TotalCargo value
     * @return int
     */
    public function getTotalCargo()
    {
        return $this->TotalCargo;
    }
    /**
     * Set TotalCargo value
     * @param int $totalCargo
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setTotalCargo($totalCargo = null)
    {
        // validation for constraint: int
        if (!is_null($totalCargo) && !(is_int($totalCargo) || ctype_digit($totalCargo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalCargo, true), gettype($totalCargo)), __LINE__);
        }
        $this->TotalCargo = $totalCargo;
        return $this;
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get TotalVat value
     * @return float
     */
    public function getTotalVat()
    {
        return $this->TotalVat;
    }
    /**
     * Set TotalVat value
     * @param float $totalVat
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setTotalVat($totalVat = null)
    {
        // validation for constraint: float
        if (!is_null($totalVat) && !(is_float($totalVat) || is_numeric($totalVat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalVat, true), gettype($totalVat)), __LINE__);
        }
        $this->TotalVat = $totalVat;
        return $this;
    }
    /**
     * Get TotalPriceVat value
     * @return float
     */
    public function getTotalPriceVat()
    {
        return $this->TotalPriceVat;
    }
    /**
     * Set TotalPriceVat value
     * @param float $totalPriceVat
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setTotalPriceVat($totalPriceVat = null)
    {
        // validation for constraint: float
        if (!is_null($totalPriceVat) && !(is_float($totalPriceVat) || is_numeric($totalPriceVat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPriceVat, true), gettype($totalPriceVat)), __LINE__);
        }
        $this->TotalPriceVat = $totalPriceVat;
        return $this;
    }
    /**
     * Get DocCargoID value
     * @return string|null
     */
    public function getDocCargoID()
    {
        return $this->DocCargoID;
    }
    /**
     * Set DocCargoID value
     * @param string $docCargoID
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDocCargoID($docCargoID = null)
    {
        // validation for constraint: string
        if (!is_null($docCargoID) && !is_string($docCargoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docCargoID, true), gettype($docCargoID)), __LINE__);
        }
        $this->DocCargoID = $docCargoID;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: string
        if (!is_null($docID) && !is_string($docID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docID, true), gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get CargoType value
     * @return string|null
     */
    public function getCargoType()
    {
        return $this->CargoType;
    }
    /**
     * Set CargoType value
     * @param string $cargoType
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setCargoType($cargoType = null)
    {
        // validation for constraint: string
        if (!is_null($cargoType) && !is_string($cargoType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoType, true), gettype($cargoType)), __LINE__);
        }
        $this->CargoType = $cargoType;
        return $this;
    }
    /**
     * Get DepartureUnitName value
     * @return string|null
     */
    public function getDepartureUnitName()
    {
        return $this->DepartureUnitName;
    }
    /**
     * Set DepartureUnitName value
     * @param string $departureUnitName
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDepartureUnitName($departureUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($departureUnitName) && !is_string($departureUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureUnitName, true), gettype($departureUnitName)), __LINE__);
        }
        $this->DepartureUnitName = $departureUnitName;
        return $this;
    }
    /**
     * Get DocumentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->DocumentDate;
    }
    /**
     * Set DocumentDate value
     * @param string $documentDate
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDate, true), gettype($documentDate)), __LINE__);
        }
        $this->DocumentDate = $documentDate;
        return $this;
    }
    /**
     * Get DocumentTime value
     * @return string|null
     */
    public function getDocumentTime()
    {
        return $this->DocumentTime;
    }
    /**
     * Set DocumentTime value
     * @param string $documentTime
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDocumentTime($documentTime = null)
    {
        // validation for constraint: string
        if (!is_null($documentTime) && !is_string($documentTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTime, true), gettype($documentTime)), __LINE__);
        }
        $this->DocumentTime = $documentTime;
        return $this;
    }
    /**
     * Get DeliveryUnitName value
     * @return string|null
     */
    public function getDeliveryUnitName()
    {
        return $this->DeliveryUnitName;
    }
    /**
     * Set DeliveryUnitName value
     * @param string $deliveryUnitName
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDeliveryUnitName($deliveryUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryUnitName) && !is_string($deliveryUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryUnitName, true), gettype($deliveryUnitName)), __LINE__);
        }
        $this->DeliveryUnitName = $deliveryUnitName;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DeliveryTime value
     * @return string|null
     */
    public function getDeliveryTime()
    {
        return $this->DeliveryTime;
    }
    /**
     * Set DeliveryTime value
     * @param string $deliveryTime
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDeliveryTime($deliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTime) && !is_string($deliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTime, true), gettype($deliveryTime)), __LINE__);
        }
        $this->DeliveryTime = $deliveryTime;
        return $this;
    }
    /**
     * Get DeliveryPerson value
     * @return string|null
     */
    public function getDeliveryPerson()
    {
        return $this->DeliveryPerson;
    }
    /**
     * Set DeliveryPerson value
     * @param string $deliveryPerson
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setDeliveryPerson($deliveryPerson = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPerson) && !is_string($deliveryPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPerson, true), gettype($deliveryPerson)), __LINE__);
        }
        $this->DeliveryPerson = $deliveryPerson;
        return $this;
    }
    /**
     * Get OrgReceiverCustID value
     * @return string|null
     */
    public function getOrgReceiverCustID()
    {
        return $this->OrgReceiverCustID;
    }
    /**
     * Set OrgReceiverCustID value
     * @param string $orgReceiverCustID
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setOrgReceiverCustID($orgReceiverCustID = null)
    {
        // validation for constraint: string
        if (!is_null($orgReceiverCustID) && !is_string($orgReceiverCustID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgReceiverCustID, true), gettype($orgReceiverCustID)), __LINE__);
        }
        $this->OrgReceiverCustID = $orgReceiverCustID;
        return $this;
    }
    /**
     * Get SenderCustID value
     * @return string|null
     */
    public function getSenderCustID()
    {
        return $this->SenderCustID;
    }
    /**
     * Set SenderCustID value
     * @param string $senderCustID
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setSenderCustID($senderCustID = null)
    {
        // validation for constraint: string
        if (!is_null($senderCustID) && !is_string($senderCustID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderCustID, true), gettype($senderCustID)), __LINE__);
        }
        $this->SenderCustID = $senderCustID;
        return $this;
    }
    /**
     * Get SenderCustName value
     * @return string|null
     */
    public function getSenderCustName()
    {
        return $this->SenderCustName;
    }
    /**
     * Set SenderCustName value
     * @param string $senderCustName
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setSenderCustName($senderCustName = null)
    {
        // validation for constraint: string
        if (!is_null($senderCustName) && !is_string($senderCustName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderCustName, true), gettype($senderCustName)), __LINE__);
        }
        $this->SenderCustName = $senderCustName;
        return $this;
    }
    /**
     * Get SenderCustAddress value
     * @return string|null
     */
    public function getSenderCustAddress()
    {
        return $this->SenderCustAddress;
    }
    /**
     * Set SenderCustAddress value
     * @param string $senderCustAddress
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setSenderCustAddress($senderCustAddress = null)
    {
        // validation for constraint: string
        if (!is_null($senderCustAddress) && !is_string($senderCustAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderCustAddress, true), gettype($senderCustAddress)), __LINE__);
        }
        $this->SenderCustAddress = $senderCustAddress;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get CustName value
     * @return string|null
     */
    public function getCustName()
    {
        return $this->CustName;
    }
    /**
     * Set CustName value
     * @param string $custName
     * @return \Ys\ArasOrder\StructType\IncomingCargoInfo
     */
    public function setCustName($custName = null)
    {
        // validation for constraint: string
        if (!is_null($custName) && !is_string($custName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custName, true), gettype($custName)), __LINE__);
        }
        $this->CustName = $custName;
        return $this;
    }
}
