<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HINTTOWN StructType
 * @subpackage Structs
 */
class HINTTOWN extends AbstractStructBase
{
    /**
     * The ILCE_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $ILCE_ADI;
    /**
     * The ILCE_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $ILCE_KODU;
    /**
     * The HINTTOWNID
     * @var string
     */
    public $HINTTOWNID;
    /**
     * Constructor method for HINTTOWN
     * @uses HINTTOWN::setILCE_ADI()
     * @uses HINTTOWN::setILCE_KODU()
     * @uses HINTTOWN::setHINTTOWNID()
     * @param string $iLCE_ADI
     * @param string $iLCE_KODU
     * @param string $hINTTOWNID
     */
    public function __construct($iLCE_ADI = null, $iLCE_KODU = null, $hINTTOWNID = null)
    {
        $this
            ->setILCE_ADI($iLCE_ADI)
            ->setILCE_KODU($iLCE_KODU)
            ->setHINTTOWNID($hINTTOWNID);
    }
    /**
     * Get ILCE_ADI value
     * @return string|null
     */
    public function getILCE_ADI()
    {
        return $this->ILCE_ADI;
    }
    /**
     * Set ILCE_ADI value
     * @param string $iLCE_ADI
     * @return \Ys\ArasOrder\StructType\HINTTOWN
     */
    public function setILCE_ADI($iLCE_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($iLCE_ADI) && !is_string($iLCE_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iLCE_ADI, true), gettype($iLCE_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($iLCE_ADI) && mb_strlen($iLCE_ADI) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($iLCE_ADI)), __LINE__);
        }
        $this->ILCE_ADI = $iLCE_ADI;
        return $this;
    }
    /**
     * Get ILCE_KODU value
     * @return string|null
     */
    public function getILCE_KODU()
    {
        return $this->ILCE_KODU;
    }
    /**
     * Set ILCE_KODU value
     * @param string $iLCE_KODU
     * @return \Ys\ArasOrder\StructType\HINTTOWN
     */
    public function setILCE_KODU($iLCE_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($iLCE_KODU) && !is_string($iLCE_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iLCE_KODU, true), gettype($iLCE_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($iLCE_KODU) && mb_strlen($iLCE_KODU) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($iLCE_KODU)), __LINE__);
        }
        $this->ILCE_KODU = $iLCE_KODU;
        return $this;
    }
    /**
     * Get HINTTOWNID value
     * @return string|null
     */
    public function getHINTTOWNID()
    {
        return $this->HINTTOWNID;
    }
    /**
     * Set HINTTOWNID value
     * @param string $hINTTOWNID
     * @return \Ys\ArasOrder\StructType\HINTTOWN
     */
    public function setHINTTOWNID($hINTTOWNID = null)
    {
        // validation for constraint: string
        if (!is_null($hINTTOWNID) && !is_string($hINTTOWNID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hINTTOWNID, true), gettype($hINTTOWNID)), __LINE__);
        }
        $this->HINTTOWNID = $hINTTOWNID;
        return $this;
    }
}
