<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GunlukDesi StructType
 * @subpackage Structs
 */
class GunlukDesi extends AbstractStructBase
{
    /**
     * The CIKIS_TM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $CIKIS_TM;
    /**
     * The VARIS_TM
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $VARIS_TM;
    /**
     * The TARIH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TARIH;
    /**
     * The DESI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * Constructor method for GunlukDesi
     * @uses GunlukDesi::setCIKIS_TM()
     * @uses GunlukDesi::setVARIS_TM()
     * @uses GunlukDesi::setTARIH()
     * @uses GunlukDesi::setDESI()
     * @param string $cIKIS_TM
     * @param string $vARIS_TM
     * @param string $tARIH
     * @param float $dESI
     */
    public function __construct($cIKIS_TM = null, $vARIS_TM = null, $tARIH = null, $dESI = null)
    {
        $this
            ->setCIKIS_TM($cIKIS_TM)
            ->setVARIS_TM($vARIS_TM)
            ->setTARIH($tARIH)
            ->setDESI($dESI);
    }
    /**
     * Get CIKIS_TM value
     * @return string|null
     */
    public function getCIKIS_TM()
    {
        return $this->CIKIS_TM;
    }
    /**
     * Set CIKIS_TM value
     * @param string $cIKIS_TM
     * @return \Ys\ArasOrder\StructType\GunlukDesi
     */
    public function setCIKIS_TM($cIKIS_TM = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_TM) && !is_string($cIKIS_TM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_TM, true), gettype($cIKIS_TM)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($cIKIS_TM) && mb_strlen($cIKIS_TM) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($cIKIS_TM)), __LINE__);
        }
        $this->CIKIS_TM = $cIKIS_TM;
        return $this;
    }
    /**
     * Get VARIS_TM value
     * @return string|null
     */
    public function getVARIS_TM()
    {
        return $this->VARIS_TM;
    }
    /**
     * Set VARIS_TM value
     * @param string $vARIS_TM
     * @return \Ys\ArasOrder\StructType\GunlukDesi
     */
    public function setVARIS_TM($vARIS_TM = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_TM) && !is_string($vARIS_TM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_TM, true), gettype($vARIS_TM)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($vARIS_TM) && mb_strlen($vARIS_TM) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($vARIS_TM)), __LINE__);
        }
        $this->VARIS_TM = $vARIS_TM;
        return $this;
    }
    /**
     * Get TARIH value
     * @return string|null
     */
    public function getTARIH()
    {
        return $this->TARIH;
    }
    /**
     * Set TARIH value
     * @param string $tARIH
     * @return \Ys\ArasOrder\StructType\GunlukDesi
     */
    public function setTARIH($tARIH = null)
    {
        // validation for constraint: string
        if (!is_null($tARIH) && !is_string($tARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tARIH, true), gettype($tARIH)), __LINE__);
        }
        $this->TARIH = $tARIH;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \Ys\ArasOrder\StructType\GunlukDesi
     */
    public function setDESI($dESI = null)
    {
        // validation for constraint: float
        if (!is_null($dESI) && !(is_float($dESI) || is_numeric($dESI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dESI, true), gettype($dESI)), __LINE__);
        }
        $this->DESI = $dESI;
        return $this;
    }
}
