<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServiceType StructType
 * @subpackage Structs
 */
class GetServiceType extends AbstractStructBase
{
    /**
     * The service
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $service;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for GetServiceType
     * @uses GetServiceType::setService()
     * @uses GetServiceType::setUsername()
     * @uses GetServiceType::setPassword()
     * @param float $service
     * @param string $username
     * @param string $password
     */
    public function __construct($service = null, $username = null, $password = null)
    {
        $this
            ->setService($service)
            ->setUsername($username)
            ->setPassword($password);
    }
    /**
     * Get service value
     * @return float
     */
    public function getService()
    {
        return $this->service;
    }
    /**
     * Set service value
     * @param float $service
     * @return \Ys\ArasOrder\StructType\GetServiceType
     */
    public function setService($service = null)
    {
        // validation for constraint: float
        if (!is_null($service) && !(is_float($service) || is_numeric($service))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        $this->service = $service;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Ys\ArasOrder\StructType\GetServiceType
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\ArasOrder\StructType\GetServiceType
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
}
