<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCargoInfo StructType
 * @subpackage Structs
 */
class GetCargoInfo extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The customerCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerCode;
    /**
     * The integrationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $integrationCode;
    /**
     * Constructor method for GetCargoInfo
     * @uses GetCargoInfo::setUsername()
     * @uses GetCargoInfo::setPassword()
     * @uses GetCargoInfo::setCustomerCode()
     * @uses GetCargoInfo::setIntegrationCode()
     * @param string $username
     * @param string $password
     * @param string $customerCode
     * @param string $integrationCode
     */
    public function __construct($username = null, $password = null, $customerCode = null, $integrationCode = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setCustomerCode($customerCode)
            ->setIntegrationCode($integrationCode);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \Ys\ArasOrder\StructType\GetCargoInfo
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\ArasOrder\StructType\GetCargoInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get customerCode value
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->customerCode;
    }
    /**
     * Set customerCode value
     * @param string $customerCode
     * @return \Ys\ArasOrder\StructType\GetCargoInfo
     */
    public function setCustomerCode($customerCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerCode) && !is_string($customerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCode, true), gettype($customerCode)), __LINE__);
        }
        $this->customerCode = $customerCode;
        return $this;
    }
    /**
     * Get integrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->integrationCode;
    }
    /**
     * Set integrationCode value
     * @param string $integrationCode
     * @return \Ys\ArasOrder\StructType\GetCargoInfo
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationCode, true), gettype($integrationCode)), __LINE__);
        }
        $this->integrationCode = $integrationCode;
        return $this;
    }
}
