<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DispatchResultInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DispatchResultInfo
 * @subpackage Structs
 */
class DispatchResultInfo extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * The CargoKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CargoKey;
    /**
     * Constructor method for DispatchResultInfo
     * @uses DispatchResultInfo::setResultCode()
     * @uses DispatchResultInfo::setResultMessage()
     * @uses DispatchResultInfo::setCargoKey()
     * @param string $resultCode
     * @param string $resultMessage
     * @param string $cargoKey
     */
    public function __construct($resultCode = null, $resultMessage = null, $cargoKey = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage)
            ->setCargoKey($cargoKey);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \Ys\ArasOrder\StructType\DispatchResultInfo
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \Ys\ArasOrder\StructType\DispatchResultInfo
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get CargoKey value
     * @return string|null
     */
    public function getCargoKey()
    {
        return $this->CargoKey;
    }
    /**
     * Set CargoKey value
     * @param string $cargoKey
     * @return \Ys\ArasOrder\StructType\DispatchResultInfo
     */
    public function setCargoKey($cargoKey = null)
    {
        // validation for constraint: string
        if (!is_null($cargoKey) && !is_string($cargoKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cargoKey, true), gettype($cargoKey)), __LINE__);
        }
        $this->CargoKey = $cargoKey;
        return $this;
    }
}
