<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryInfo StructType
 * @subpackage Structs
 */
class DeliveryInfo extends AbstractStructBase
{
    /**
     * The OrgDocNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrgDocNumber;
    /**
     * The DocID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocID;
    /**
     * The DeliveryUnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryUnitName;
    /**
     * The ArrivalDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ArrivalDate;
    /**
     * The DeliveryDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryDate;
    /**
     * The DeliveryTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryTime;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryAddress;
    /**
     * The DeliveryPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryPerson;
    /**
     * The DeliveryAddressStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryAddressStatus;
    /**
     * The DeliveryStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryStatus;
    /**
     * The StatusFlag
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusFlag;
    /**
     * The LastWarehouseDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastWarehouseDate;
    /**
     * The WarehouseDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseDescription;
    /**
     * The WarehouseReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WarehouseReason;
    /**
     * The AtzDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AtzDateTime;
    /**
     * The DeliverySmsCreate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliverySmsCreate;
    /**
     * The DeliverySmsSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliverySmsSend;
    /**
     * The NotDeliveredSmsCreate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotDeliveredSmsCreate;
    /**
     * The NotDeliveredSmsSend
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotDeliveredSmsSend;
    /**
     * The NotDeliveredReason
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NotDeliveredReason;
    /**
     * The CallDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallDate;
    /**
     * The CallDesc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallDesc;
    /**
     * The CallResult
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallResult;
    /**
     * Constructor method for DeliveryInfo
     * @uses DeliveryInfo::setOrgDocNumber()
     * @uses DeliveryInfo::setDocID()
     * @uses DeliveryInfo::setDeliveryUnitName()
     * @uses DeliveryInfo::setArrivalDate()
     * @uses DeliveryInfo::setDeliveryDate()
     * @uses DeliveryInfo::setDeliveryTime()
     * @uses DeliveryInfo::setDeliveryAddress()
     * @uses DeliveryInfo::setDeliveryPerson()
     * @uses DeliveryInfo::setDeliveryAddressStatus()
     * @uses DeliveryInfo::setDeliveryStatus()
     * @uses DeliveryInfo::setStatusFlag()
     * @uses DeliveryInfo::setLastWarehouseDate()
     * @uses DeliveryInfo::setWarehouseDescription()
     * @uses DeliveryInfo::setWarehouseReason()
     * @uses DeliveryInfo::setAtzDateTime()
     * @uses DeliveryInfo::setDeliverySmsCreate()
     * @uses DeliveryInfo::setDeliverySmsSend()
     * @uses DeliveryInfo::setNotDeliveredSmsCreate()
     * @uses DeliveryInfo::setNotDeliveredSmsSend()
     * @uses DeliveryInfo::setNotDeliveredReason()
     * @uses DeliveryInfo::setCallDate()
     * @uses DeliveryInfo::setCallDesc()
     * @uses DeliveryInfo::setCallResult()
     * @param string $orgDocNumber
     * @param string $docID
     * @param string $deliveryUnitName
     * @param string $arrivalDate
     * @param string $deliveryDate
     * @param string $deliveryTime
     * @param string $deliveryAddress
     * @param string $deliveryPerson
     * @param string $deliveryAddressStatus
     * @param string $deliveryStatus
     * @param string $statusFlag
     * @param string $lastWarehouseDate
     * @param string $warehouseDescription
     * @param string $warehouseReason
     * @param string $atzDateTime
     * @param string $deliverySmsCreate
     * @param string $deliverySmsSend
     * @param string $notDeliveredSmsCreate
     * @param string $notDeliveredSmsSend
     * @param string $notDeliveredReason
     * @param string $callDate
     * @param string $callDesc
     * @param string $callResult
     */
    public function __construct($orgDocNumber = null, $docID = null, $deliveryUnitName = null, $arrivalDate = null, $deliveryDate = null, $deliveryTime = null, $deliveryAddress = null, $deliveryPerson = null, $deliveryAddressStatus = null, $deliveryStatus = null, $statusFlag = null, $lastWarehouseDate = null, $warehouseDescription = null, $warehouseReason = null, $atzDateTime = null, $deliverySmsCreate = null, $deliverySmsSend = null, $notDeliveredSmsCreate = null, $notDeliveredSmsSend = null, $notDeliveredReason = null, $callDate = null, $callDesc = null, $callResult = null)
    {
        $this
            ->setOrgDocNumber($orgDocNumber)
            ->setDocID($docID)
            ->setDeliveryUnitName($deliveryUnitName)
            ->setArrivalDate($arrivalDate)
            ->setDeliveryDate($deliveryDate)
            ->setDeliveryTime($deliveryTime)
            ->setDeliveryAddress($deliveryAddress)
            ->setDeliveryPerson($deliveryPerson)
            ->setDeliveryAddressStatus($deliveryAddressStatus)
            ->setDeliveryStatus($deliveryStatus)
            ->setStatusFlag($statusFlag)
            ->setLastWarehouseDate($lastWarehouseDate)
            ->setWarehouseDescription($warehouseDescription)
            ->setWarehouseReason($warehouseReason)
            ->setAtzDateTime($atzDateTime)
            ->setDeliverySmsCreate($deliverySmsCreate)
            ->setDeliverySmsSend($deliverySmsSend)
            ->setNotDeliveredSmsCreate($notDeliveredSmsCreate)
            ->setNotDeliveredSmsSend($notDeliveredSmsSend)
            ->setNotDeliveredReason($notDeliveredReason)
            ->setCallDate($callDate)
            ->setCallDesc($callDesc)
            ->setCallResult($callResult);
    }
    /**
     * Get OrgDocNumber value
     * @return string|null
     */
    public function getOrgDocNumber()
    {
        return $this->OrgDocNumber;
    }
    /**
     * Set OrgDocNumber value
     * @param string $orgDocNumber
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setOrgDocNumber($orgDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($orgDocNumber) && !is_string($orgDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgDocNumber, true), gettype($orgDocNumber)), __LINE__);
        }
        $this->OrgDocNumber = $orgDocNumber;
        return $this;
    }
    /**
     * Get DocID value
     * @return string|null
     */
    public function getDocID()
    {
        return $this->DocID;
    }
    /**
     * Set DocID value
     * @param string $docID
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDocID($docID = null)
    {
        // validation for constraint: string
        if (!is_null($docID) && !is_string($docID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docID, true), gettype($docID)), __LINE__);
        }
        $this->DocID = $docID;
        return $this;
    }
    /**
     * Get DeliveryUnitName value
     * @return string|null
     */
    public function getDeliveryUnitName()
    {
        return $this->DeliveryUnitName;
    }
    /**
     * Set DeliveryUnitName value
     * @param string $deliveryUnitName
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliveryUnitName($deliveryUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryUnitName) && !is_string($deliveryUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryUnitName, true), gettype($deliveryUnitName)), __LINE__);
        }
        $this->DeliveryUnitName = $deliveryUnitName;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @param string $arrivalDate
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setArrivalDate($arrivalDate = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDate) && !is_string($arrivalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDate, true), gettype($arrivalDate)), __LINE__);
        }
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Get DeliveryDate value
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->DeliveryDate;
    }
    /**
     * Set DeliveryDate value
     * @param string $deliveryDate
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliveryDate($deliveryDate = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryDate) && !is_string($deliveryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryDate, true), gettype($deliveryDate)), __LINE__);
        }
        $this->DeliveryDate = $deliveryDate;
        return $this;
    }
    /**
     * Get DeliveryTime value
     * @return string|null
     */
    public function getDeliveryTime()
    {
        return $this->DeliveryTime;
    }
    /**
     * Set DeliveryTime value
     * @param string $deliveryTime
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliveryTime($deliveryTime = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTime) && !is_string($deliveryTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryTime, true), gettype($deliveryTime)), __LINE__);
        }
        $this->DeliveryTime = $deliveryTime;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param string $deliveryAddress
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliveryAddress($deliveryAddress = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddress) && !is_string($deliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddress, true), gettype($deliveryAddress)), __LINE__);
        }
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Get DeliveryPerson value
     * @return string|null
     */
    public function getDeliveryPerson()
    {
        return $this->DeliveryPerson;
    }
    /**
     * Set DeliveryPerson value
     * @param string $deliveryPerson
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliveryPerson($deliveryPerson = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryPerson) && !is_string($deliveryPerson)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryPerson, true), gettype($deliveryPerson)), __LINE__);
        }
        $this->DeliveryPerson = $deliveryPerson;
        return $this;
    }
    /**
     * Get DeliveryAddressStatus value
     * @return string|null
     */
    public function getDeliveryAddressStatus()
    {
        return $this->DeliveryAddressStatus;
    }
    /**
     * Set DeliveryAddressStatus value
     * @param string $deliveryAddressStatus
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliveryAddressStatus($deliveryAddressStatus = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryAddressStatus) && !is_string($deliveryAddressStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryAddressStatus, true), gettype($deliveryAddressStatus)), __LINE__);
        }
        $this->DeliveryAddressStatus = $deliveryAddressStatus;
        return $this;
    }
    /**
     * Get DeliveryStatus value
     * @return string|null
     */
    public function getDeliveryStatus()
    {
        return $this->DeliveryStatus;
    }
    /**
     * Set DeliveryStatus value
     * @param string $deliveryStatus
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliveryStatus($deliveryStatus = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryStatus) && !is_string($deliveryStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryStatus, true), gettype($deliveryStatus)), __LINE__);
        }
        $this->DeliveryStatus = $deliveryStatus;
        return $this;
    }
    /**
     * Get StatusFlag value
     * @return string|null
     */
    public function getStatusFlag()
    {
        return $this->StatusFlag;
    }
    /**
     * Set StatusFlag value
     * @param string $statusFlag
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setStatusFlag($statusFlag = null)
    {
        // validation for constraint: string
        if (!is_null($statusFlag) && !is_string($statusFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusFlag, true), gettype($statusFlag)), __LINE__);
        }
        $this->StatusFlag = $statusFlag;
        return $this;
    }
    /**
     * Get LastWarehouseDate value
     * @return string|null
     */
    public function getLastWarehouseDate()
    {
        return $this->LastWarehouseDate;
    }
    /**
     * Set LastWarehouseDate value
     * @param string $lastWarehouseDate
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setLastWarehouseDate($lastWarehouseDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastWarehouseDate) && !is_string($lastWarehouseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastWarehouseDate, true), gettype($lastWarehouseDate)), __LINE__);
        }
        $this->LastWarehouseDate = $lastWarehouseDate;
        return $this;
    }
    /**
     * Get WarehouseDescription value
     * @return string|null
     */
    public function getWarehouseDescription()
    {
        return $this->WarehouseDescription;
    }
    /**
     * Set WarehouseDescription value
     * @param string $warehouseDescription
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setWarehouseDescription($warehouseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseDescription) && !is_string($warehouseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseDescription, true), gettype($warehouseDescription)), __LINE__);
        }
        $this->WarehouseDescription = $warehouseDescription;
        return $this;
    }
    /**
     * Get WarehouseReason value
     * @return string|null
     */
    public function getWarehouseReason()
    {
        return $this->WarehouseReason;
    }
    /**
     * Set WarehouseReason value
     * @param string $warehouseReason
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setWarehouseReason($warehouseReason = null)
    {
        // validation for constraint: string
        if (!is_null($warehouseReason) && !is_string($warehouseReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warehouseReason, true), gettype($warehouseReason)), __LINE__);
        }
        $this->WarehouseReason = $warehouseReason;
        return $this;
    }
    /**
     * Get AtzDateTime value
     * @return string|null
     */
    public function getAtzDateTime()
    {
        return $this->AtzDateTime;
    }
    /**
     * Set AtzDateTime value
     * @param string $atzDateTime
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setAtzDateTime($atzDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($atzDateTime) && !is_string($atzDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($atzDateTime, true), gettype($atzDateTime)), __LINE__);
        }
        $this->AtzDateTime = $atzDateTime;
        return $this;
    }
    /**
     * Get DeliverySmsCreate value
     * @return string|null
     */
    public function getDeliverySmsCreate()
    {
        return $this->DeliverySmsCreate;
    }
    /**
     * Set DeliverySmsCreate value
     * @param string $deliverySmsCreate
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliverySmsCreate($deliverySmsCreate = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySmsCreate) && !is_string($deliverySmsCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverySmsCreate, true), gettype($deliverySmsCreate)), __LINE__);
        }
        $this->DeliverySmsCreate = $deliverySmsCreate;
        return $this;
    }
    /**
     * Get DeliverySmsSend value
     * @return string|null
     */
    public function getDeliverySmsSend()
    {
        return $this->DeliverySmsSend;
    }
    /**
     * Set DeliverySmsSend value
     * @param string $deliverySmsSend
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setDeliverySmsSend($deliverySmsSend = null)
    {
        // validation for constraint: string
        if (!is_null($deliverySmsSend) && !is_string($deliverySmsSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliverySmsSend, true), gettype($deliverySmsSend)), __LINE__);
        }
        $this->DeliverySmsSend = $deliverySmsSend;
        return $this;
    }
    /**
     * Get NotDeliveredSmsCreate value
     * @return string|null
     */
    public function getNotDeliveredSmsCreate()
    {
        return $this->NotDeliveredSmsCreate;
    }
    /**
     * Set NotDeliveredSmsCreate value
     * @param string $notDeliveredSmsCreate
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setNotDeliveredSmsCreate($notDeliveredSmsCreate = null)
    {
        // validation for constraint: string
        if (!is_null($notDeliveredSmsCreate) && !is_string($notDeliveredSmsCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notDeliveredSmsCreate, true), gettype($notDeliveredSmsCreate)), __LINE__);
        }
        $this->NotDeliveredSmsCreate = $notDeliveredSmsCreate;
        return $this;
    }
    /**
     * Get NotDeliveredSmsSend value
     * @return string|null
     */
    public function getNotDeliveredSmsSend()
    {
        return $this->NotDeliveredSmsSend;
    }
    /**
     * Set NotDeliveredSmsSend value
     * @param string $notDeliveredSmsSend
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setNotDeliveredSmsSend($notDeliveredSmsSend = null)
    {
        // validation for constraint: string
        if (!is_null($notDeliveredSmsSend) && !is_string($notDeliveredSmsSend)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notDeliveredSmsSend, true), gettype($notDeliveredSmsSend)), __LINE__);
        }
        $this->NotDeliveredSmsSend = $notDeliveredSmsSend;
        return $this;
    }
    /**
     * Get NotDeliveredReason value
     * @return string|null
     */
    public function getNotDeliveredReason()
    {
        return $this->NotDeliveredReason;
    }
    /**
     * Set NotDeliveredReason value
     * @param string $notDeliveredReason
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setNotDeliveredReason($notDeliveredReason = null)
    {
        // validation for constraint: string
        if (!is_null($notDeliveredReason) && !is_string($notDeliveredReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notDeliveredReason, true), gettype($notDeliveredReason)), __LINE__);
        }
        $this->NotDeliveredReason = $notDeliveredReason;
        return $this;
    }
    /**
     * Get CallDate value
     * @return string|null
     */
    public function getCallDate()
    {
        return $this->CallDate;
    }
    /**
     * Set CallDate value
     * @param string $callDate
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setCallDate($callDate = null)
    {
        // validation for constraint: string
        if (!is_null($callDate) && !is_string($callDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callDate, true), gettype($callDate)), __LINE__);
        }
        $this->CallDate = $callDate;
        return $this;
    }
    /**
     * Get CallDesc value
     * @return string|null
     */
    public function getCallDesc()
    {
        return $this->CallDesc;
    }
    /**
     * Set CallDesc value
     * @param string $callDesc
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setCallDesc($callDesc = null)
    {
        // validation for constraint: string
        if (!is_null($callDesc) && !is_string($callDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callDesc, true), gettype($callDesc)), __LINE__);
        }
        $this->CallDesc = $callDesc;
        return $this;
    }
    /**
     * Get CallResult value
     * @return string|null
     */
    public function getCallResult()
    {
        return $this->CallResult;
    }
    /**
     * Set CallResult value
     * @param string $callResult
     * @return \Ys\ArasOrder\StructType\DeliveryInfo
     */
    public function setCallResult($callResult = null)
    {
        // validation for constraint: string
        if (!is_null($callResult) && !is_string($callResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callResult, true), gettype($callResult)), __LINE__);
        }
        $this->CallResult = $callResult;
        return $this;
    }
}
