<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DIRECTION StructType
 * @subpackage Structs
 */
class DIRECTION extends AbstractStructBase
{
    /**
     * The DIRECTIONID
     * @var float
     */
    public $DIRECTIONID;
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * @var string
     */
    public $NAME;
    /**
     * The SHORT_CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $SHORT_CODE;
    /**
     * The AUDIT_CREATE_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDITCREATEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The AUDITMODIFIEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_DELETED
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The APPLICATION_VERSION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The APPLICATIONID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The CODE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CODE;
    /**
     * Constructor method for DIRECTION
     * @uses DIRECTION::setDIRECTIONID()
     * @uses DIRECTION::setNAME()
     * @uses DIRECTION::setSHORT_CODE()
     * @uses DIRECTION::setAUDIT_CREATE_DATE()
     * @uses DIRECTION::setAUDITCREATEDBY()
     * @uses DIRECTION::setAUDITCREATEUNITID()
     * @uses DIRECTION::setAUDIT_MODIFY_DATE()
     * @uses DIRECTION::setAUDITMODIFIEDBY()
     * @uses DIRECTION::setAUDITMODIFYUNITID()
     * @uses DIRECTION::setAUDIT_DELETED()
     * @uses DIRECTION::setAPPLICATION_VERSION()
     * @uses DIRECTION::setAPPLICATIONID()
     * @uses DIRECTION::setCODE()
     * @param float $dIRECTIONID
     * @param string $nAME
     * @param string $sHORT_CODE
     * @param string $aUDIT_CREATE_DATE
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param string $aUDIT_MODIFY_DATE
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_DELETED
     * @param string $aPPLICATION_VERSION
     * @param float $aPPLICATIONID
     * @param float $cODE
     */
    public function __construct($dIRECTIONID = null, $nAME = null, $sHORT_CODE = null, $aUDIT_CREATE_DATE = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDIT_MODIFY_DATE = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_DELETED = null, $aPPLICATION_VERSION = null, $aPPLICATIONID = null, $cODE = null)
    {
        $this
            ->setDIRECTIONID($dIRECTIONID)
            ->setNAME($nAME)
            ->setSHORT_CODE($sHORT_CODE)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setCODE($cODE);
    }
    /**
     * Get DIRECTIONID value
     * @return float|null
     */
    public function getDIRECTIONID()
    {
        return $this->DIRECTIONID;
    }
    /**
     * Set DIRECTIONID value
     * @param float $dIRECTIONID
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setDIRECTIONID($dIRECTIONID = null)
    {
        // validation for constraint: float
        if (!is_null($dIRECTIONID) && !(is_float($dIRECTIONID) || is_numeric($dIRECTIONID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dIRECTIONID, true), gettype($dIRECTIONID)), __LINE__);
        }
        $this->DIRECTIONID = $dIRECTIONID;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($nAME) && mb_strlen($nAME) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get SHORT_CODE value
     * @return string|null
     */
    public function getSHORT_CODE()
    {
        return $this->SHORT_CODE;
    }
    /**
     * Set SHORT_CODE value
     * @param string $sHORT_CODE
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setSHORT_CODE($sHORT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($sHORT_CODE) && !is_string($sHORT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sHORT_CODE, true), gettype($sHORT_CODE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($sHORT_CODE) && mb_strlen($sHORT_CODE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($sHORT_CODE)), __LINE__);
        }
        $this->SHORT_CODE = $sHORT_CODE;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_CREATE_DATE, true), gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEDBY) && !(is_float($aUDITCREATEDBY) || is_numeric($aUDITCREATEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEDBY, true), gettype($aUDITCREATEDBY)), __LINE__);
        }
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEUNITID) && !(is_float($aUDITCREATEUNITID) || is_numeric($aUDITCREATEUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEUNITID, true), gettype($aUDITCREATEUNITID)), __LINE__);
        }
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_MODIFY_DATE, true), gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFIEDBY) && !(is_float($aUDITMODIFIEDBY) || is_numeric($aUDITMODIFIEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFIEDBY, true), gettype($aUDITMODIFIEDBY)), __LINE__);
        }
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFYUNITID) && !(is_float($aUDITMODIFYUNITID) || is_numeric($aUDITMODIFYUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFYUNITID, true), gettype($aUDITMODIFYUNITID)), __LINE__);
        }
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_DELETED, true), gettype($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aUDIT_DELETED) && mb_strlen($aUDIT_DELETED) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPPLICATION_VERSION, true), gettype($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($aPPLICATION_VERSION) && mb_strlen($aPPLICATION_VERSION) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        // validation for constraint: float
        if (!is_null($aPPLICATIONID) && !(is_float($aPPLICATIONID) || is_numeric($aPPLICATIONID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aPPLICATIONID, true), gettype($aPPLICATIONID)), __LINE__);
        }
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get CODE value
     * @return float|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param float $cODE
     * @return \Ys\ArasOrder\StructType\DIRECTION
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: float
        if (!is_null($cODE) && !(is_float($cODE) || is_numeric($cODE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cODE, true), gettype($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
}
