<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelDispatch StructType
 * @subpackage Structs
 */
class CancelDispatch extends AbstractStructBase
{
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The integrationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $integrationCode;
    /**
     * Constructor method for CancelDispatch
     * @uses CancelDispatch::setUserName()
     * @uses CancelDispatch::setPassword()
     * @uses CancelDispatch::setIntegrationCode()
     * @param string $userName
     * @param string $password
     * @param string $integrationCode
     */
    public function __construct($userName = null, $password = null, $integrationCode = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setIntegrationCode($integrationCode);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \Ys\ArasOrder\StructType\CancelDispatch
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Ys\ArasOrder\StructType\CancelDispatch
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get integrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->integrationCode;
    }
    /**
     * Set integrationCode value
     * @param string $integrationCode
     * @return \Ys\ArasOrder\StructType\CancelDispatch
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationCode, true), gettype($integrationCode)), __LINE__);
        }
        $this->integrationCode = $integrationCode;
        return $this;
    }
}
