<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarcodeModel StructType
 * @subpackage Structs
 */
class BarcodeModel extends AbstractStructBase
{
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Volume;
    /**
     * The TotalVolume
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalVolume;
    /**
     * The BarcodeDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BarcodeDate;
    /**
     * The DeliveryUnitID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DeliveryUnitID;
    /**
     * The SourceUnitID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceUnitID;
    /**
     * The PieceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PieceNumber;
    /**
     * The PieceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PieceCount;
    /**
     * The CashPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CashPrice;
    /**
     * The WaybillID
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $WaybillID;
    /**
     * The SenderAccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAccountName;
    /**
     * The SenderAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAddress;
    /**
     * The SenderAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAddress2;
    /**
     * The ReceiverAccountName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAccountName;
    /**
     * The ReceiverAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAddress;
    /**
     * The ReceiverAddress2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAddress2;
    /**
     * The ReceiverAddress3
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAddress3;
    /**
     * The ReceiverPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhone;
    /**
     * The ReceiverPhone2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverPhone2;
    /**
     * The ReceiverTown
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverTown;
    /**
     * The ReceiverCity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverCity;
    /**
     * The DeliveryUnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeliveryUnitName;
    /**
     * The SourceUnitName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SourceUnitName;
    /**
     * The TrackingNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TrackingNumber;
    /**
     * The IntegrationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegrationCode;
    /**
     * The Msi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Msi;
    /**
     * The MainServiceName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MainServiceName;
    /**
     * The RouteName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RouteName;
    /**
     * The WaybillSerial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WaybillSerial;
    /**
     * The WaybillNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WaybillNumber;
    /**
     * The LovShipmentTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovShipmentTypeName;
    /**
     * The LovPacketTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovPacketTypeName;
    /**
     * The LovPayorTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovPayorTypeName;
    /**
     * The SenderPhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderPhone;
    /**
     * The ExServiceCodes
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\ArasOrder\ArrayType\ArrayOfString
     */
    public $ExServiceCodes;
    /**
     * The WaybillDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WaybillDate;
    /**
     * The LovDeliveryTypeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LovDeliveryTypeName;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barcode;
    /**
     * The PaymentType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The WorkArea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkArea;
    /**
     * The SenderHintCityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderHintCityName;
    /**
     * The SenderHintTownName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderHintTownName;
    /**
     * The ReceiverMobilePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverMobilePhone;
    /**
     * The SenderMobilePhone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderMobilePhone;
    /**
     * The SenderAccountNameAndSurName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SenderAccountNameAndSurName;
    /**
     * The ReceiverAccountNameAndSurName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiverAccountNameAndSurName;
    /**
     * Constructor method for BarcodeModel
     * @uses BarcodeModel::setVolume()
     * @uses BarcodeModel::setTotalVolume()
     * @uses BarcodeModel::setBarcodeDate()
     * @uses BarcodeModel::setDeliveryUnitID()
     * @uses BarcodeModel::setSourceUnitID()
     * @uses BarcodeModel::setPieceNumber()
     * @uses BarcodeModel::setPieceCount()
     * @uses BarcodeModel::setCashPrice()
     * @uses BarcodeModel::setWaybillID()
     * @uses BarcodeModel::setSenderAccountName()
     * @uses BarcodeModel::setSenderAddress()
     * @uses BarcodeModel::setSenderAddress2()
     * @uses BarcodeModel::setReceiverAccountName()
     * @uses BarcodeModel::setReceiverAddress()
     * @uses BarcodeModel::setReceiverAddress2()
     * @uses BarcodeModel::setReceiverAddress3()
     * @uses BarcodeModel::setReceiverPhone()
     * @uses BarcodeModel::setReceiverPhone2()
     * @uses BarcodeModel::setReceiverTown()
     * @uses BarcodeModel::setReceiverCity()
     * @uses BarcodeModel::setDeliveryUnitName()
     * @uses BarcodeModel::setSourceUnitName()
     * @uses BarcodeModel::setTrackingNumber()
     * @uses BarcodeModel::setIntegrationCode()
     * @uses BarcodeModel::setMsi()
     * @uses BarcodeModel::setMainServiceName()
     * @uses BarcodeModel::setRouteName()
     * @uses BarcodeModel::setWaybillSerial()
     * @uses BarcodeModel::setWaybillNumber()
     * @uses BarcodeModel::setLovShipmentTypeName()
     * @uses BarcodeModel::setLovPacketTypeName()
     * @uses BarcodeModel::setLovPayorTypeName()
     * @uses BarcodeModel::setSenderPhone()
     * @uses BarcodeModel::setExServiceCodes()
     * @uses BarcodeModel::setWaybillDate()
     * @uses BarcodeModel::setLovDeliveryTypeName()
     * @uses BarcodeModel::setBarcode()
     * @uses BarcodeModel::setPaymentType()
     * @uses BarcodeModel::setWorkArea()
     * @uses BarcodeModel::setSenderHintCityName()
     * @uses BarcodeModel::setSenderHintTownName()
     * @uses BarcodeModel::setReceiverMobilePhone()
     * @uses BarcodeModel::setSenderMobilePhone()
     * @uses BarcodeModel::setSenderAccountNameAndSurName()
     * @uses BarcodeModel::setReceiverAccountNameAndSurName()
     * @param float $volume
     * @param float $totalVolume
     * @param string $barcodeDate
     * @param int $deliveryUnitID
     * @param int $sourceUnitID
     * @param int $pieceNumber
     * @param int $pieceCount
     * @param float $cashPrice
     * @param string $waybillID
     * @param string $senderAccountName
     * @param string $senderAddress
     * @param string $senderAddress2
     * @param string $receiverAccountName
     * @param string $receiverAddress
     * @param string $receiverAddress2
     * @param string $receiverAddress3
     * @param string $receiverPhone
     * @param string $receiverPhone2
     * @param string $receiverTown
     * @param string $receiverCity
     * @param string $deliveryUnitName
     * @param string $sourceUnitName
     * @param string $trackingNumber
     * @param string $integrationCode
     * @param string $msi
     * @param string $mainServiceName
     * @param string $routeName
     * @param string $waybillSerial
     * @param string $waybillNumber
     * @param string $lovShipmentTypeName
     * @param string $lovPacketTypeName
     * @param string $lovPayorTypeName
     * @param string $senderPhone
     * @param \Ys\ArasOrder\ArrayType\ArrayOfString $exServiceCodes
     * @param string $waybillDate
     * @param string $lovDeliveryTypeName
     * @param string $barcode
     * @param string $paymentType
     * @param string $workArea
     * @param string $senderHintCityName
     * @param string $senderHintTownName
     * @param string $receiverMobilePhone
     * @param string $senderMobilePhone
     * @param string $senderAccountNameAndSurName
     * @param string $receiverAccountNameAndSurName
     */
    public function __construct($volume = null, $totalVolume = null, $barcodeDate = null, $deliveryUnitID = null, $sourceUnitID = null, $pieceNumber = null, $pieceCount = null, $cashPrice = null, $waybillID = null, $senderAccountName = null, $senderAddress = null, $senderAddress2 = null, $receiverAccountName = null, $receiverAddress = null, $receiverAddress2 = null, $receiverAddress3 = null, $receiverPhone = null, $receiverPhone2 = null, $receiverTown = null, $receiverCity = null, $deliveryUnitName = null, $sourceUnitName = null, $trackingNumber = null, $integrationCode = null, $msi = null, $mainServiceName = null, $routeName = null, $waybillSerial = null, $waybillNumber = null, $lovShipmentTypeName = null, $lovPacketTypeName = null, $lovPayorTypeName = null, $senderPhone = null, \Ys\ArasOrder\ArrayType\ArrayOfString $exServiceCodes = null, $waybillDate = null, $lovDeliveryTypeName = null, $barcode = null, $paymentType = null, $workArea = null, $senderHintCityName = null, $senderHintTownName = null, $receiverMobilePhone = null, $senderMobilePhone = null, $senderAccountNameAndSurName = null, $receiverAccountNameAndSurName = null)
    {
        $this
            ->setVolume($volume)
            ->setTotalVolume($totalVolume)
            ->setBarcodeDate($barcodeDate)
            ->setDeliveryUnitID($deliveryUnitID)
            ->setSourceUnitID($sourceUnitID)
            ->setPieceNumber($pieceNumber)
            ->setPieceCount($pieceCount)
            ->setCashPrice($cashPrice)
            ->setWaybillID($waybillID)
            ->setSenderAccountName($senderAccountName)
            ->setSenderAddress($senderAddress)
            ->setSenderAddress2($senderAddress2)
            ->setReceiverAccountName($receiverAccountName)
            ->setReceiverAddress($receiverAddress)
            ->setReceiverAddress2($receiverAddress2)
            ->setReceiverAddress3($receiverAddress3)
            ->setReceiverPhone($receiverPhone)
            ->setReceiverPhone2($receiverPhone2)
            ->setReceiverTown($receiverTown)
            ->setReceiverCity($receiverCity)
            ->setDeliveryUnitName($deliveryUnitName)
            ->setSourceUnitName($sourceUnitName)
            ->setTrackingNumber($trackingNumber)
            ->setIntegrationCode($integrationCode)
            ->setMsi($msi)
            ->setMainServiceName($mainServiceName)
            ->setRouteName($routeName)
            ->setWaybillSerial($waybillSerial)
            ->setWaybillNumber($waybillNumber)
            ->setLovShipmentTypeName($lovShipmentTypeName)
            ->setLovPacketTypeName($lovPacketTypeName)
            ->setLovPayorTypeName($lovPayorTypeName)
            ->setSenderPhone($senderPhone)
            ->setExServiceCodes($exServiceCodes)
            ->setWaybillDate($waybillDate)
            ->setLovDeliveryTypeName($lovDeliveryTypeName)
            ->setBarcode($barcode)
            ->setPaymentType($paymentType)
            ->setWorkArea($workArea)
            ->setSenderHintCityName($senderHintCityName)
            ->setSenderHintTownName($senderHintTownName)
            ->setReceiverMobilePhone($receiverMobilePhone)
            ->setSenderMobilePhone($senderMobilePhone)
            ->setSenderAccountNameAndSurName($senderAccountNameAndSurName)
            ->setReceiverAccountNameAndSurName($receiverAccountNameAndSurName);
    }
    /**
     * Get Volume value
     * @return float
     */
    public function getVolume()
    {
        return $this->Volume;
    }
    /**
     * Set Volume value
     * @param float $volume
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: float
        if (!is_null($volume) && !(is_float($volume) || is_numeric($volume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volume, true), gettype($volume)), __LINE__);
        }
        $this->Volume = $volume;
        return $this;
    }
    /**
     * Get TotalVolume value
     * @return float
     */
    public function getTotalVolume()
    {
        return $this->TotalVolume;
    }
    /**
     * Set TotalVolume value
     * @param float $totalVolume
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setTotalVolume($totalVolume = null)
    {
        // validation for constraint: float
        if (!is_null($totalVolume) && !(is_float($totalVolume) || is_numeric($totalVolume))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalVolume, true), gettype($totalVolume)), __LINE__);
        }
        $this->TotalVolume = $totalVolume;
        return $this;
    }
    /**
     * Get BarcodeDate value
     * @return string
     */
    public function getBarcodeDate()
    {
        return $this->BarcodeDate;
    }
    /**
     * Set BarcodeDate value
     * @param string $barcodeDate
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setBarcodeDate($barcodeDate = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeDate) && !is_string($barcodeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeDate, true), gettype($barcodeDate)), __LINE__);
        }
        $this->BarcodeDate = $barcodeDate;
        return $this;
    }
    /**
     * Get DeliveryUnitID value
     * @return int
     */
    public function getDeliveryUnitID()
    {
        return $this->DeliveryUnitID;
    }
    /**
     * Set DeliveryUnitID value
     * @param int $deliveryUnitID
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setDeliveryUnitID($deliveryUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryUnitID) && !(is_int($deliveryUnitID) || ctype_digit($deliveryUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryUnitID, true), gettype($deliveryUnitID)), __LINE__);
        }
        $this->DeliveryUnitID = $deliveryUnitID;
        return $this;
    }
    /**
     * Get SourceUnitID value
     * @return int
     */
    public function getSourceUnitID()
    {
        return $this->SourceUnitID;
    }
    /**
     * Set SourceUnitID value
     * @param int $sourceUnitID
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSourceUnitID($sourceUnitID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceUnitID) && !(is_int($sourceUnitID) || ctype_digit($sourceUnitID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceUnitID, true), gettype($sourceUnitID)), __LINE__);
        }
        $this->SourceUnitID = $sourceUnitID;
        return $this;
    }
    /**
     * Get PieceNumber value
     * @return int
     */
    public function getPieceNumber()
    {
        return $this->PieceNumber;
    }
    /**
     * Set PieceNumber value
     * @param int $pieceNumber
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setPieceNumber($pieceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pieceNumber) && !(is_int($pieceNumber) || ctype_digit($pieceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieceNumber, true), gettype($pieceNumber)), __LINE__);
        }
        $this->PieceNumber = $pieceNumber;
        return $this;
    }
    /**
     * Get PieceCount value
     * @return int
     */
    public function getPieceCount()
    {
        return $this->PieceCount;
    }
    /**
     * Set PieceCount value
     * @param int $pieceCount
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setPieceCount($pieceCount = null)
    {
        // validation for constraint: int
        if (!is_null($pieceCount) && !(is_int($pieceCount) || ctype_digit($pieceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pieceCount, true), gettype($pieceCount)), __LINE__);
        }
        $this->PieceCount = $pieceCount;
        return $this;
    }
    /**
     * Get CashPrice value
     * @return float
     */
    public function getCashPrice()
    {
        return $this->CashPrice;
    }
    /**
     * Set CashPrice value
     * @param float $cashPrice
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setCashPrice($cashPrice = null)
    {
        // validation for constraint: float
        if (!is_null($cashPrice) && !(is_float($cashPrice) || is_numeric($cashPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cashPrice, true), gettype($cashPrice)), __LINE__);
        }
        $this->CashPrice = $cashPrice;
        return $this;
    }
    /**
     * Get WaybillID value
     * @return string
     */
    public function getWaybillID()
    {
        return $this->WaybillID;
    }
    /**
     * Set WaybillID value
     * @param string $waybillID
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setWaybillID($waybillID = null)
    {
        // validation for constraint: string
        if (!is_null($waybillID) && !is_string($waybillID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybillID, true), gettype($waybillID)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($waybillID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $waybillID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($waybillID, true)), __LINE__);
        }
        $this->WaybillID = $waybillID;
        return $this;
    }
    /**
     * Get SenderAccountName value
     * @return string|null
     */
    public function getSenderAccountName()
    {
        return $this->SenderAccountName;
    }
    /**
     * Set SenderAccountName value
     * @param string $senderAccountName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderAccountName($senderAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($senderAccountName) && !is_string($senderAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAccountName, true), gettype($senderAccountName)), __LINE__);
        }
        $this->SenderAccountName = $senderAccountName;
        return $this;
    }
    /**
     * Get SenderAddress value
     * @return string|null
     */
    public function getSenderAddress()
    {
        return $this->SenderAddress;
    }
    /**
     * Set SenderAddress value
     * @param string $senderAddress
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderAddress($senderAddress = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress) && !is_string($senderAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAddress, true), gettype($senderAddress)), __LINE__);
        }
        $this->SenderAddress = $senderAddress;
        return $this;
    }
    /**
     * Get SenderAddress2 value
     * @return string|null
     */
    public function getSenderAddress2()
    {
        return $this->SenderAddress2;
    }
    /**
     * Set SenderAddress2 value
     * @param string $senderAddress2
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderAddress2($senderAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($senderAddress2) && !is_string($senderAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAddress2, true), gettype($senderAddress2)), __LINE__);
        }
        $this->SenderAddress2 = $senderAddress2;
        return $this;
    }
    /**
     * Get ReceiverAccountName value
     * @return string|null
     */
    public function getReceiverAccountName()
    {
        return $this->ReceiverAccountName;
    }
    /**
     * Set ReceiverAccountName value
     * @param string $receiverAccountName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverAccountName($receiverAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAccountName) && !is_string($receiverAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAccountName, true), gettype($receiverAccountName)), __LINE__);
        }
        $this->ReceiverAccountName = $receiverAccountName;
        return $this;
    }
    /**
     * Get ReceiverAddress value
     * @return string|null
     */
    public function getReceiverAddress()
    {
        return $this->ReceiverAddress;
    }
    /**
     * Set ReceiverAddress value
     * @param string $receiverAddress
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverAddress($receiverAddress = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress) && !is_string($receiverAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAddress, true), gettype($receiverAddress)), __LINE__);
        }
        $this->ReceiverAddress = $receiverAddress;
        return $this;
    }
    /**
     * Get ReceiverAddress2 value
     * @return string|null
     */
    public function getReceiverAddress2()
    {
        return $this->ReceiverAddress2;
    }
    /**
     * Set ReceiverAddress2 value
     * @param string $receiverAddress2
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverAddress2($receiverAddress2 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress2) && !is_string($receiverAddress2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAddress2, true), gettype($receiverAddress2)), __LINE__);
        }
        $this->ReceiverAddress2 = $receiverAddress2;
        return $this;
    }
    /**
     * Get ReceiverAddress3 value
     * @return string|null
     */
    public function getReceiverAddress3()
    {
        return $this->ReceiverAddress3;
    }
    /**
     * Set ReceiverAddress3 value
     * @param string $receiverAddress3
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverAddress3($receiverAddress3 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAddress3) && !is_string($receiverAddress3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAddress3, true), gettype($receiverAddress3)), __LINE__);
        }
        $this->ReceiverAddress3 = $receiverAddress3;
        return $this;
    }
    /**
     * Get ReceiverPhone value
     * @return string|null
     */
    public function getReceiverPhone()
    {
        return $this->ReceiverPhone;
    }
    /**
     * Set ReceiverPhone value
     * @param string $receiverPhone
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverPhone($receiverPhone = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone) && !is_string($receiverPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPhone, true), gettype($receiverPhone)), __LINE__);
        }
        $this->ReceiverPhone = $receiverPhone;
        return $this;
    }
    /**
     * Get ReceiverPhone2 value
     * @return string|null
     */
    public function getReceiverPhone2()
    {
        return $this->ReceiverPhone2;
    }
    /**
     * Set ReceiverPhone2 value
     * @param string $receiverPhone2
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverPhone2($receiverPhone2 = null)
    {
        // validation for constraint: string
        if (!is_null($receiverPhone2) && !is_string($receiverPhone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverPhone2, true), gettype($receiverPhone2)), __LINE__);
        }
        $this->ReceiverPhone2 = $receiverPhone2;
        return $this;
    }
    /**
     * Get ReceiverTown value
     * @return string|null
     */
    public function getReceiverTown()
    {
        return $this->ReceiverTown;
    }
    /**
     * Set ReceiverTown value
     * @param string $receiverTown
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverTown($receiverTown = null)
    {
        // validation for constraint: string
        if (!is_null($receiverTown) && !is_string($receiverTown)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverTown, true), gettype($receiverTown)), __LINE__);
        }
        $this->ReceiverTown = $receiverTown;
        return $this;
    }
    /**
     * Get ReceiverCity value
     * @return string|null
     */
    public function getReceiverCity()
    {
        return $this->ReceiverCity;
    }
    /**
     * Set ReceiverCity value
     * @param string $receiverCity
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverCity($receiverCity = null)
    {
        // validation for constraint: string
        if (!is_null($receiverCity) && !is_string($receiverCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverCity, true), gettype($receiverCity)), __LINE__);
        }
        $this->ReceiverCity = $receiverCity;
        return $this;
    }
    /**
     * Get DeliveryUnitName value
     * @return string|null
     */
    public function getDeliveryUnitName()
    {
        return $this->DeliveryUnitName;
    }
    /**
     * Set DeliveryUnitName value
     * @param string $deliveryUnitName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setDeliveryUnitName($deliveryUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryUnitName) && !is_string($deliveryUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryUnitName, true), gettype($deliveryUnitName)), __LINE__);
        }
        $this->DeliveryUnitName = $deliveryUnitName;
        return $this;
    }
    /**
     * Get SourceUnitName value
     * @return string|null
     */
    public function getSourceUnitName()
    {
        return $this->SourceUnitName;
    }
    /**
     * Set SourceUnitName value
     * @param string $sourceUnitName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSourceUnitName($sourceUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($sourceUnitName) && !is_string($sourceUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceUnitName, true), gettype($sourceUnitName)), __LINE__);
        }
        $this->SourceUnitName = $sourceUnitName;
        return $this;
    }
    /**
     * Get TrackingNumber value
     * @return string|null
     */
    public function getTrackingNumber()
    {
        return $this->TrackingNumber;
    }
    /**
     * Set TrackingNumber value
     * @param string $trackingNumber
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setTrackingNumber($trackingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumber) && !is_string($trackingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumber, true), gettype($trackingNumber)), __LINE__);
        }
        $this->TrackingNumber = $trackingNumber;
        return $this;
    }
    /**
     * Get IntegrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->IntegrationCode;
    }
    /**
     * Set IntegrationCode value
     * @param string $integrationCode
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationCode, true), gettype($integrationCode)), __LINE__);
        }
        $this->IntegrationCode = $integrationCode;
        return $this;
    }
    /**
     * Get Msi value
     * @return string|null
     */
    public function getMsi()
    {
        return $this->Msi;
    }
    /**
     * Set Msi value
     * @param string $msi
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setMsi($msi = null)
    {
        // validation for constraint: string
        if (!is_null($msi) && !is_string($msi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($msi, true), gettype($msi)), __LINE__);
        }
        $this->Msi = $msi;
        return $this;
    }
    /**
     * Get MainServiceName value
     * @return string|null
     */
    public function getMainServiceName()
    {
        return $this->MainServiceName;
    }
    /**
     * Set MainServiceName value
     * @param string $mainServiceName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setMainServiceName($mainServiceName = null)
    {
        // validation for constraint: string
        if (!is_null($mainServiceName) && !is_string($mainServiceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainServiceName, true), gettype($mainServiceName)), __LINE__);
        }
        $this->MainServiceName = $mainServiceName;
        return $this;
    }
    /**
     * Get RouteName value
     * @return string|null
     */
    public function getRouteName()
    {
        return $this->RouteName;
    }
    /**
     * Set RouteName value
     * @param string $routeName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setRouteName($routeName = null)
    {
        // validation for constraint: string
        if (!is_null($routeName) && !is_string($routeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($routeName, true), gettype($routeName)), __LINE__);
        }
        $this->RouteName = $routeName;
        return $this;
    }
    /**
     * Get WaybillSerial value
     * @return string|null
     */
    public function getWaybillSerial()
    {
        return $this->WaybillSerial;
    }
    /**
     * Set WaybillSerial value
     * @param string $waybillSerial
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setWaybillSerial($waybillSerial = null)
    {
        // validation for constraint: string
        if (!is_null($waybillSerial) && !is_string($waybillSerial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybillSerial, true), gettype($waybillSerial)), __LINE__);
        }
        $this->WaybillSerial = $waybillSerial;
        return $this;
    }
    /**
     * Get WaybillNumber value
     * @return string|null
     */
    public function getWaybillNumber()
    {
        return $this->WaybillNumber;
    }
    /**
     * Set WaybillNumber value
     * @param string $waybillNumber
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setWaybillNumber($waybillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($waybillNumber) && !is_string($waybillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybillNumber, true), gettype($waybillNumber)), __LINE__);
        }
        $this->WaybillNumber = $waybillNumber;
        return $this;
    }
    /**
     * Get LovShipmentTypeName value
     * @return string|null
     */
    public function getLovShipmentTypeName()
    {
        return $this->LovShipmentTypeName;
    }
    /**
     * Set LovShipmentTypeName value
     * @param string $lovShipmentTypeName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setLovShipmentTypeName($lovShipmentTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovShipmentTypeName) && !is_string($lovShipmentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lovShipmentTypeName, true), gettype($lovShipmentTypeName)), __LINE__);
        }
        $this->LovShipmentTypeName = $lovShipmentTypeName;
        return $this;
    }
    /**
     * Get LovPacketTypeName value
     * @return string|null
     */
    public function getLovPacketTypeName()
    {
        return $this->LovPacketTypeName;
    }
    /**
     * Set LovPacketTypeName value
     * @param string $lovPacketTypeName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setLovPacketTypeName($lovPacketTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovPacketTypeName) && !is_string($lovPacketTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lovPacketTypeName, true), gettype($lovPacketTypeName)), __LINE__);
        }
        $this->LovPacketTypeName = $lovPacketTypeName;
        return $this;
    }
    /**
     * Get LovPayorTypeName value
     * @return string|null
     */
    public function getLovPayorTypeName()
    {
        return $this->LovPayorTypeName;
    }
    /**
     * Set LovPayorTypeName value
     * @param string $lovPayorTypeName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setLovPayorTypeName($lovPayorTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovPayorTypeName) && !is_string($lovPayorTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lovPayorTypeName, true), gettype($lovPayorTypeName)), __LINE__);
        }
        $this->LovPayorTypeName = $lovPayorTypeName;
        return $this;
    }
    /**
     * Get SenderPhone value
     * @return string|null
     */
    public function getSenderPhone()
    {
        return $this->SenderPhone;
    }
    /**
     * Set SenderPhone value
     * @param string $senderPhone
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderPhone($senderPhone = null)
    {
        // validation for constraint: string
        if (!is_null($senderPhone) && !is_string($senderPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderPhone, true), gettype($senderPhone)), __LINE__);
        }
        $this->SenderPhone = $senderPhone;
        return $this;
    }
    /**
     * Get ExServiceCodes value
     * @return \Ys\ArasOrder\ArrayType\ArrayOfString|null
     */
    public function getExServiceCodes()
    {
        return $this->ExServiceCodes;
    }
    /**
     * Set ExServiceCodes value
     * @param \Ys\ArasOrder\ArrayType\ArrayOfString $exServiceCodes
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setExServiceCodes(\Ys\ArasOrder\ArrayType\ArrayOfString $exServiceCodes = null)
    {
        $this->ExServiceCodes = $exServiceCodes;
        return $this;
    }
    /**
     * Get WaybillDate value
     * @return string|null
     */
    public function getWaybillDate()
    {
        return $this->WaybillDate;
    }
    /**
     * Set WaybillDate value
     * @param string $waybillDate
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setWaybillDate($waybillDate = null)
    {
        // validation for constraint: string
        if (!is_null($waybillDate) && !is_string($waybillDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($waybillDate, true), gettype($waybillDate)), __LINE__);
        }
        $this->WaybillDate = $waybillDate;
        return $this;
    }
    /**
     * Get LovDeliveryTypeName value
     * @return string|null
     */
    public function getLovDeliveryTypeName()
    {
        return $this->LovDeliveryTypeName;
    }
    /**
     * Set LovDeliveryTypeName value
     * @param string $lovDeliveryTypeName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setLovDeliveryTypeName($lovDeliveryTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($lovDeliveryTypeName) && !is_string($lovDeliveryTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lovDeliveryTypeName, true), gettype($lovDeliveryTypeName)), __LINE__);
        }
        $this->LovDeliveryTypeName = $lovDeliveryTypeName;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get WorkArea value
     * @return string|null
     */
    public function getWorkArea()
    {
        return $this->WorkArea;
    }
    /**
     * Set WorkArea value
     * @param string $workArea
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setWorkArea($workArea = null)
    {
        // validation for constraint: string
        if (!is_null($workArea) && !is_string($workArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workArea, true), gettype($workArea)), __LINE__);
        }
        $this->WorkArea = $workArea;
        return $this;
    }
    /**
     * Get SenderHintCityName value
     * @return string|null
     */
    public function getSenderHintCityName()
    {
        return $this->SenderHintCityName;
    }
    /**
     * Set SenderHintCityName value
     * @param string $senderHintCityName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderHintCityName($senderHintCityName = null)
    {
        // validation for constraint: string
        if (!is_null($senderHintCityName) && !is_string($senderHintCityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderHintCityName, true), gettype($senderHintCityName)), __LINE__);
        }
        $this->SenderHintCityName = $senderHintCityName;
        return $this;
    }
    /**
     * Get SenderHintTownName value
     * @return string|null
     */
    public function getSenderHintTownName()
    {
        return $this->SenderHintTownName;
    }
    /**
     * Set SenderHintTownName value
     * @param string $senderHintTownName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderHintTownName($senderHintTownName = null)
    {
        // validation for constraint: string
        if (!is_null($senderHintTownName) && !is_string($senderHintTownName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderHintTownName, true), gettype($senderHintTownName)), __LINE__);
        }
        $this->SenderHintTownName = $senderHintTownName;
        return $this;
    }
    /**
     * Get ReceiverMobilePhone value
     * @return string|null
     */
    public function getReceiverMobilePhone()
    {
        return $this->ReceiverMobilePhone;
    }
    /**
     * Set ReceiverMobilePhone value
     * @param string $receiverMobilePhone
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverMobilePhone($receiverMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($receiverMobilePhone) && !is_string($receiverMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverMobilePhone, true), gettype($receiverMobilePhone)), __LINE__);
        }
        $this->ReceiverMobilePhone = $receiverMobilePhone;
        return $this;
    }
    /**
     * Get SenderMobilePhone value
     * @return string|null
     */
    public function getSenderMobilePhone()
    {
        return $this->SenderMobilePhone;
    }
    /**
     * Set SenderMobilePhone value
     * @param string $senderMobilePhone
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderMobilePhone($senderMobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($senderMobilePhone) && !is_string($senderMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderMobilePhone, true), gettype($senderMobilePhone)), __LINE__);
        }
        $this->SenderMobilePhone = $senderMobilePhone;
        return $this;
    }
    /**
     * Get SenderAccountNameAndSurName value
     * @return string|null
     */
    public function getSenderAccountNameAndSurName()
    {
        return $this->SenderAccountNameAndSurName;
    }
    /**
     * Set SenderAccountNameAndSurName value
     * @param string $senderAccountNameAndSurName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setSenderAccountNameAndSurName($senderAccountNameAndSurName = null)
    {
        // validation for constraint: string
        if (!is_null($senderAccountNameAndSurName) && !is_string($senderAccountNameAndSurName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAccountNameAndSurName, true), gettype($senderAccountNameAndSurName)), __LINE__);
        }
        $this->SenderAccountNameAndSurName = $senderAccountNameAndSurName;
        return $this;
    }
    /**
     * Get ReceiverAccountNameAndSurName value
     * @return string|null
     */
    public function getReceiverAccountNameAndSurName()
    {
        return $this->ReceiverAccountNameAndSurName;
    }
    /**
     * Set ReceiverAccountNameAndSurName value
     * @param string $receiverAccountNameAndSurName
     * @return \Ys\ArasOrder\StructType\BarcodeModel
     */
    public function setReceiverAccountNameAndSurName($receiverAccountNameAndSurName = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAccountNameAndSurName) && !is_string($receiverAccountNameAndSurName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAccountNameAndSurName, true), gettype($receiverAccountNameAndSurName)), __LINE__);
        }
        $this->ReceiverAccountNameAndSurName = $receiverAccountNameAndSurName;
        return $this;
    }
}
