<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BATCHWAYBILL StructType
 * @subpackage Structs
 */
class BATCHWAYBILL extends AbstractStructBase
{
    /**
     * The BATCHWAYBILLID
     * @var string
     */
    public $BATCHWAYBILLID;
    /**
     * The LOVBATCHWAYBILLTYPEID
     * @var float
     */
    public $LOVBATCHWAYBILLTYPEID;
    /**
     * The ROUTEID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ROUTEID;
    /**
     * The SOURCEUNITID
     * @var float
     */
    public $SOURCEUNITID;
    /**
     * The TARGETUNITID
     * @var float
     */
    public $TARGETUNITID;
    /**
     * The SEAL_NUMBER1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $SEAL_NUMBER1;
    /**
     * The SEAL_NUMBER2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $SEAL_NUMBER2;
    /**
     * The CANCELED
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CANCELED;
    /**
     * The CANCEL_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CANCEL_DATE;
    /**
     * The CANCELEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CANCELEDBY;
    /**
     * The COURIEREMPLOYEEID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $COURIEREMPLOYEEID;
    /**
     * The DOCUMENT_SERIAL
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $DOCUMENT_SERIAL;
    /**
     * The DOCUMENT_NUMBER
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $DOCUMENT_NUMBER;
    /**
     * The PRINTED
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PRINTED;
    /**
     * The CANCELUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CANCELUNITID;
    /**
     * The CANCEL_DESCRIPTION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $CANCEL_DESCRIPTION;
    /**
     * The PRINT_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRINT_DATE;
    /**
     * The AUDIT_CREATE_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDITCREATEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The AUDITMODIFIEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_DELETED
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The APPLICATION_VERSION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The APPLICATIONID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The TTIBAGBARGODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $TTIBAGBARGODE;
    /**
     * The LOVBARCODEPRINTSTATUSID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LOVBARCODEPRINTSTATUSID;
    /**
     * The PRINTERBARCODEID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRINTERBARCODEID;
    /**
     * The ROUTE_CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $ROUTE_CODE;
    /**
     * The BATCHWAYBILLTYPE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BATCHWAYBILLTYPE;
    /**
     * The TRANSFER_STATUS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TRANSFER_STATUS;
    /**
     * The TRANSFER_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TRANSFER_DATE;
    /**
     * Constructor method for BATCHWAYBILL
     * @uses BATCHWAYBILL::setBATCHWAYBILLID()
     * @uses BATCHWAYBILL::setLOVBATCHWAYBILLTYPEID()
     * @uses BATCHWAYBILL::setROUTEID()
     * @uses BATCHWAYBILL::setSOURCEUNITID()
     * @uses BATCHWAYBILL::setTARGETUNITID()
     * @uses BATCHWAYBILL::setSEAL_NUMBER1()
     * @uses BATCHWAYBILL::setSEAL_NUMBER2()
     * @uses BATCHWAYBILL::setCANCELED()
     * @uses BATCHWAYBILL::setCANCEL_DATE()
     * @uses BATCHWAYBILL::setCANCELEDBY()
     * @uses BATCHWAYBILL::setCOURIEREMPLOYEEID()
     * @uses BATCHWAYBILL::setDOCUMENT_SERIAL()
     * @uses BATCHWAYBILL::setDOCUMENT_NUMBER()
     * @uses BATCHWAYBILL::setPRINTED()
     * @uses BATCHWAYBILL::setCANCELUNITID()
     * @uses BATCHWAYBILL::setCANCEL_DESCRIPTION()
     * @uses BATCHWAYBILL::setPRINT_DATE()
     * @uses BATCHWAYBILL::setAUDIT_CREATE_DATE()
     * @uses BATCHWAYBILL::setAUDITCREATEDBY()
     * @uses BATCHWAYBILL::setAUDITCREATEUNITID()
     * @uses BATCHWAYBILL::setAUDIT_MODIFY_DATE()
     * @uses BATCHWAYBILL::setAUDITMODIFIEDBY()
     * @uses BATCHWAYBILL::setAUDITMODIFYUNITID()
     * @uses BATCHWAYBILL::setAUDIT_DELETED()
     * @uses BATCHWAYBILL::setAPPLICATION_VERSION()
     * @uses BATCHWAYBILL::setAPPLICATIONID()
     * @uses BATCHWAYBILL::setTTIBAGBARGODE()
     * @uses BATCHWAYBILL::setLOVBARCODEPRINTSTATUSID()
     * @uses BATCHWAYBILL::setPRINTERBARCODEID()
     * @uses BATCHWAYBILL::setROUTE_CODE()
     * @uses BATCHWAYBILL::setBATCHWAYBILLTYPE()
     * @uses BATCHWAYBILL::setTRANSFER_STATUS()
     * @uses BATCHWAYBILL::setTRANSFER_DATE()
     * @param string $bATCHWAYBILLID
     * @param float $lOVBATCHWAYBILLTYPEID
     * @param string $rOUTEID
     * @param float $sOURCEUNITID
     * @param float $tARGETUNITID
     * @param string $sEAL_NUMBER1
     * @param string $sEAL_NUMBER2
     * @param string $cANCELED
     * @param string $cANCEL_DATE
     * @param float $cANCELEDBY
     * @param float $cOURIEREMPLOYEEID
     * @param string $dOCUMENT_SERIAL
     * @param string $dOCUMENT_NUMBER
     * @param string $pRINTED
     * @param float $cANCELUNITID
     * @param string $cANCEL_DESCRIPTION
     * @param string $pRINT_DATE
     * @param string $aUDIT_CREATE_DATE
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param string $aUDIT_MODIFY_DATE
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_DELETED
     * @param string $aPPLICATION_VERSION
     * @param float $aPPLICATIONID
     * @param string $tTIBAGBARGODE
     * @param float $lOVBARCODEPRINTSTATUSID
     * @param string $pRINTERBARCODEID
     * @param string $rOUTE_CODE
     * @param string $bATCHWAYBILLTYPE
     * @param string $tRANSFER_STATUS
     * @param string $tRANSFER_DATE
     */
    public function __construct($bATCHWAYBILLID = null, $lOVBATCHWAYBILLTYPEID = null, $rOUTEID = null, $sOURCEUNITID = null, $tARGETUNITID = null, $sEAL_NUMBER1 = null, $sEAL_NUMBER2 = null, $cANCELED = null, $cANCEL_DATE = null, $cANCELEDBY = null, $cOURIEREMPLOYEEID = null, $dOCUMENT_SERIAL = null, $dOCUMENT_NUMBER = null, $pRINTED = null, $cANCELUNITID = null, $cANCEL_DESCRIPTION = null, $pRINT_DATE = null, $aUDIT_CREATE_DATE = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDIT_MODIFY_DATE = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_DELETED = null, $aPPLICATION_VERSION = null, $aPPLICATIONID = null, $tTIBAGBARGODE = null, $lOVBARCODEPRINTSTATUSID = null, $pRINTERBARCODEID = null, $rOUTE_CODE = null, $bATCHWAYBILLTYPE = null, $tRANSFER_STATUS = null, $tRANSFER_DATE = null)
    {
        $this
            ->setBATCHWAYBILLID($bATCHWAYBILLID)
            ->setLOVBATCHWAYBILLTYPEID($lOVBATCHWAYBILLTYPEID)
            ->setROUTEID($rOUTEID)
            ->setSOURCEUNITID($sOURCEUNITID)
            ->setTARGETUNITID($tARGETUNITID)
            ->setSEAL_NUMBER1($sEAL_NUMBER1)
            ->setSEAL_NUMBER2($sEAL_NUMBER2)
            ->setCANCELED($cANCELED)
            ->setCANCEL_DATE($cANCEL_DATE)
            ->setCANCELEDBY($cANCELEDBY)
            ->setCOURIEREMPLOYEEID($cOURIEREMPLOYEEID)
            ->setDOCUMENT_SERIAL($dOCUMENT_SERIAL)
            ->setDOCUMENT_NUMBER($dOCUMENT_NUMBER)
            ->setPRINTED($pRINTED)
            ->setCANCELUNITID($cANCELUNITID)
            ->setCANCEL_DESCRIPTION($cANCEL_DESCRIPTION)
            ->setPRINT_DATE($pRINT_DATE)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setTTIBAGBARGODE($tTIBAGBARGODE)
            ->setLOVBARCODEPRINTSTATUSID($lOVBARCODEPRINTSTATUSID)
            ->setPRINTERBARCODEID($pRINTERBARCODEID)
            ->setROUTE_CODE($rOUTE_CODE)
            ->setBATCHWAYBILLTYPE($bATCHWAYBILLTYPE)
            ->setTRANSFER_STATUS($tRANSFER_STATUS)
            ->setTRANSFER_DATE($tRANSFER_DATE);
    }
    /**
     * Get BATCHWAYBILLID value
     * @return string|null
     */
    public function getBATCHWAYBILLID()
    {
        return $this->BATCHWAYBILLID;
    }
    /**
     * Set BATCHWAYBILLID value
     * @param string $bATCHWAYBILLID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setBATCHWAYBILLID($bATCHWAYBILLID = null)
    {
        // validation for constraint: string
        if (!is_null($bATCHWAYBILLID) && !is_string($bATCHWAYBILLID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bATCHWAYBILLID, true), gettype($bATCHWAYBILLID)), __LINE__);
        }
        $this->BATCHWAYBILLID = $bATCHWAYBILLID;
        return $this;
    }
    /**
     * Get LOVBATCHWAYBILLTYPEID value
     * @return float|null
     */
    public function getLOVBATCHWAYBILLTYPEID()
    {
        return $this->LOVBATCHWAYBILLTYPEID;
    }
    /**
     * Set LOVBATCHWAYBILLTYPEID value
     * @param float $lOVBATCHWAYBILLTYPEID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setLOVBATCHWAYBILLTYPEID($lOVBATCHWAYBILLTYPEID = null)
    {
        // validation for constraint: float
        if (!is_null($lOVBATCHWAYBILLTYPEID) && !(is_float($lOVBATCHWAYBILLTYPEID) || is_numeric($lOVBATCHWAYBILLTYPEID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lOVBATCHWAYBILLTYPEID, true), gettype($lOVBATCHWAYBILLTYPEID)), __LINE__);
        }
        $this->LOVBATCHWAYBILLTYPEID = $lOVBATCHWAYBILLTYPEID;
        return $this;
    }
    /**
     * Get ROUTEID value
     * @return string|null
     */
    public function getROUTEID()
    {
        return $this->ROUTEID;
    }
    /**
     * Set ROUTEID value
     * @param string $rOUTEID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setROUTEID($rOUTEID = null)
    {
        // validation for constraint: string
        if (!is_null($rOUTEID) && !is_string($rOUTEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOUTEID, true), gettype($rOUTEID)), __LINE__);
        }
        $this->ROUTEID = $rOUTEID;
        return $this;
    }
    /**
     * Get SOURCEUNITID value
     * @return float|null
     */
    public function getSOURCEUNITID()
    {
        return $this->SOURCEUNITID;
    }
    /**
     * Set SOURCEUNITID value
     * @param float $sOURCEUNITID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setSOURCEUNITID($sOURCEUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($sOURCEUNITID) && !(is_float($sOURCEUNITID) || is_numeric($sOURCEUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sOURCEUNITID, true), gettype($sOURCEUNITID)), __LINE__);
        }
        $this->SOURCEUNITID = $sOURCEUNITID;
        return $this;
    }
    /**
     * Get TARGETUNITID value
     * @return float|null
     */
    public function getTARGETUNITID()
    {
        return $this->TARGETUNITID;
    }
    /**
     * Set TARGETUNITID value
     * @param float $tARGETUNITID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setTARGETUNITID($tARGETUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($tARGETUNITID) && !(is_float($tARGETUNITID) || is_numeric($tARGETUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tARGETUNITID, true), gettype($tARGETUNITID)), __LINE__);
        }
        $this->TARGETUNITID = $tARGETUNITID;
        return $this;
    }
    /**
     * Get SEAL_NUMBER1 value
     * @return string|null
     */
    public function getSEAL_NUMBER1()
    {
        return $this->SEAL_NUMBER1;
    }
    /**
     * Set SEAL_NUMBER1 value
     * @param string $sEAL_NUMBER1
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setSEAL_NUMBER1($sEAL_NUMBER1 = null)
    {
        // validation for constraint: string
        if (!is_null($sEAL_NUMBER1) && !is_string($sEAL_NUMBER1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEAL_NUMBER1, true), gettype($sEAL_NUMBER1)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($sEAL_NUMBER1) && mb_strlen($sEAL_NUMBER1) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($sEAL_NUMBER1)), __LINE__);
        }
        $this->SEAL_NUMBER1 = $sEAL_NUMBER1;
        return $this;
    }
    /**
     * Get SEAL_NUMBER2 value
     * @return string|null
     */
    public function getSEAL_NUMBER2()
    {
        return $this->SEAL_NUMBER2;
    }
    /**
     * Set SEAL_NUMBER2 value
     * @param string $sEAL_NUMBER2
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setSEAL_NUMBER2($sEAL_NUMBER2 = null)
    {
        // validation for constraint: string
        if (!is_null($sEAL_NUMBER2) && !is_string($sEAL_NUMBER2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEAL_NUMBER2, true), gettype($sEAL_NUMBER2)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($sEAL_NUMBER2) && mb_strlen($sEAL_NUMBER2) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($sEAL_NUMBER2)), __LINE__);
        }
        $this->SEAL_NUMBER2 = $sEAL_NUMBER2;
        return $this;
    }
    /**
     * Get CANCELED value
     * @return string|null
     */
    public function getCANCELED()
    {
        return $this->CANCELED;
    }
    /**
     * Set CANCELED value
     * @param string $cANCELED
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setCANCELED($cANCELED = null)
    {
        // validation for constraint: string
        if (!is_null($cANCELED) && !is_string($cANCELED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cANCELED, true), gettype($cANCELED)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cANCELED) && mb_strlen($cANCELED) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cANCELED)), __LINE__);
        }
        $this->CANCELED = $cANCELED;
        return $this;
    }
    /**
     * Get CANCEL_DATE value
     * @return string|null
     */
    public function getCANCEL_DATE()
    {
        return $this->CANCEL_DATE;
    }
    /**
     * Set CANCEL_DATE value
     * @param string $cANCEL_DATE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setCANCEL_DATE($cANCEL_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($cANCEL_DATE) && !is_string($cANCEL_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cANCEL_DATE, true), gettype($cANCEL_DATE)), __LINE__);
        }
        $this->CANCEL_DATE = $cANCEL_DATE;
        return $this;
    }
    /**
     * Get CANCELEDBY value
     * @return float|null
     */
    public function getCANCELEDBY()
    {
        return $this->CANCELEDBY;
    }
    /**
     * Set CANCELEDBY value
     * @param float $cANCELEDBY
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setCANCELEDBY($cANCELEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($cANCELEDBY) && !(is_float($cANCELEDBY) || is_numeric($cANCELEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cANCELEDBY, true), gettype($cANCELEDBY)), __LINE__);
        }
        $this->CANCELEDBY = $cANCELEDBY;
        return $this;
    }
    /**
     * Get COURIEREMPLOYEEID value
     * @return float|null
     */
    public function getCOURIEREMPLOYEEID()
    {
        return $this->COURIEREMPLOYEEID;
    }
    /**
     * Set COURIEREMPLOYEEID value
     * @param float $cOURIEREMPLOYEEID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setCOURIEREMPLOYEEID($cOURIEREMPLOYEEID = null)
    {
        // validation for constraint: float
        if (!is_null($cOURIEREMPLOYEEID) && !(is_float($cOURIEREMPLOYEEID) || is_numeric($cOURIEREMPLOYEEID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cOURIEREMPLOYEEID, true), gettype($cOURIEREMPLOYEEID)), __LINE__);
        }
        $this->COURIEREMPLOYEEID = $cOURIEREMPLOYEEID;
        return $this;
    }
    /**
     * Get DOCUMENT_SERIAL value
     * @return string|null
     */
    public function getDOCUMENT_SERIAL()
    {
        return $this->DOCUMENT_SERIAL;
    }
    /**
     * Set DOCUMENT_SERIAL value
     * @param string $dOCUMENT_SERIAL
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setDOCUMENT_SERIAL($dOCUMENT_SERIAL = null)
    {
        // validation for constraint: string
        if (!is_null($dOCUMENT_SERIAL) && !is_string($dOCUMENT_SERIAL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOCUMENT_SERIAL, true), gettype($dOCUMENT_SERIAL)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($dOCUMENT_SERIAL) && mb_strlen($dOCUMENT_SERIAL) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($dOCUMENT_SERIAL)), __LINE__);
        }
        $this->DOCUMENT_SERIAL = $dOCUMENT_SERIAL;
        return $this;
    }
    /**
     * Get DOCUMENT_NUMBER value
     * @return string|null
     */
    public function getDOCUMENT_NUMBER()
    {
        return $this->DOCUMENT_NUMBER;
    }
    /**
     * Set DOCUMENT_NUMBER value
     * @param string $dOCUMENT_NUMBER
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setDOCUMENT_NUMBER($dOCUMENT_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($dOCUMENT_NUMBER) && !is_string($dOCUMENT_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOCUMENT_NUMBER, true), gettype($dOCUMENT_NUMBER)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($dOCUMENT_NUMBER) && mb_strlen($dOCUMENT_NUMBER) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($dOCUMENT_NUMBER)), __LINE__);
        }
        $this->DOCUMENT_NUMBER = $dOCUMENT_NUMBER;
        return $this;
    }
    /**
     * Get PRINTED value
     * @return string|null
     */
    public function getPRINTED()
    {
        return $this->PRINTED;
    }
    /**
     * Set PRINTED value
     * @param string $pRINTED
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setPRINTED($pRINTED = null)
    {
        // validation for constraint: string
        if (!is_null($pRINTED) && !is_string($pRINTED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRINTED, true), gettype($pRINTED)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($pRINTED) && mb_strlen($pRINTED) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($pRINTED)), __LINE__);
        }
        $this->PRINTED = $pRINTED;
        return $this;
    }
    /**
     * Get CANCELUNITID value
     * @return float|null
     */
    public function getCANCELUNITID()
    {
        return $this->CANCELUNITID;
    }
    /**
     * Set CANCELUNITID value
     * @param float $cANCELUNITID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setCANCELUNITID($cANCELUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($cANCELUNITID) && !(is_float($cANCELUNITID) || is_numeric($cANCELUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cANCELUNITID, true), gettype($cANCELUNITID)), __LINE__);
        }
        $this->CANCELUNITID = $cANCELUNITID;
        return $this;
    }
    /**
     * Get CANCEL_DESCRIPTION value
     * @return string|null
     */
    public function getCANCEL_DESCRIPTION()
    {
        return $this->CANCEL_DESCRIPTION;
    }
    /**
     * Set CANCEL_DESCRIPTION value
     * @param string $cANCEL_DESCRIPTION
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setCANCEL_DESCRIPTION($cANCEL_DESCRIPTION = null)
    {
        // validation for constraint: string
        if (!is_null($cANCEL_DESCRIPTION) && !is_string($cANCEL_DESCRIPTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cANCEL_DESCRIPTION, true), gettype($cANCEL_DESCRIPTION)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($cANCEL_DESCRIPTION) && mb_strlen($cANCEL_DESCRIPTION) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($cANCEL_DESCRIPTION)), __LINE__);
        }
        $this->CANCEL_DESCRIPTION = $cANCEL_DESCRIPTION;
        return $this;
    }
    /**
     * Get PRINT_DATE value
     * @return string|null
     */
    public function getPRINT_DATE()
    {
        return $this->PRINT_DATE;
    }
    /**
     * Set PRINT_DATE value
     * @param string $pRINT_DATE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setPRINT_DATE($pRINT_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($pRINT_DATE) && !is_string($pRINT_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRINT_DATE, true), gettype($pRINT_DATE)), __LINE__);
        }
        $this->PRINT_DATE = $pRINT_DATE;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_CREATE_DATE, true), gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEDBY) && !(is_float($aUDITCREATEDBY) || is_numeric($aUDITCREATEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEDBY, true), gettype($aUDITCREATEDBY)), __LINE__);
        }
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEUNITID) && !(is_float($aUDITCREATEUNITID) || is_numeric($aUDITCREATEUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEUNITID, true), gettype($aUDITCREATEUNITID)), __LINE__);
        }
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_MODIFY_DATE, true), gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFIEDBY) && !(is_float($aUDITMODIFIEDBY) || is_numeric($aUDITMODIFIEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFIEDBY, true), gettype($aUDITMODIFIEDBY)), __LINE__);
        }
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFYUNITID) && !(is_float($aUDITMODIFYUNITID) || is_numeric($aUDITMODIFYUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFYUNITID, true), gettype($aUDITMODIFYUNITID)), __LINE__);
        }
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_DELETED, true), gettype($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aUDIT_DELETED) && mb_strlen($aUDIT_DELETED) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPPLICATION_VERSION, true), gettype($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($aPPLICATION_VERSION) && mb_strlen($aPPLICATION_VERSION) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        // validation for constraint: float
        if (!is_null($aPPLICATIONID) && !(is_float($aPPLICATIONID) || is_numeric($aPPLICATIONID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aPPLICATIONID, true), gettype($aPPLICATIONID)), __LINE__);
        }
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get TTIBAGBARGODE value
     * @return string|null
     */
    public function getTTIBAGBARGODE()
    {
        return $this->TTIBAGBARGODE;
    }
    /**
     * Set TTIBAGBARGODE value
     * @param string $tTIBAGBARGODE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setTTIBAGBARGODE($tTIBAGBARGODE = null)
    {
        // validation for constraint: string
        if (!is_null($tTIBAGBARGODE) && !is_string($tTIBAGBARGODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tTIBAGBARGODE, true), gettype($tTIBAGBARGODE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($tTIBAGBARGODE) && mb_strlen($tTIBAGBARGODE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($tTIBAGBARGODE)), __LINE__);
        }
        $this->TTIBAGBARGODE = $tTIBAGBARGODE;
        return $this;
    }
    /**
     * Get LOVBARCODEPRINTSTATUSID value
     * @return float|null
     */
    public function getLOVBARCODEPRINTSTATUSID()
    {
        return $this->LOVBARCODEPRINTSTATUSID;
    }
    /**
     * Set LOVBARCODEPRINTSTATUSID value
     * @param float $lOVBARCODEPRINTSTATUSID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setLOVBARCODEPRINTSTATUSID($lOVBARCODEPRINTSTATUSID = null)
    {
        // validation for constraint: float
        if (!is_null($lOVBARCODEPRINTSTATUSID) && !(is_float($lOVBARCODEPRINTSTATUSID) || is_numeric($lOVBARCODEPRINTSTATUSID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lOVBARCODEPRINTSTATUSID, true), gettype($lOVBARCODEPRINTSTATUSID)), __LINE__);
        }
        $this->LOVBARCODEPRINTSTATUSID = $lOVBARCODEPRINTSTATUSID;
        return $this;
    }
    /**
     * Get PRINTERBARCODEID value
     * @return string|null
     */
    public function getPRINTERBARCODEID()
    {
        return $this->PRINTERBARCODEID;
    }
    /**
     * Set PRINTERBARCODEID value
     * @param string $pRINTERBARCODEID
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setPRINTERBARCODEID($pRINTERBARCODEID = null)
    {
        // validation for constraint: string
        if (!is_null($pRINTERBARCODEID) && !is_string($pRINTERBARCODEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pRINTERBARCODEID, true), gettype($pRINTERBARCODEID)), __LINE__);
        }
        $this->PRINTERBARCODEID = $pRINTERBARCODEID;
        return $this;
    }
    /**
     * Get ROUTE_CODE value
     * @return string|null
     */
    public function getROUTE_CODE()
    {
        return $this->ROUTE_CODE;
    }
    /**
     * Set ROUTE_CODE value
     * @param string $rOUTE_CODE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setROUTE_CODE($rOUTE_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($rOUTE_CODE) && !is_string($rOUTE_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOUTE_CODE, true), gettype($rOUTE_CODE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($rOUTE_CODE) && mb_strlen($rOUTE_CODE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($rOUTE_CODE)), __LINE__);
        }
        $this->ROUTE_CODE = $rOUTE_CODE;
        return $this;
    }
    /**
     * Get BATCHWAYBILLTYPE value
     * @return string|null
     */
    public function getBATCHWAYBILLTYPE()
    {
        return $this->BATCHWAYBILLTYPE;
    }
    /**
     * Set BATCHWAYBILLTYPE value
     * @param string $bATCHWAYBILLTYPE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setBATCHWAYBILLTYPE($bATCHWAYBILLTYPE = null)
    {
        // validation for constraint: string
        if (!is_null($bATCHWAYBILLTYPE) && !is_string($bATCHWAYBILLTYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bATCHWAYBILLTYPE, true), gettype($bATCHWAYBILLTYPE)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($bATCHWAYBILLTYPE) && mb_strlen($bATCHWAYBILLTYPE) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($bATCHWAYBILLTYPE)), __LINE__);
        }
        $this->BATCHWAYBILLTYPE = $bATCHWAYBILLTYPE;
        return $this;
    }
    /**
     * Get TRANSFER_STATUS value
     * @return string|null
     */
    public function getTRANSFER_STATUS()
    {
        return $this->TRANSFER_STATUS;
    }
    /**
     * Set TRANSFER_STATUS value
     * @param string $tRANSFER_STATUS
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setTRANSFER_STATUS($tRANSFER_STATUS = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSFER_STATUS) && !is_string($tRANSFER_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRANSFER_STATUS, true), gettype($tRANSFER_STATUS)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($tRANSFER_STATUS) && mb_strlen($tRANSFER_STATUS) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($tRANSFER_STATUS)), __LINE__);
        }
        $this->TRANSFER_STATUS = $tRANSFER_STATUS;
        return $this;
    }
    /**
     * Get TRANSFER_DATE value
     * @return string|null
     */
    public function getTRANSFER_DATE()
    {
        return $this->TRANSFER_DATE;
    }
    /**
     * Set TRANSFER_DATE value
     * @param string $tRANSFER_DATE
     * @return \Ys\ArasOrder\StructType\BATCHWAYBILL
     */
    public function setTRANSFER_DATE($tRANSFER_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSFER_DATE) && !is_string($tRANSFER_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRANSFER_DATE, true), gettype($tRANSFER_DATE)), __LINE__);
        }
        $this->TRANSFER_DATE = $tRANSFER_DATE;
        return $this;
    }
}
