<?php

namespace Ys\ArasOrder\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressResultDto StructType
 * @subpackage Structs
 */
class AddressResultDto extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * The AddressId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressId;
    /**
     * Constructor method for AddressResultDto
     * @uses AddressResultDto::setResultCode()
     * @uses AddressResultDto::setResultMessage()
     * @uses AddressResultDto::setAddressId()
     * @param string $resultCode
     * @param string $resultMessage
     * @param string $addressId
     */
    public function __construct($resultCode = null, $resultMessage = null, $addressId = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage)
            ->setAddressId($addressId);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \Ys\ArasOrder\StructType\AddressResultDto
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \Ys\ArasOrder\StructType\AddressResultDto
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
    /**
     * Get AddressId value
     * @return string|null
     */
    public function getAddressId()
    {
        return $this->AddressId;
    }
    /**
     * Set AddressId value
     * @param string $addressId
     * @return \Ys\ArasOrder\StructType\AddressResultDto
     */
    public function setAddressId($addressId = null)
    {
        // validation for constraint: string
        if (!is_null($addressId) && !is_string($addressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressId, true), gettype($addressId)), __LINE__);
        }
        $this->AddressId = $addressId;
        return $this;
    }
}
