<?php

namespace Ys\ArasOrder\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Save ServiceType
 * @subpackage Services
 */
class Save extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaveAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\SaveAddress $parameters
     * @return \Ys\ArasOrder\StructType\SaveAddressResponse|bool
     */
    public function SaveAddress(\Ys\ArasOrder\StructType\SaveAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SaveAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\ArasOrder\StructType\SaveAddressResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
