<?php

namespace Ys\ArasOrder\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAddressList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetAddressList $parameters
     * @return \Ys\ArasOrder\StructType\GetAddressListResponse|bool
     */
    public function GetAddressList(\Ys\ArasOrder\StructType\GetAddressList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetAddressList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUndeliveredCargoSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetUndeliveredCargoSearch $parameters
     * @return \Ys\ArasOrder\StructType\GetUndeliveredCargoSearchResponse|bool
     */
    public function GetUndeliveredCargoSearch(\Ys\ArasOrder\StructType\GetUndeliveredCargoSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUndeliveredCargoSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWaitingCargoList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetWaitingCargoList $parameters
     * @return \Ys\ArasOrder\StructType\GetWaitingCargoListResponse|bool
     */
    public function GetWaitingCargoList(\Ys\ArasOrder\StructType\GetWaitingCargoList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWaitingCargoList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetDeliveryList $parameters
     * @return \Ys\ArasOrder\StructType\GetDeliveryListResponse|bool
     */
    public function GetDeliveryList(\Ys\ArasOrder\StructType\GetDeliveryList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoSendList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoSendList $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoSendListResponse|bool
     */
    public function GetCargoSendList(\Ys\ArasOrder\StructType\GetCargoSendList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoSendList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetParentUnitAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetParentUnitAddress $parameters
     * @return \Ys\ArasOrder\StructType\GetParentUnitAddressResponse|bool
     */
    public function GetParentUnitAddress(\Ys\ArasOrder\StructType\GetParentUnitAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetParentUnitAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnitAddress
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetUnitAddress $parameters
     * @return \Ys\ArasOrder\StructType\GetUnitAddressResponse|bool
     */
    public function GetUnitAddress(\Ys\ArasOrder\StructType\GetUnitAddress $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUnitAddress($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnitCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetUnitCard $parameters
     * @return \Ys\ArasOrder\StructType\GetUnitCardResponse|bool
     */
    public function GetUnitCard(\Ys\ArasOrder\StructType\GetUnitCard $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUnitCard($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDuration
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetDuration $parameters
     * @return \Ys\ArasOrder\StructType\GetDurationResponse|bool
     */
    public function GetDuration(\Ys\ArasOrder\StructType\GetDuration $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDuration($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryList2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetDeliveryList2 $parameters
     * @return \Ys\ArasOrder\StructType\GetDeliveryList2Response|bool
     */
    public function GetDeliveryList2(\Ys\ArasOrder\StructType\GetDeliveryList2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryList2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoPieceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoPieceList $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoPieceListResponse|bool
     */
    public function GetCargoPieceList(\Ys\ArasOrder\StructType\GetCargoPieceList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoPieceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPriceCalculation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetPriceCalculation $parameters
     * @return \Ys\ArasOrder\StructType\GetPriceCalculationResponse|bool
     */
    public function GetPriceCalculation(\Ys\ArasOrder\StructType\GetPriceCalculation $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPriceCalculation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetServiceList $parameters
     * @return \Ys\ArasOrder\StructType\GetServiceListResponse|bool
     */
    public function GetServiceList(\Ys\ArasOrder\StructType\GetServiceList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServiceList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetServiceType
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetServiceType $parameters
     * @return \Ys\ArasOrder\StructType\GetServiceTypeResponse|bool
     */
    public function GetServiceType(\Ys\ArasOrder\StructType\GetServiceType $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetServiceType($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRedirectionList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetRedirectionList $parameters
     * @return \Ys\ArasOrder\StructType\GetRedirectionListResponse|bool
     */
    public function GetRedirectionList(\Ys\ArasOrder\StructType\GetRedirectionList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRedirectionList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBackList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetBackList $parameters
     * @return \Ys\ArasOrder\StructType\GetBackListResponse|bool
     */
    public function GetBackList(\Ys\ArasOrder\StructType\GetBackList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBackList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoReturn
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoReturn $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoReturnResponse|bool
     */
    public function GetCargoReturn(\Ys\ArasOrder\StructType\GetCargoReturn $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoReturn($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoInfo $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoInfoResponse|bool
     */
    public function GetCargoInfo(\Ys\ArasOrder\StructType\GetCargoInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCityList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCityList $parameters
     * @return \Ys\ArasOrder\StructType\GetCityListResponse|bool
     */
    public function GetCityList(\Ys\ArasOrder\StructType\GetCityList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCityList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTown
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetTown $parameters
     * @return \Ys\ArasOrder\StructType\GetTownResponse|bool
     */
    public function GetTown(\Ys\ArasOrder\StructType\GetTown $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTown($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetUnit $parameters
     * @return \Ys\ArasOrder\StructType\GetUnitResponse|bool
     */
    public function GetUnit(\Ys\ArasOrder\StructType\GetUnit $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUnit($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUnitBranch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetUnitBranch $parameters
     * @return \Ys\ArasOrder\StructType\GetUnitBranchResponse|bool
     */
    public function GetUnitBranch(\Ys\ArasOrder\StructType\GetUnitBranch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUnitBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetRegions $parameters
     * @return \Ys\ArasOrder\StructType\GetRegionsResponse|bool
     */
    public function GetRegions(\Ys\ArasOrder\StructType\GetRegions $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetRegions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoSearch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoSearch $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoSearchResponse|bool
     */
    public function GetCargoSearch(\Ys\ArasOrder\StructType\GetCargoSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoSearchByCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoSearchByCode $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoSearchByCodeResponse|bool
     */
    public function GetCargoSearchByCode(\Ys\ArasOrder\StructType\GetCargoSearchByCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoSearchByCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSortedCargoInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetSortedCargoInfo $parameters
     * @return \Ys\ArasOrder\StructType\GetSortedCargoInfoResponse|bool
     */
    public function GetSortedCargoInfo(\Ys\ArasOrder\StructType\GetSortedCargoInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSortedCargoInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoTransaction $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoTransactionResponse|bool
     */
    public function GetCargoTransaction(\Ys\ArasOrder\StructType\GetCargoTransaction $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCargoTransactionByWaybillId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCargoTransactionByWaybillId $parameters
     * @return \Ys\ArasOrder\StructType\GetCargoTransactionByWaybillIdResponse|bool
     */
    public function GetCargoTransactionByWaybillId(\Ys\ArasOrder\StructType\GetCargoTransactionByWaybillId $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCargoTransactionByWaybillId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDispatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetDispatch $parameters
     * @return \Ys\ArasOrder\StructType\GetDispatchResponse|bool
     */
    public function GetDispatch(\Ys\ArasOrder\StructType\GetDispatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDispatch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrder
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetOrder $parameters
     * @return \Ys\ArasOrder\StructType\GetOrderResponse|bool
     */
    public function GetOrder(\Ys\ArasOrder\StructType\GetOrder $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrder($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDispatchWithIntegrationCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetDispatchWithIntegrationCode $parameters
     * @return \Ys\ArasOrder\StructType\GetDispatchWithIntegrationCodeResponse|bool
     */
    public function GetDispatchWithIntegrationCode(\Ys\ArasOrder\StructType\GetDispatchWithIntegrationCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDispatchWithIntegrationCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOrderWithIntegrationCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetOrderWithIntegrationCode $parameters
     * @return \Ys\ArasOrder\StructType\GetOrderWithIntegrationCodeResponse|bool
     */
    public function GetOrderWithIntegrationCode(\Ys\ArasOrder\StructType\GetOrderWithIntegrationCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetOrderWithIntegrationCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCancelNewDoc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetCancelNewDoc $parameters
     * @return \Ys\ArasOrder\StructType\GetCancelNewDocResponse|bool
     */
    public function GetCancelNewDoc(\Ys\ArasOrder\StructType\GetCancelNewDoc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCancelNewDoc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetDeliveryInfo $parameters
     * @return \Ys\ArasOrder\StructType\GetDeliveryInfoResponse|bool
     */
    public function GetDeliveryInfo(\Ys\ArasOrder\StructType\GetDeliveryInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetMissingNewDoc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetMissingNewDoc $parameters
     * @return \Ys\ArasOrder\StructType\GetMissingNewDocResponse|bool
     */
    public function GetMissingNewDoc(\Ys\ArasOrder\StructType\GetMissingNewDoc $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetMissingNewDoc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDeliveryInfodocID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetDeliveryInfodocID $parameters
     * @return \Ys\ArasOrder\StructType\GetDeliveryInfodocIDResponse|bool
     */
    public function GetDeliveryInfodocID(\Ys\ArasOrder\StructType\GetDeliveryInfodocID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDeliveryInfodocID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetIncomingCargoInfoBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetIncomingCargoInfoBarcode $parameters
     * @return \Ys\ArasOrder\StructType\GetIncomingCargoInfoBarcodeResponse|bool
     */
    public function GetIncomingCargoInfoBarcode(\Ys\ArasOrder\StructType\GetIncomingCargoInfoBarcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetIncomingCargoInfoBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBarcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasOrder\StructType\GetBarcode $parameters
     * @return \Ys\ArasOrder\StructType\GetBarcodeResponse|bool
     */
    public function GetBarcode(\Ys\ArasOrder\StructType\GetBarcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBarcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\ArasOrder\StructType\GetAddressListResponse|\Ys\ArasOrder\StructType\GetBackListResponse|\Ys\ArasOrder\StructType\GetBarcodeResponse|\Ys\ArasOrder\StructType\GetCancelNewDocResponse|\Ys\ArasOrder\StructType\GetCargoInfoResponse|\Ys\ArasOrder\StructType\GetCargoPieceListResponse|\Ys\ArasOrder\StructType\GetCargoReturnResponse|\Ys\ArasOrder\StructType\GetCargoSearchByCodeResponse|\Ys\ArasOrder\StructType\GetCargoSearchResponse|\Ys\ArasOrder\StructType\GetCargoSendListResponse|\Ys\ArasOrder\StructType\GetCargoTransactionByWaybillIdResponse|\Ys\ArasOrder\StructType\GetCargoTransactionResponse|\Ys\ArasOrder\StructType\GetCityListResponse|\Ys\ArasOrder\StructType\GetDeliveryInfodocIDResponse|\Ys\ArasOrder\StructType\GetDeliveryInfoResponse|\Ys\ArasOrder\StructType\GetDeliveryList2Response|\Ys\ArasOrder\StructType\GetDeliveryListResponse|\Ys\ArasOrder\StructType\GetDispatchResponse|\Ys\ArasOrder\StructType\GetDispatchWithIntegrationCodeResponse|\Ys\ArasOrder\StructType\GetDurationResponse|\Ys\ArasOrder\StructType\GetIncomingCargoInfoBarcodeResponse|\Ys\ArasOrder\StructType\GetMissingNewDocResponse|\Ys\ArasOrder\StructType\GetOrderResponse|\Ys\ArasOrder\StructType\GetOrderWithIntegrationCodeResponse|\Ys\ArasOrder\StructType\GetParentUnitAddressResponse|\Ys\ArasOrder\StructType\GetPriceCalculationResponse|\Ys\ArasOrder\StructType\GetRedirectionListResponse|\Ys\ArasOrder\StructType\GetRegionsResponse|\Ys\ArasOrder\StructType\GetServiceListResponse|\Ys\ArasOrder\StructType\GetServiceTypeResponse|\Ys\ArasOrder\StructType\GetSortedCargoInfoResponse|\Ys\ArasOrder\StructType\GetTownResponse|\Ys\ArasOrder\StructType\GetUndeliveredCargoSearchResponse|\Ys\ArasOrder\StructType\GetUnitAddressResponse|\Ys\ArasOrder\StructType\GetUnitBranchResponse|\Ys\ArasOrder\StructType\GetUnitCardResponse|\Ys\ArasOrder\StructType\GetUnitResponse|\Ys\ArasOrder\StructType\GetWaitingCargoListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
