<?php

namespace Ys\ArasOrder\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPiece ArrayType
 * @subpackage Arrays
 */
class ArrayOfPiece extends AbstractStructArrayBase
{
    /**
     * The Piece
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Ys\ArasOrder\StructType\Piece[]
     */
    public $Piece;
    /**
     * Constructor method for ArrayOfPiece
     * @uses ArrayOfPiece::setPiece()
     * @param \Ys\ArasOrder\StructType\Piece[] $piece
     */
    public function __construct(array $piece = array())
    {
        $this
            ->setPiece($piece);
    }
    /**
     * Get Piece value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Ys\ArasOrder\StructType\Piece[]|null
     */
    public function getPiece()
    {
        return isset($this->Piece) ? $this->Piece : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPiece method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPiece method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePieceForArrayConstraintsFromSetPiece(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPiecePieceItem) {
            // validation for constraint: itemType
            if (!$arrayOfPiecePieceItem instanceof \Ys\ArasOrder\StructType\Piece) {
                $invalidValues[] = is_object($arrayOfPiecePieceItem) ? get_class($arrayOfPiecePieceItem) : sprintf('%s(%s)', gettype($arrayOfPiecePieceItem), var_export($arrayOfPiecePieceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Piece property can only contain items of type \Ys\ArasOrder\StructType\Piece, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Piece value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Ys\ArasOrder\StructType\Piece[] $piece
     * @return \Ys\ArasOrder\ArrayType\ArrayOfPiece
     */
    public function setPiece(array $piece = array())
    {
        // validation for constraint: array
        if ('' !== ($pieceArrayErrorMessage = self::validatePieceForArrayConstraintsFromSetPiece($piece))) {
            throw new \InvalidArgumentException($pieceArrayErrorMessage, __LINE__);
        }
        if (is_null($piece) || (is_array($piece) && empty($piece))) {
            unset($this->Piece);
        } else {
            $this->Piece = $piece;
        }
        return $this;
    }
    /**
     * Add item to Piece value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasOrder\StructType\Piece $item
     * @return \Ys\ArasOrder\ArrayType\ArrayOfPiece
     */
    public function addToPiece(\Ys\ArasOrder\StructType\Piece $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasOrder\StructType\Piece) {
            throw new \InvalidArgumentException(sprintf('The Piece property can only contain items of type \Ys\ArasOrder\StructType\Piece, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Piece[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Ys\ArasOrder\StructType\Piece|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Ys\ArasOrder\StructType\Piece|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Ys\ArasOrder\StructType\Piece|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Ys\ArasOrder\StructType\Piece|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Ys\ArasOrder\StructType\Piece|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Piece
     */
    public function getAttributeName()
    {
        return 'Piece';
    }
}
