<?php


namespace Ys\ArasOrder;


use WsdlToPhp\PackageBase\AbstractSoapClientBase;
use Ys\ArasOrder\ArrayType\ArrayOfOrder;
use Ys\ArasOrder\ClassMap;
use Ys\ArasOrder\ServiceType\Cancel;
use Ys\ArasOrder\ServiceType\Get;
use Ys\ArasOrder\ServiceType\Set;
use Ys\ArasOrder\StructType\CancelDispatch;
use Ys\ArasOrder\StructType\GetOrder;
use Ys\ArasOrder\StructType\GetOrderWithIntegrationCode;
use Ys\ArasOrder\StructType\Order;
use Ys\ArasOrder\StructType\SetOrder;

class ArasOrderClient
{

    #region fields

    /**
     * @var string
     */
    protected $testUserName = 'neodyum';

    /**
     * @var string
     */
    protected $testPassword = 'nd2580';

    /**
     * @var string
     */
    protected $testUrl = 'http://customerservicestest.araskargo.com.tr/arascargoservice/arascargoservice.asmx';
    /**
     * @var string
     */
    protected $userName;

    /**
     * @var string
     */
    protected $password;

    /**
     * @var string
     */
    protected $url = 'http://customerws.araskargo.com.tr/arascargoservice.asmx';

    /**
     * @var bool
     */
    protected $testMode = false;

    #endregion fields

    #region ctor

    /**
     * ArasOrderClient constructor.
     * @param string $userName
     * @param string $password
     * @param bool $testMode
     */
    public function __construct($userName, $password, $testMode = false)
    {
        $this->userName = $userName;
        $this->password = $password;
        $this->testMode = $testMode;
    }

    #endregion ctor

    #region Properties

    /**
     * @return string
     */
    public function getTestUserName()
    {
        return $this->testUserName;
    }

    /**
     * @param string $testUserName
     */
    public function setTestUserName($testUserName)
    {
        $this->testUserName = $testUserName;
    }

    /**
     * @return string
     */
    public function getTestPassword()
    {
        return $this->testPassword;
    }

    /**
     * @param string $testPassword
     */
    public function setTestPassword($testPassword)
    {
        $this->testPassword = $testPassword;
    }

    /**
     * @param bool $wsdl
     * @return string
     */
    public function getTestUrl($wsdl = false)
    {
        $url = $this->testUrl;
        if($wsdl){
            if (strpos($url, '?wsdl') === false) {
                $url .= '?wsdl';
            }
        }

        return $url;
    }

    /**
     * @param string $testUrl
     */
    public function setTestUrl($testUrl)
    {
        $this->testUrl = $testUrl;
    }

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     */
    public function setPassword($password)
    {
        $this->password = $password;
    }

    /**
     * @param bool $wsdl
     * @return string
     */
    public function getUrl($wsdl = false)
    {
        $url = $this->url;
        if($wsdl){
            if (strpos($url, '?wsdl') === false) {
                $url .= '?wsdl';
            }
        }
        return $url;
    }

    /**
     * @param string $url
     */
    public function setUrl($url)
    {
        $this->url = $url;
    }

    /**
     * @return bool
     */
    public function isTestMode()
    {
        return $this->testMode;
    }

    /**
     * @param bool $testMode
     */
    public function setTestMode($testMode)
    {
        $this->testMode = $testMode;
    }

    #endregion Properties

    #region Methods

    /**
     * @param array|Order[]|Order $orders
     * @return StructType\OrderResultInfo[]|null
     * @throws \Exception
     */
    public function setOrder($orders){
        $srv = $this->getServiceSet();
        $user = $this->isTestMode() ?
            $this->getTestUserName():
            $this->getUserName();
        $pass = $this->isTestMode() ?
            $this->getTestPassword():
            $this->getPassword();
        if(!is_array($orders)){
            $orders = array($orders);
        }

        foreach ($orders as &$ord){
            $ord->setUserName($user)
                ->setPassword($pass);
        }

        $setOrder = new SetOrder(new ArrayOfOrder($orders),$user,$pass);

        if ($srv->SetOrder($setOrder) !== false) {
            $res = $srv->getResult()->getSetOrderResult()->getOrderResultInfo();
            return $res;
        } else {
            $err = implode(' - ', $srv->getLastError());
            throw new \Exception($err);
        }
    }

    /**
     * @param string $date ör. 10.11.2020
     * @return \Ys\ArasOrder\StructType\Order[]|null
     * @throws \Exception
     */
    public function getOrder($date){
        $srv = $this->getServiceGet();
        $user = $this->isTestMode() ?
            $this->getTestUserName():
            $this->getUserName();
        $pass = $this->isTestMode() ?
            $this->getTestPassword():
            $this->getPassword();

        $getOrder = new GetOrder($user,$pass,$date);

        if ($srv->GetOrder($getOrder) !== false) {
            $res = $srv->getResult()->getGetOrderResult()->getOrder();
            return $res;
        } else {
            $err = implode(' - ', $srv->getLastError());
            throw new \Exception($err);
        }
    }

    /**
     * @param string $integrationCode
     * @return Order[]|null
     * @throws \Exception
     */
    public function getOrderWithIntegrationCode($integrationCode){
        $srv = $this->getServiceGet();
        $user = $this->isTestMode() ?
            $this->getTestUserName():
            $this->getUserName();
        $pass = $this->isTestMode() ?
            $this->getTestPassword():
            $this->getPassword();

        $getOrder = new GetOrderWithIntegrationCode($user,$pass,$integrationCode);

        if ($srv->GetOrderWithIntegrationCode($getOrder) !== false) {
            $res = $srv->getResult()->getGetOrderWithIntegrationCodeResult()->getOrder();
            return $res;
        } else {
            $err = implode(' - ', $srv->getLastError());
            throw new \Exception($err);
        }
    }

    /**
     * @param String $integrationCode
     * @return StructType\DispatchResultInfo|null
     * @throws \Exception
     */
    public function cancelDispatch($integrationCode){
        $srv = $this->getServiceCancel();
        $user = $this->isTestMode() ?
            $this->getTestUserName():
            $this->getUserName();
        $pass = $this->isTestMode() ?
            $this->getTestPassword():
            $this->getPassword();
        $cancel = new CancelDispatch($user,$pass,$integrationCode);

            if ($srv->CancelDispatch($cancel) !== false) {
                $res = $srv->getResult()->getCancelDispatchResult();
                return $res;
            } else {
                $err = implode(' - ', $srv->getLastError());
                throw new \Exception($err);
            }
    }

    #endregion Methods

    #region utils

    /**
     * @return Get
     */
    protected function getServiceGet(){
        $url = $this->isTestMode()?
            $this->getTestUrl(true):
            $this->getUrl(true);
        $options = array(
            AbstractSoapClientBase::WSDL_URL => $url,
            AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
        );
        $get = new Get($options);
        return $get;
    }

    /**
     * @return Set
     */
    protected function getServiceSet(){
        $url = $this->isTestMode()?
            $this->getTestUrl(true):
            $this->getUrl(true);
        $options = array(
            AbstractSoapClientBase::WSDL_URL => $url,
            AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
        );
        $set = new Set($options);
        return $set;
    }

    /**
     * @return Cancel
     */
    protected function getServiceCancel(){
        $url = $this->isTestMode()?
            $this->getTestUrl(true):
            $this->getUrl(true);
        $options = array(
            AbstractSoapClientBase::WSDL_URL => $url,
            AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
        );
        return new Cancel($options);;
    }

    #endregion utils

}