<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA StructType
 * @subpackage Structs
 */
class WEBCARGODATA_1 extends AbstractStructBase
{
    /**
     * The SERI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $SERI;
    /**
     * The NO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $NO;
    /**
     * The MUSTERI_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MUSTERI_KODU;
    /**
     * The SUBE_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $SUBE_ADI;
    /**
     * The ALICI_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * @var string
     */
    public $ALICI_ADI;
    /**
     * The DEVIR_ACIKLAMA
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 4000
     * - minOccurs: 0
     * @var string
     */
    public $DEVIR_ACIKLAMA;
    /**
     * The MOK
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MOK;
    /**
     * The CIKIS_TARIHI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CIKIS_TARIHI;
    /**
     * The DEVIR_NEDENI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $DEVIR_NEDENI;
    /**
     * The DEVIR_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 4000
     * - minOccurs: 0
     * @var string
     */
    public $DEVIR_KODU;
    /**
     * Constructor method for WEBCARGODATA
     * @uses WEBCARGODATA_1::setSERI()
     * @uses WEBCARGODATA_1::setNO()
     * @uses WEBCARGODATA_1::setMUSTERI_KODU()
     * @uses WEBCARGODATA_1::setSUBE_ADI()
     * @uses WEBCARGODATA_1::setALICI_ADI()
     * @uses WEBCARGODATA_1::setDEVIR_ACIKLAMA()
     * @uses WEBCARGODATA_1::setMOK()
     * @uses WEBCARGODATA_1::setCIKIS_TARIHI()
     * @uses WEBCARGODATA_1::setDEVIR_NEDENI()
     * @uses WEBCARGODATA_1::setDEVIR_KODU()
     * @param string $sERI
     * @param string $nO
     * @param string $mUSTERI_KODU
     * @param string $sUBE_ADI
     * @param string $aLICI_ADI
     * @param string $dEVIR_ACIKLAMA
     * @param string $mOK
     * @param string $cIKIS_TARIHI
     * @param string $dEVIR_NEDENI
     * @param string $dEVIR_KODU
     */
    public function __construct($sERI = null, $nO = null, $mUSTERI_KODU = null, $sUBE_ADI = null, $aLICI_ADI = null, $dEVIR_ACIKLAMA = null, $mOK = null, $cIKIS_TARIHI = null, $dEVIR_NEDENI = null, $dEVIR_KODU = null)
    {
        $this
            ->setSERI($sERI)
            ->setNO($nO)
            ->setMUSTERI_KODU($mUSTERI_KODU)
            ->setSUBE_ADI($sUBE_ADI)
            ->setALICI_ADI($aLICI_ADI)
            ->setDEVIR_ACIKLAMA($dEVIR_ACIKLAMA)
            ->setMOK($mOK)
            ->setCIKIS_TARIHI($cIKIS_TARIHI)
            ->setDEVIR_NEDENI($dEVIR_NEDENI)
            ->setDEVIR_KODU($dEVIR_KODU);
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERI, true), gettype($sERI)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($sERI) && mb_strlen($sERI) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get NO value
     * @return string|null
     */
    public function getNO()
    {
        return $this->NO;
    }
    /**
     * Set NO value
     * @param string $nO
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setNO($nO = null)
    {
        // validation for constraint: string
        if (!is_null($nO) && !is_string($nO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nO, true), gettype($nO)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($nO) && mb_strlen($nO) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($nO)), __LINE__);
        }
        $this->NO = $nO;
        return $this;
    }
    /**
     * Get MUSTERI_KODU value
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }
    /**
     * Set MUSTERI_KODU value
     * @param string $mUSTERI_KODU
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setMUSTERI_KODU($mUSTERI_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($mUSTERI_KODU) && !is_string($mUSTERI_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mUSTERI_KODU, true), gettype($mUSTERI_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mUSTERI_KODU) && mb_strlen($mUSTERI_KODU) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mUSTERI_KODU)), __LINE__);
        }
        $this->MUSTERI_KODU = $mUSTERI_KODU;
        return $this;
    }
    /**
     * Get SUBE_ADI value
     * @return string|null
     */
    public function getSUBE_ADI()
    {
        return $this->SUBE_ADI;
    }
    /**
     * Set SUBE_ADI value
     * @param string $sUBE_ADI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setSUBE_ADI($sUBE_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($sUBE_ADI) && !is_string($sUBE_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUBE_ADI, true), gettype($sUBE_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($sUBE_ADI) && mb_strlen($sUBE_ADI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($sUBE_ADI)), __LINE__);
        }
        $this->SUBE_ADI = $sUBE_ADI;
        return $this;
    }
    /**
     * Get ALICI_ADI value
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }
    /**
     * Set ALICI_ADI value
     * @param string $aLICI_ADI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setALICI_ADI($aLICI_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI_ADI) && !is_string($aLICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI_ADI, true), gettype($aLICI_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aLICI_ADI) && mb_strlen($aLICI_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aLICI_ADI)), __LINE__);
        }
        $this->ALICI_ADI = $aLICI_ADI;
        return $this;
    }
    /**
     * Get DEVIR_ACIKLAMA value
     * @return string|null
     */
    public function getDEVIR_ACIKLAMA()
    {
        return $this->DEVIR_ACIKLAMA;
    }
    /**
     * Set DEVIR_ACIKLAMA value
     * @param string $dEVIR_ACIKLAMA
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setDEVIR_ACIKLAMA($dEVIR_ACIKLAMA = null)
    {
        // validation for constraint: string
        if (!is_null($dEVIR_ACIKLAMA) && !is_string($dEVIR_ACIKLAMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEVIR_ACIKLAMA, true), gettype($dEVIR_ACIKLAMA)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($dEVIR_ACIKLAMA) && mb_strlen($dEVIR_ACIKLAMA) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($dEVIR_ACIKLAMA)), __LINE__);
        }
        $this->DEVIR_ACIKLAMA = $dEVIR_ACIKLAMA;
        return $this;
    }
    /**
     * Get MOK value
     * @return string|null
     */
    public function getMOK()
    {
        return $this->MOK;
    }
    /**
     * Set MOK value
     * @param string $mOK
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setMOK($mOK = null)
    {
        // validation for constraint: string
        if (!is_null($mOK) && !is_string($mOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOK, true), gettype($mOK)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mOK) && mb_strlen($mOK) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mOK)), __LINE__);
        }
        $this->MOK = $mOK;
        return $this;
    }
    /**
     * Get CIKIS_TARIHI value
     * @return string|null
     */
    public function getCIKIS_TARIHI()
    {
        return $this->CIKIS_TARIHI;
    }
    /**
     * Set CIKIS_TARIHI value
     * @param string $cIKIS_TARIHI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setCIKIS_TARIHI($cIKIS_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_TARIHI) && !is_string($cIKIS_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_TARIHI, true), gettype($cIKIS_TARIHI)), __LINE__);
        }
        $this->CIKIS_TARIHI = $cIKIS_TARIHI;
        return $this;
    }
    /**
     * Get DEVIR_NEDENI value
     * @return string|null
     */
    public function getDEVIR_NEDENI()
    {
        return $this->DEVIR_NEDENI;
    }
    /**
     * Set DEVIR_NEDENI value
     * @param string $dEVIR_NEDENI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setDEVIR_NEDENI($dEVIR_NEDENI = null)
    {
        // validation for constraint: string
        if (!is_null($dEVIR_NEDENI) && !is_string($dEVIR_NEDENI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEVIR_NEDENI, true), gettype($dEVIR_NEDENI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($dEVIR_NEDENI) && mb_strlen($dEVIR_NEDENI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($dEVIR_NEDENI)), __LINE__);
        }
        $this->DEVIR_NEDENI = $dEVIR_NEDENI;
        return $this;
    }
    /**
     * Get DEVIR_KODU value
     * @return string|null
     */
    public function getDEVIR_KODU()
    {
        return $this->DEVIR_KODU;
    }
    /**
     * Set DEVIR_KODU value
     * @param string $dEVIR_KODU
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA_1
     */
    public function setDEVIR_KODU($dEVIR_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($dEVIR_KODU) && !is_string($dEVIR_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEVIR_KODU, true), gettype($dEVIR_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($dEVIR_KODU) && mb_strlen($dEVIR_KODU) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($dEVIR_KODU)), __LINE__);
        }
        $this->DEVIR_KODU = $dEVIR_KODU;
        return $this;
    }
}
