<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA6 StructType
 * @subpackage Structs
 */
class WEBCARGODATA6 extends AbstractStructBase
{
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $NAME;
    /**
     * The ADDRESS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $ADDRESS;
    /**
     * The ILCE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $ILCE;
    /**
     * The TELEFON
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $TELEFON;
    /**
     * The EMAIL
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $EMAIL;
    /**
     * The BAGLI_BOLGE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $BAGLI_BOLGE;
    /**
     * Constructor method for WEBCARGODATA6
     * @uses WEBCARGODATA6::setNAME()
     * @uses WEBCARGODATA6::setADDRESS()
     * @uses WEBCARGODATA6::setILCE()
     * @uses WEBCARGODATA6::setTELEFON()
     * @uses WEBCARGODATA6::setEMAIL()
     * @uses WEBCARGODATA6::setBAGLI_BOLGE()
     * @param string $nAME
     * @param string $aDDRESS
     * @param string $iLCE
     * @param string $tELEFON
     * @param string $eMAIL
     * @param string $bAGLI_BOLGE
     */
    public function __construct($nAME = null, $aDDRESS = null, $iLCE = null, $tELEFON = null, $eMAIL = null, $bAGLI_BOLGE = null)
    {
        $this
            ->setNAME($nAME)
            ->setADDRESS($aDDRESS)
            ->setILCE($iLCE)
            ->setTELEFON($tELEFON)
            ->setEMAIL($eMAIL)
            ->setBAGLI_BOLGE($bAGLI_BOLGE);
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA6
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($nAME) && mb_strlen($nAME) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get ADDRESS value
     * @return string|null
     */
    public function getADDRESS()
    {
        return $this->ADDRESS;
    }
    /**
     * Set ADDRESS value
     * @param string $aDDRESS
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA6
     */
    public function setADDRESS($aDDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS) && !is_string($aDDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aDDRESS, true), gettype($aDDRESS)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($aDDRESS) && mb_strlen($aDDRESS) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($aDDRESS)), __LINE__);
        }
        $this->ADDRESS = $aDDRESS;
        return $this;
    }
    /**
     * Get ILCE value
     * @return string|null
     */
    public function getILCE()
    {
        return $this->ILCE;
    }
    /**
     * Set ILCE value
     * @param string $iLCE
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA6
     */
    public function setILCE($iLCE = null)
    {
        // validation for constraint: string
        if (!is_null($iLCE) && !is_string($iLCE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iLCE, true), gettype($iLCE)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($iLCE) && mb_strlen($iLCE) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($iLCE)), __LINE__);
        }
        $this->ILCE = $iLCE;
        return $this;
    }
    /**
     * Get TELEFON value
     * @return string|null
     */
    public function getTELEFON()
    {
        return $this->TELEFON;
    }
    /**
     * Set TELEFON value
     * @param string $tELEFON
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA6
     */
    public function setTELEFON($tELEFON = null)
    {
        // validation for constraint: string
        if (!is_null($tELEFON) && !is_string($tELEFON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tELEFON, true), gettype($tELEFON)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($tELEFON) && mb_strlen($tELEFON) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($tELEFON)), __LINE__);
        }
        $this->TELEFON = $tELEFON;
        return $this;
    }
    /**
     * Get EMAIL value
     * @return string|null
     */
    public function getEMAIL()
    {
        return $this->EMAIL;
    }
    /**
     * Set EMAIL value
     * @param string $eMAIL
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA6
     */
    public function setEMAIL($eMAIL = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL) && !is_string($eMAIL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMAIL, true), gettype($eMAIL)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($eMAIL) && mb_strlen($eMAIL) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($eMAIL)), __LINE__);
        }
        $this->EMAIL = $eMAIL;
        return $this;
    }
    /**
     * Get BAGLI_BOLGE value
     * @return string|null
     */
    public function getBAGLI_BOLGE()
    {
        return $this->BAGLI_BOLGE;
    }
    /**
     * Set BAGLI_BOLGE value
     * @param string $bAGLI_BOLGE
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA6
     */
    public function setBAGLI_BOLGE($bAGLI_BOLGE = null)
    {
        // validation for constraint: string
        if (!is_null($bAGLI_BOLGE) && !is_string($bAGLI_BOLGE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bAGLI_BOLGE, true), gettype($bAGLI_BOLGE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($bAGLI_BOLGE) && mb_strlen($bAGLI_BOLGE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($bAGLI_BOLGE)), __LINE__);
        }
        $this->BAGLI_BOLGE = $bAGLI_BOLGE;
        return $this;
    }
}
