<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WEBCARGODATA12 StructType
 * @subpackage Structs
 */
class WEBCARGODATA12 extends AbstractStructBase
{
    /**
     * The ADRES_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $ADRES_ADI;
    /**
     * The ADRES_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $ADRES_KODU;
    /**
     * The MUSTERI_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MUSTERI_KODU;
    /**
     * The SERI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $SERI;
    /**
     * The IRSNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $IRSNO;
    /**
     * The REFNO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $REFNO;
    /**
     * The IRSNO1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $IRSNO1;
    /**
     * The MOK
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MOK;
    /**
     * The OT
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $OT;
    /**
     * The TARIH
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 19
     * - minOccurs: 0
     * @var string
     */
    public $TARIH;
    /**
     * The CIKIS_SUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBESI;
    /**
     * The VARIS_SUBESI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBESI;
    /**
     * The ALICI_ADI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $ALICI_ADI;
    /**
     * The SEHIR
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $SEHIR;
    /**
     * The TUTAR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The TOPLAM_ADET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TOPLAM_ADET;
    /**
     * The PARCA_NO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PARCA_NO;
    /**
     * The TESLIM_ALAN
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_ALAN;
    /**
     * The TESLIM_TARIHI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_TARIHI;
    /**
     * The TESLIM_SAATI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_SAATI;
    /**
     * The IADE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $IADE;
    /**
     * The DEPO_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $DEPO_KODU;
    /**
     * Constructor method for WEBCARGODATA12
     * @uses WEBCARGODATA12::setADRES_ADI()
     * @uses WEBCARGODATA12::setADRES_KODU()
     * @uses WEBCARGODATA12::setMUSTERI_KODU()
     * @uses WEBCARGODATA12::setSERI()
     * @uses WEBCARGODATA12::setIRSNO()
     * @uses WEBCARGODATA12::setREFNO()
     * @uses WEBCARGODATA12::setIRSNO1()
     * @uses WEBCARGODATA12::setMOK()
     * @uses WEBCARGODATA12::setOT()
     * @uses WEBCARGODATA12::setTARIH()
     * @uses WEBCARGODATA12::setCIKIS_SUBESI()
     * @uses WEBCARGODATA12::setVARIS_SUBESI()
     * @uses WEBCARGODATA12::setALICI_ADI()
     * @uses WEBCARGODATA12::setSEHIR()
     * @uses WEBCARGODATA12::setTUTAR()
     * @uses WEBCARGODATA12::setTOPLAM_ADET()
     * @uses WEBCARGODATA12::setPARCA_NO()
     * @uses WEBCARGODATA12::setTESLIM_ALAN()
     * @uses WEBCARGODATA12::setTESLIM_TARIHI()
     * @uses WEBCARGODATA12::setTESLIM_SAATI()
     * @uses WEBCARGODATA12::setIADE()
     * @uses WEBCARGODATA12::setDEPO_KODU()
     * @param string $aDRES_ADI
     * @param string $aDRES_KODU
     * @param string $mUSTERI_KODU
     * @param string $sERI
     * @param string $iRSNO
     * @param string $rEFNO
     * @param string $iRSNO1
     * @param string $mOK
     * @param string $oT
     * @param string $tARIH
     * @param string $cIKIS_SUBESI
     * @param string $vARIS_SUBESI
     * @param string $aLICI_ADI
     * @param string $sEHIR
     * @param float $tUTAR
     * @param float $tOPLAM_ADET
     * @param float $pARCA_NO
     * @param string $tESLIM_ALAN
     * @param string $tESLIM_TARIHI
     * @param string $tESLIM_SAATI
     * @param string $iADE
     * @param string $dEPO_KODU
     */
    public function __construct($aDRES_ADI = null, $aDRES_KODU = null, $mUSTERI_KODU = null, $sERI = null, $iRSNO = null, $rEFNO = null, $iRSNO1 = null, $mOK = null, $oT = null, $tARIH = null, $cIKIS_SUBESI = null, $vARIS_SUBESI = null, $aLICI_ADI = null, $sEHIR = null, $tUTAR = null, $tOPLAM_ADET = null, $pARCA_NO = null, $tESLIM_ALAN = null, $tESLIM_TARIHI = null, $tESLIM_SAATI = null, $iADE = null, $dEPO_KODU = null)
    {
        $this
            ->setADRES_ADI($aDRES_ADI)
            ->setADRES_KODU($aDRES_KODU)
            ->setMUSTERI_KODU($mUSTERI_KODU)
            ->setSERI($sERI)
            ->setIRSNO($iRSNO)
            ->setREFNO($rEFNO)
            ->setIRSNO1($iRSNO1)
            ->setMOK($mOK)
            ->setOT($oT)
            ->setTARIH($tARIH)
            ->setCIKIS_SUBESI($cIKIS_SUBESI)
            ->setVARIS_SUBESI($vARIS_SUBESI)
            ->setALICI_ADI($aLICI_ADI)
            ->setSEHIR($sEHIR)
            ->setTUTAR($tUTAR)
            ->setTOPLAM_ADET($tOPLAM_ADET)
            ->setPARCA_NO($pARCA_NO)
            ->setTESLIM_ALAN($tESLIM_ALAN)
            ->setTESLIM_TARIHI($tESLIM_TARIHI)
            ->setTESLIM_SAATI($tESLIM_SAATI)
            ->setIADE($iADE)
            ->setDEPO_KODU($dEPO_KODU);
    }
    /**
     * Get ADRES_ADI value
     * @return string|null
     */
    public function getADRES_ADI()
    {
        return $this->ADRES_ADI;
    }
    /**
     * Set ADRES_ADI value
     * @param string $aDRES_ADI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setADRES_ADI($aDRES_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($aDRES_ADI) && !is_string($aDRES_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aDRES_ADI, true), gettype($aDRES_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aDRES_ADI) && mb_strlen($aDRES_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aDRES_ADI)), __LINE__);
        }
        $this->ADRES_ADI = $aDRES_ADI;
        return $this;
    }
    /**
     * Get ADRES_KODU value
     * @return string|null
     */
    public function getADRES_KODU()
    {
        return $this->ADRES_KODU;
    }
    /**
     * Set ADRES_KODU value
     * @param string $aDRES_KODU
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setADRES_KODU($aDRES_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($aDRES_KODU) && !is_string($aDRES_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aDRES_KODU, true), gettype($aDRES_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($aDRES_KODU) && mb_strlen($aDRES_KODU) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($aDRES_KODU)), __LINE__);
        }
        $this->ADRES_KODU = $aDRES_KODU;
        return $this;
    }
    /**
     * Get MUSTERI_KODU value
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }
    /**
     * Set MUSTERI_KODU value
     * @param string $mUSTERI_KODU
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setMUSTERI_KODU($mUSTERI_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($mUSTERI_KODU) && !is_string($mUSTERI_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mUSTERI_KODU, true), gettype($mUSTERI_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mUSTERI_KODU) && mb_strlen($mUSTERI_KODU) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mUSTERI_KODU)), __LINE__);
        }
        $this->MUSTERI_KODU = $mUSTERI_KODU;
        return $this;
    }
    /**
     * Get SERI value
     * @return string|null
     */
    public function getSERI()
    {
        return $this->SERI;
    }
    /**
     * Set SERI value
     * @param string $sERI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setSERI($sERI = null)
    {
        // validation for constraint: string
        if (!is_null($sERI) && !is_string($sERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sERI, true), gettype($sERI)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($sERI) && mb_strlen($sERI) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($sERI)), __LINE__);
        }
        $this->SERI = $sERI;
        return $this;
    }
    /**
     * Get IRSNO value
     * @return string|null
     */
    public function getIRSNO()
    {
        return $this->IRSNO;
    }
    /**
     * Set IRSNO value
     * @param string $iRSNO
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setIRSNO($iRSNO = null)
    {
        // validation for constraint: string
        if (!is_null($iRSNO) && !is_string($iRSNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSNO, true), gettype($iRSNO)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($iRSNO) && mb_strlen($iRSNO) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($iRSNO)), __LINE__);
        }
        $this->IRSNO = $iRSNO;
        return $this;
    }
    /**
     * Get REFNO value
     * @return string|null
     */
    public function getREFNO()
    {
        return $this->REFNO;
    }
    /**
     * Set REFNO value
     * @param string $rEFNO
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setREFNO($rEFNO = null)
    {
        // validation for constraint: string
        if (!is_null($rEFNO) && !is_string($rEFNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFNO, true), gettype($rEFNO)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($rEFNO) && mb_strlen($rEFNO) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($rEFNO)), __LINE__);
        }
        $this->REFNO = $rEFNO;
        return $this;
    }
    /**
     * Get IRSNO1 value
     * @return string|null
     */
    public function getIRSNO1()
    {
        return $this->IRSNO1;
    }
    /**
     * Set IRSNO1 value
     * @param string $iRSNO1
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setIRSNO1($iRSNO1 = null)
    {
        // validation for constraint: string
        if (!is_null($iRSNO1) && !is_string($iRSNO1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSNO1, true), gettype($iRSNO1)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($iRSNO1) && mb_strlen($iRSNO1) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($iRSNO1)), __LINE__);
        }
        $this->IRSNO1 = $iRSNO1;
        return $this;
    }
    /**
     * Get MOK value
     * @return string|null
     */
    public function getMOK()
    {
        return $this->MOK;
    }
    /**
     * Set MOK value
     * @param string $mOK
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setMOK($mOK = null)
    {
        // validation for constraint: string
        if (!is_null($mOK) && !is_string($mOK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOK, true), gettype($mOK)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mOK) && mb_strlen($mOK) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mOK)), __LINE__);
        }
        $this->MOK = $mOK;
        return $this;
    }
    /**
     * Get OT value
     * @return string|null
     */
    public function getOT()
    {
        return $this->OT;
    }
    /**
     * Set OT value
     * @param string $oT
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setOT($oT = null)
    {
        // validation for constraint: string
        if (!is_null($oT) && !is_string($oT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oT, true), gettype($oT)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($oT) && mb_strlen($oT) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($oT)), __LINE__);
        }
        $this->OT = $oT;
        return $this;
    }
    /**
     * Get TARIH value
     * @return string|null
     */
    public function getTARIH()
    {
        return $this->TARIH;
    }
    /**
     * Set TARIH value
     * @param string $tARIH
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setTARIH($tARIH = null)
    {
        // validation for constraint: string
        if (!is_null($tARIH) && !is_string($tARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tARIH, true), gettype($tARIH)), __LINE__);
        }
        // validation for constraint: maxLength(19)
        if (!is_null($tARIH) && mb_strlen($tARIH) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 19', mb_strlen($tARIH)), __LINE__);
        }
        $this->TARIH = $tARIH;
        return $this;
    }
    /**
     * Get CIKIS_SUBESI value
     * @return string|null
     */
    public function getCIKIS_SUBESI()
    {
        return $this->CIKIS_SUBESI;
    }
    /**
     * Set CIKIS_SUBESI value
     * @param string $cIKIS_SUBESI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setCIKIS_SUBESI($cIKIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_SUBESI) && !is_string($cIKIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_SUBESI, true), gettype($cIKIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($cIKIS_SUBESI) && mb_strlen($cIKIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($cIKIS_SUBESI)), __LINE__);
        }
        $this->CIKIS_SUBESI = $cIKIS_SUBESI;
        return $this;
    }
    /**
     * Get VARIS_SUBESI value
     * @return string|null
     */
    public function getVARIS_SUBESI()
    {
        return $this->VARIS_SUBESI;
    }
    /**
     * Set VARIS_SUBESI value
     * @param string $vARIS_SUBESI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setVARIS_SUBESI($vARIS_SUBESI = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_SUBESI) && !is_string($vARIS_SUBESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_SUBESI, true), gettype($vARIS_SUBESI)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vARIS_SUBESI) && mb_strlen($vARIS_SUBESI) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vARIS_SUBESI)), __LINE__);
        }
        $this->VARIS_SUBESI = $vARIS_SUBESI;
        return $this;
    }
    /**
     * Get ALICI_ADI value
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }
    /**
     * Set ALICI_ADI value
     * @param string $aLICI_ADI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setALICI_ADI($aLICI_ADI = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI_ADI) && !is_string($aLICI_ADI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI_ADI, true), gettype($aLICI_ADI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aLICI_ADI) && mb_strlen($aLICI_ADI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aLICI_ADI)), __LINE__);
        }
        $this->ALICI_ADI = $aLICI_ADI;
        return $this;
    }
    /**
     * Get SEHIR value
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }
    /**
     * Set SEHIR value
     * @param string $sEHIR
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setSEHIR($sEHIR = null)
    {
        // validation for constraint: string
        if (!is_null($sEHIR) && !is_string($sEHIR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sEHIR, true), gettype($sEHIR)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($sEHIR) && mb_strlen($sEHIR) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($sEHIR)), __LINE__);
        }
        $this->SEHIR = $sEHIR;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setTUTAR($tUTAR = null)
    {
        // validation for constraint: float
        if (!is_null($tUTAR) && !(is_float($tUTAR) || is_numeric($tUTAR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tUTAR, true), gettype($tUTAR)), __LINE__);
        }
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get TOPLAM_ADET value
     * @return float|null
     */
    public function getTOPLAM_ADET()
    {
        return $this->TOPLAM_ADET;
    }
    /**
     * Set TOPLAM_ADET value
     * @param float $tOPLAM_ADET
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setTOPLAM_ADET($tOPLAM_ADET = null)
    {
        // validation for constraint: float
        if (!is_null($tOPLAM_ADET) && !(is_float($tOPLAM_ADET) || is_numeric($tOPLAM_ADET))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tOPLAM_ADET, true), gettype($tOPLAM_ADET)), __LINE__);
        }
        $this->TOPLAM_ADET = $tOPLAM_ADET;
        return $this;
    }
    /**
     * Get PARCA_NO value
     * @return float|null
     */
    public function getPARCA_NO()
    {
        return $this->PARCA_NO;
    }
    /**
     * Set PARCA_NO value
     * @param float $pARCA_NO
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setPARCA_NO($pARCA_NO = null)
    {
        // validation for constraint: float
        if (!is_null($pARCA_NO) && !(is_float($pARCA_NO) || is_numeric($pARCA_NO))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pARCA_NO, true), gettype($pARCA_NO)), __LINE__);
        }
        $this->PARCA_NO = $pARCA_NO;
        return $this;
    }
    /**
     * Get TESLIM_ALAN value
     * @return string|null
     */
    public function getTESLIM_ALAN()
    {
        return $this->TESLIM_ALAN;
    }
    /**
     * Set TESLIM_ALAN value
     * @param string $tESLIM_ALAN
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setTESLIM_ALAN($tESLIM_ALAN = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_ALAN) && !is_string($tESLIM_ALAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_ALAN, true), gettype($tESLIM_ALAN)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($tESLIM_ALAN) && mb_strlen($tESLIM_ALAN) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($tESLIM_ALAN)), __LINE__);
        }
        $this->TESLIM_ALAN = $tESLIM_ALAN;
        return $this;
    }
    /**
     * Get TESLIM_TARIHI value
     * @return string|null
     */
    public function getTESLIM_TARIHI()
    {
        return $this->TESLIM_TARIHI;
    }
    /**
     * Set TESLIM_TARIHI value
     * @param string $tESLIM_TARIHI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setTESLIM_TARIHI($tESLIM_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_TARIHI) && !is_string($tESLIM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_TARIHI, true), gettype($tESLIM_TARIHI)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tESLIM_TARIHI) && mb_strlen($tESLIM_TARIHI) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tESLIM_TARIHI)), __LINE__);
        }
        $this->TESLIM_TARIHI = $tESLIM_TARIHI;
        return $this;
    }
    /**
     * Get TESLIM_SAATI value
     * @return string|null
     */
    public function getTESLIM_SAATI()
    {
        return $this->TESLIM_SAATI;
    }
    /**
     * Set TESLIM_SAATI value
     * @param string $tESLIM_SAATI
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setTESLIM_SAATI($tESLIM_SAATI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_SAATI) && !is_string($tESLIM_SAATI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_SAATI, true), gettype($tESLIM_SAATI)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($tESLIM_SAATI) && mb_strlen($tESLIM_SAATI) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($tESLIM_SAATI)), __LINE__);
        }
        $this->TESLIM_SAATI = $tESLIM_SAATI;
        return $this;
    }
    /**
     * Get IADE value
     * @return string|null
     */
    public function getIADE()
    {
        return $this->IADE;
    }
    /**
     * Set IADE value
     * @param string $iADE
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setIADE($iADE = null)
    {
        // validation for constraint: string
        if (!is_null($iADE) && !is_string($iADE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iADE, true), gettype($iADE)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($iADE) && mb_strlen($iADE) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($iADE)), __LINE__);
        }
        $this->IADE = $iADE;
        return $this;
    }
    /**
     * Get DEPO_KODU value
     * @return string|null
     */
    public function getDEPO_KODU()
    {
        return $this->DEPO_KODU;
    }
    /**
     * Set DEPO_KODU value
     * @param string $dEPO_KODU
     * @return \Ys\ArasKargo\StructType\WEBCARGODATA12
     */
    public function setDEPO_KODU($dEPO_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($dEPO_KODU) && !is_string($dEPO_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dEPO_KODU, true), gettype($dEPO_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($dEPO_KODU) && mb_strlen($dEPO_KODU) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($dEPO_KODU)), __LINE__);
        }
        $this->DEPO_KODU = $dEPO_KODU;
        return $this;
    }
}
