<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UNIT1 StructType
 * @subpackage Structs
 */
class UNIT1 extends AbstractStructBase
{
    /**
     * The ACCOUNTCUSTOMERID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ACCOUNTCUSTOMERID;
    /**
     * The ADDRESS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 256
     * - minOccurs: 0
     * @var string
     */
    public $ADDRESS;
    /**
     * The APPLICATIONID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The APPLICATION_VERSION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The AUDITCREATEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDITMODIFIEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_CREATE_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDIT_DELETED
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The CAN_ACCEPTS_CARGO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_ACCEPTS_CARGO;
    /**
     * The CAN_COLLECTION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_COLLECTION;
    /**
     * The CAN_COLLECTION_REDIRECTION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_COLLECTION_REDIRECTION;
    /**
     * The CAN_DISTRIBUTION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_DISTRIBUTION;
    /**
     * The CAN_INTERNAL_CARGO
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_INTERNAL_CARGO;
    /**
     * The CAN_INVOICE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_INVOICE;
    /**
     * The CAN_REDIRECTION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_REDIRECTION;
    /**
     * The CAN_WAYBILL
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CAN_WAYBILL;
    /**
     * The CLOSED
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CLOSED;
    /**
     * The CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * @var string
     */
    public $CODE;
    /**
     * The DISCOUNT_RATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DISCOUNT_RATE;
    /**
     * The EMAIL1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $EMAIL1;
    /**
     * The EMAIL2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $EMAIL2;
    /**
     * The FINISH_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FINISH_DATE;
    /**
     * The HINTCITYID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HINTCITYID;
    /**
     * The HINTTOWNID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HINTTOWNID;
    /**
     * The LOVORGANIZATIONID
     * @var float
     */
    public $LOVORGANIZATIONID;
    /**
     * The LOVUNITGROUPID
     * @var float
     */
    public $LOVUNITGROUPID;
    /**
     * The LOVUNITTYPEID
     * @var float
     */
    public $LOVUNITTYPEID;
    /**
     * The MANIFESTUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MANIFESTUNITID;
    /**
     * The MERSIS_NUMBER
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 36
     * - minOccurs: 0
     * @var string
     */
    public $MERSIS_NUMBER;
    /**
     * The MOBILE_PHONE1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MOBILE_PHONE1;
    /**
     * The MOBILE_PHONE2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MOBILE_PHONE2;
    /**
     * The NAME
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $NAME;
    /**
     * The OLD_UNITID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $OLD_UNITID;
    /**
     * The OPERATION_CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minOccurs: 0
     * @var string
     */
    public $OPERATION_CODE;
    /**
     * The PARENTUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PARENTUNITID;
    /**
     * The PHONE1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $PHONE1;
    /**
     * The PHONE2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $PHONE2;
    /**
     * The RECEIVERHUBUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RECEIVERHUBUNITID;
    /**
     * The REPLACEUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $REPLACEUNITID;
    /**
     * The RINGHUBUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $RINGHUBUNITID;
    /**
     * The ROUTETEMPLATEID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ROUTETEMPLATEID;
    /**
     * The SENDERHUBUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SENDERHUBUNITID;
    /**
     * The SHORT_CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $SHORT_CODE;
    /**
     * The START_DATE
     * @var string
     */
    public $START_DATE;
    /**
     * The UNITID
     * @var float
     */
    public $UNITID;
    /**
     * Constructor method for UNIT1
     * @uses UNIT1::setACCOUNTCUSTOMERID()
     * @uses UNIT1::setADDRESS()
     * @uses UNIT1::setAPPLICATIONID()
     * @uses UNIT1::setAPPLICATION_VERSION()
     * @uses UNIT1::setAUDITCREATEDBY()
     * @uses UNIT1::setAUDITCREATEUNITID()
     * @uses UNIT1::setAUDITMODIFIEDBY()
     * @uses UNIT1::setAUDITMODIFYUNITID()
     * @uses UNIT1::setAUDIT_CREATE_DATE()
     * @uses UNIT1::setAUDIT_DELETED()
     * @uses UNIT1::setAUDIT_MODIFY_DATE()
     * @uses UNIT1::setCAN_ACCEPTS_CARGO()
     * @uses UNIT1::setCAN_COLLECTION()
     * @uses UNIT1::setCAN_COLLECTION_REDIRECTION()
     * @uses UNIT1::setCAN_DISTRIBUTION()
     * @uses UNIT1::setCAN_INTERNAL_CARGO()
     * @uses UNIT1::setCAN_INVOICE()
     * @uses UNIT1::setCAN_REDIRECTION()
     * @uses UNIT1::setCAN_WAYBILL()
     * @uses UNIT1::setCLOSED()
     * @uses UNIT1::setCODE()
     * @uses UNIT1::setDISCOUNT_RATE()
     * @uses UNIT1::setEMAIL1()
     * @uses UNIT1::setEMAIL2()
     * @uses UNIT1::setFINISH_DATE()
     * @uses UNIT1::setHINTCITYID()
     * @uses UNIT1::setHINTTOWNID()
     * @uses UNIT1::setLOVORGANIZATIONID()
     * @uses UNIT1::setLOVUNITGROUPID()
     * @uses UNIT1::setLOVUNITTYPEID()
     * @uses UNIT1::setMANIFESTUNITID()
     * @uses UNIT1::setMERSIS_NUMBER()
     * @uses UNIT1::setMOBILE_PHONE1()
     * @uses UNIT1::setMOBILE_PHONE2()
     * @uses UNIT1::setNAME()
     * @uses UNIT1::setOLD_UNITID()
     * @uses UNIT1::setOPERATION_CODE()
     * @uses UNIT1::setPARENTUNITID()
     * @uses UNIT1::setPHONE1()
     * @uses UNIT1::setPHONE2()
     * @uses UNIT1::setRECEIVERHUBUNITID()
     * @uses UNIT1::setREPLACEUNITID()
     * @uses UNIT1::setRINGHUBUNITID()
     * @uses UNIT1::setROUTETEMPLATEID()
     * @uses UNIT1::setSENDERHUBUNITID()
     * @uses UNIT1::setSHORT_CODE()
     * @uses UNIT1::setSTART_DATE()
     * @uses UNIT1::setUNITID()
     * @param string $aCCOUNTCUSTOMERID
     * @param string $aDDRESS
     * @param float $aPPLICATIONID
     * @param string $aPPLICATION_VERSION
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_CREATE_DATE
     * @param string $aUDIT_DELETED
     * @param string $aUDIT_MODIFY_DATE
     * @param string $cAN_ACCEPTS_CARGO
     * @param string $cAN_COLLECTION
     * @param string $cAN_COLLECTION_REDIRECTION
     * @param string $cAN_DISTRIBUTION
     * @param string $cAN_INTERNAL_CARGO
     * @param string $cAN_INVOICE
     * @param string $cAN_REDIRECTION
     * @param string $cAN_WAYBILL
     * @param string $cLOSED
     * @param string $cODE
     * @param float $dISCOUNT_RATE
     * @param string $eMAIL1
     * @param string $eMAIL2
     * @param string $fINISH_DATE
     * @param string $hINTCITYID
     * @param string $hINTTOWNID
     * @param float $lOVORGANIZATIONID
     * @param float $lOVUNITGROUPID
     * @param float $lOVUNITTYPEID
     * @param float $mANIFESTUNITID
     * @param string $mERSIS_NUMBER
     * @param string $mOBILE_PHONE1
     * @param string $mOBILE_PHONE2
     * @param string $nAME
     * @param string $oLD_UNITID
     * @param string $oPERATION_CODE
     * @param float $pARENTUNITID
     * @param string $pHONE1
     * @param string $pHONE2
     * @param float $rECEIVERHUBUNITID
     * @param float $rEPLACEUNITID
     * @param float $rINGHUBUNITID
     * @param string $rOUTETEMPLATEID
     * @param float $sENDERHUBUNITID
     * @param string $sHORT_CODE
     * @param string $sTART_DATE
     * @param float $uNITID
     */
    public function __construct($aCCOUNTCUSTOMERID = null, $aDDRESS = null, $aPPLICATIONID = null, $aPPLICATION_VERSION = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_CREATE_DATE = null, $aUDIT_DELETED = null, $aUDIT_MODIFY_DATE = null, $cAN_ACCEPTS_CARGO = null, $cAN_COLLECTION = null, $cAN_COLLECTION_REDIRECTION = null, $cAN_DISTRIBUTION = null, $cAN_INTERNAL_CARGO = null, $cAN_INVOICE = null, $cAN_REDIRECTION = null, $cAN_WAYBILL = null, $cLOSED = null, $cODE = null, $dISCOUNT_RATE = null, $eMAIL1 = null, $eMAIL2 = null, $fINISH_DATE = null, $hINTCITYID = null, $hINTTOWNID = null, $lOVORGANIZATIONID = null, $lOVUNITGROUPID = null, $lOVUNITTYPEID = null, $mANIFESTUNITID = null, $mERSIS_NUMBER = null, $mOBILE_PHONE1 = null, $mOBILE_PHONE2 = null, $nAME = null, $oLD_UNITID = null, $oPERATION_CODE = null, $pARENTUNITID = null, $pHONE1 = null, $pHONE2 = null, $rECEIVERHUBUNITID = null, $rEPLACEUNITID = null, $rINGHUBUNITID = null, $rOUTETEMPLATEID = null, $sENDERHUBUNITID = null, $sHORT_CODE = null, $sTART_DATE = null, $uNITID = null)
    {
        $this
            ->setACCOUNTCUSTOMERID($aCCOUNTCUSTOMERID)
            ->setADDRESS($aDDRESS)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setCAN_ACCEPTS_CARGO($cAN_ACCEPTS_CARGO)
            ->setCAN_COLLECTION($cAN_COLLECTION)
            ->setCAN_COLLECTION_REDIRECTION($cAN_COLLECTION_REDIRECTION)
            ->setCAN_DISTRIBUTION($cAN_DISTRIBUTION)
            ->setCAN_INTERNAL_CARGO($cAN_INTERNAL_CARGO)
            ->setCAN_INVOICE($cAN_INVOICE)
            ->setCAN_REDIRECTION($cAN_REDIRECTION)
            ->setCAN_WAYBILL($cAN_WAYBILL)
            ->setCLOSED($cLOSED)
            ->setCODE($cODE)
            ->setDISCOUNT_RATE($dISCOUNT_RATE)
            ->setEMAIL1($eMAIL1)
            ->setEMAIL2($eMAIL2)
            ->setFINISH_DATE($fINISH_DATE)
            ->setHINTCITYID($hINTCITYID)
            ->setHINTTOWNID($hINTTOWNID)
            ->setLOVORGANIZATIONID($lOVORGANIZATIONID)
            ->setLOVUNITGROUPID($lOVUNITGROUPID)
            ->setLOVUNITTYPEID($lOVUNITTYPEID)
            ->setMANIFESTUNITID($mANIFESTUNITID)
            ->setMERSIS_NUMBER($mERSIS_NUMBER)
            ->setMOBILE_PHONE1($mOBILE_PHONE1)
            ->setMOBILE_PHONE2($mOBILE_PHONE2)
            ->setNAME($nAME)
            ->setOLD_UNITID($oLD_UNITID)
            ->setOPERATION_CODE($oPERATION_CODE)
            ->setPARENTUNITID($pARENTUNITID)
            ->setPHONE1($pHONE1)
            ->setPHONE2($pHONE2)
            ->setRECEIVERHUBUNITID($rECEIVERHUBUNITID)
            ->setREPLACEUNITID($rEPLACEUNITID)
            ->setRINGHUBUNITID($rINGHUBUNITID)
            ->setROUTETEMPLATEID($rOUTETEMPLATEID)
            ->setSENDERHUBUNITID($sENDERHUBUNITID)
            ->setSHORT_CODE($sHORT_CODE)
            ->setSTART_DATE($sTART_DATE)
            ->setUNITID($uNITID);
    }
    /**
     * Get ACCOUNTCUSTOMERID value
     * @return string|null
     */
    public function getACCOUNTCUSTOMERID()
    {
        return $this->ACCOUNTCUSTOMERID;
    }
    /**
     * Set ACCOUNTCUSTOMERID value
     * @param string $aCCOUNTCUSTOMERID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setACCOUNTCUSTOMERID($aCCOUNTCUSTOMERID = null)
    {
        // validation for constraint: string
        if (!is_null($aCCOUNTCUSTOMERID) && !is_string($aCCOUNTCUSTOMERID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aCCOUNTCUSTOMERID, true), gettype($aCCOUNTCUSTOMERID)), __LINE__);
        }
        $this->ACCOUNTCUSTOMERID = $aCCOUNTCUSTOMERID;
        return $this;
    }
    /**
     * Get ADDRESS value
     * @return string|null
     */
    public function getADDRESS()
    {
        return $this->ADDRESS;
    }
    /**
     * Set ADDRESS value
     * @param string $aDDRESS
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setADDRESS($aDDRESS = null)
    {
        // validation for constraint: string
        if (!is_null($aDDRESS) && !is_string($aDDRESS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aDDRESS, true), gettype($aDDRESS)), __LINE__);
        }
        // validation for constraint: maxLength(256)
        if (!is_null($aDDRESS) && mb_strlen($aDDRESS) > 256) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 256', mb_strlen($aDDRESS)), __LINE__);
        }
        $this->ADDRESS = $aDDRESS;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        // validation for constraint: float
        if (!is_null($aPPLICATIONID) && !(is_float($aPPLICATIONID) || is_numeric($aPPLICATIONID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aPPLICATIONID, true), gettype($aPPLICATIONID)), __LINE__);
        }
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPPLICATION_VERSION, true), gettype($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($aPPLICATION_VERSION) && mb_strlen($aPPLICATION_VERSION) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEDBY) && !(is_float($aUDITCREATEDBY) || is_numeric($aUDITCREATEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEDBY, true), gettype($aUDITCREATEDBY)), __LINE__);
        }
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEUNITID) && !(is_float($aUDITCREATEUNITID) || is_numeric($aUDITCREATEUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEUNITID, true), gettype($aUDITCREATEUNITID)), __LINE__);
        }
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFIEDBY) && !(is_float($aUDITMODIFIEDBY) || is_numeric($aUDITMODIFIEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFIEDBY, true), gettype($aUDITMODIFIEDBY)), __LINE__);
        }
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFYUNITID) && !(is_float($aUDITMODIFYUNITID) || is_numeric($aUDITMODIFYUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFYUNITID, true), gettype($aUDITMODIFYUNITID)), __LINE__);
        }
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_CREATE_DATE, true), gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_DELETED, true), gettype($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aUDIT_DELETED) && mb_strlen($aUDIT_DELETED) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_MODIFY_DATE, true), gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get CAN_ACCEPTS_CARGO value
     * @return string|null
     */
    public function getCAN_ACCEPTS_CARGO()
    {
        return $this->CAN_ACCEPTS_CARGO;
    }
    /**
     * Set CAN_ACCEPTS_CARGO value
     * @param string $cAN_ACCEPTS_CARGO
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_ACCEPTS_CARGO($cAN_ACCEPTS_CARGO = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_ACCEPTS_CARGO) && !is_string($cAN_ACCEPTS_CARGO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_ACCEPTS_CARGO, true), gettype($cAN_ACCEPTS_CARGO)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_ACCEPTS_CARGO) && mb_strlen($cAN_ACCEPTS_CARGO) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_ACCEPTS_CARGO)), __LINE__);
        }
        $this->CAN_ACCEPTS_CARGO = $cAN_ACCEPTS_CARGO;
        return $this;
    }
    /**
     * Get CAN_COLLECTION value
     * @return string|null
     */
    public function getCAN_COLLECTION()
    {
        return $this->CAN_COLLECTION;
    }
    /**
     * Set CAN_COLLECTION value
     * @param string $cAN_COLLECTION
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_COLLECTION($cAN_COLLECTION = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_COLLECTION) && !is_string($cAN_COLLECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_COLLECTION, true), gettype($cAN_COLLECTION)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_COLLECTION) && mb_strlen($cAN_COLLECTION) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_COLLECTION)), __LINE__);
        }
        $this->CAN_COLLECTION = $cAN_COLLECTION;
        return $this;
    }
    /**
     * Get CAN_COLLECTION_REDIRECTION value
     * @return string|null
     */
    public function getCAN_COLLECTION_REDIRECTION()
    {
        return $this->CAN_COLLECTION_REDIRECTION;
    }
    /**
     * Set CAN_COLLECTION_REDIRECTION value
     * @param string $cAN_COLLECTION_REDIRECTION
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_COLLECTION_REDIRECTION($cAN_COLLECTION_REDIRECTION = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_COLLECTION_REDIRECTION) && !is_string($cAN_COLLECTION_REDIRECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_COLLECTION_REDIRECTION, true), gettype($cAN_COLLECTION_REDIRECTION)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_COLLECTION_REDIRECTION) && mb_strlen($cAN_COLLECTION_REDIRECTION) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_COLLECTION_REDIRECTION)), __LINE__);
        }
        $this->CAN_COLLECTION_REDIRECTION = $cAN_COLLECTION_REDIRECTION;
        return $this;
    }
    /**
     * Get CAN_DISTRIBUTION value
     * @return string|null
     */
    public function getCAN_DISTRIBUTION()
    {
        return $this->CAN_DISTRIBUTION;
    }
    /**
     * Set CAN_DISTRIBUTION value
     * @param string $cAN_DISTRIBUTION
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_DISTRIBUTION($cAN_DISTRIBUTION = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_DISTRIBUTION) && !is_string($cAN_DISTRIBUTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_DISTRIBUTION, true), gettype($cAN_DISTRIBUTION)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_DISTRIBUTION) && mb_strlen($cAN_DISTRIBUTION) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_DISTRIBUTION)), __LINE__);
        }
        $this->CAN_DISTRIBUTION = $cAN_DISTRIBUTION;
        return $this;
    }
    /**
     * Get CAN_INTERNAL_CARGO value
     * @return string|null
     */
    public function getCAN_INTERNAL_CARGO()
    {
        return $this->CAN_INTERNAL_CARGO;
    }
    /**
     * Set CAN_INTERNAL_CARGO value
     * @param string $cAN_INTERNAL_CARGO
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_INTERNAL_CARGO($cAN_INTERNAL_CARGO = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_INTERNAL_CARGO) && !is_string($cAN_INTERNAL_CARGO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_INTERNAL_CARGO, true), gettype($cAN_INTERNAL_CARGO)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_INTERNAL_CARGO) && mb_strlen($cAN_INTERNAL_CARGO) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_INTERNAL_CARGO)), __LINE__);
        }
        $this->CAN_INTERNAL_CARGO = $cAN_INTERNAL_CARGO;
        return $this;
    }
    /**
     * Get CAN_INVOICE value
     * @return string|null
     */
    public function getCAN_INVOICE()
    {
        return $this->CAN_INVOICE;
    }
    /**
     * Set CAN_INVOICE value
     * @param string $cAN_INVOICE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_INVOICE($cAN_INVOICE = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_INVOICE) && !is_string($cAN_INVOICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_INVOICE, true), gettype($cAN_INVOICE)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_INVOICE) && mb_strlen($cAN_INVOICE) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_INVOICE)), __LINE__);
        }
        $this->CAN_INVOICE = $cAN_INVOICE;
        return $this;
    }
    /**
     * Get CAN_REDIRECTION value
     * @return string|null
     */
    public function getCAN_REDIRECTION()
    {
        return $this->CAN_REDIRECTION;
    }
    /**
     * Set CAN_REDIRECTION value
     * @param string $cAN_REDIRECTION
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_REDIRECTION($cAN_REDIRECTION = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_REDIRECTION) && !is_string($cAN_REDIRECTION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_REDIRECTION, true), gettype($cAN_REDIRECTION)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_REDIRECTION) && mb_strlen($cAN_REDIRECTION) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_REDIRECTION)), __LINE__);
        }
        $this->CAN_REDIRECTION = $cAN_REDIRECTION;
        return $this;
    }
    /**
     * Get CAN_WAYBILL value
     * @return string|null
     */
    public function getCAN_WAYBILL()
    {
        return $this->CAN_WAYBILL;
    }
    /**
     * Set CAN_WAYBILL value
     * @param string $cAN_WAYBILL
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCAN_WAYBILL($cAN_WAYBILL = null)
    {
        // validation for constraint: string
        if (!is_null($cAN_WAYBILL) && !is_string($cAN_WAYBILL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAN_WAYBILL, true), gettype($cAN_WAYBILL)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cAN_WAYBILL) && mb_strlen($cAN_WAYBILL) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cAN_WAYBILL)), __LINE__);
        }
        $this->CAN_WAYBILL = $cAN_WAYBILL;
        return $this;
    }
    /**
     * Get CLOSED value
     * @return string|null
     */
    public function getCLOSED()
    {
        return $this->CLOSED;
    }
    /**
     * Set CLOSED value
     * @param string $cLOSED
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCLOSED($cLOSED = null)
    {
        // validation for constraint: string
        if (!is_null($cLOSED) && !is_string($cLOSED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cLOSED, true), gettype($cLOSED)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($cLOSED) && mb_strlen($cLOSED) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($cLOSED)), __LINE__);
        }
        $this->CLOSED = $cLOSED;
        return $this;
    }
    /**
     * Get CODE value
     * @return string|null
     */
    public function getCODE()
    {
        return $this->CODE;
    }
    /**
     * Set CODE value
     * @param string $cODE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setCODE($cODE = null)
    {
        // validation for constraint: string
        if (!is_null($cODE) && !is_string($cODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cODE, true), gettype($cODE)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($cODE) && mb_strlen($cODE) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($cODE)), __LINE__);
        }
        $this->CODE = $cODE;
        return $this;
    }
    /**
     * Get DISCOUNT_RATE value
     * @return float|null
     */
    public function getDISCOUNT_RATE()
    {
        return $this->DISCOUNT_RATE;
    }
    /**
     * Set DISCOUNT_RATE value
     * @param float $dISCOUNT_RATE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setDISCOUNT_RATE($dISCOUNT_RATE = null)
    {
        // validation for constraint: float
        if (!is_null($dISCOUNT_RATE) && !(is_float($dISCOUNT_RATE) || is_numeric($dISCOUNT_RATE))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dISCOUNT_RATE, true), gettype($dISCOUNT_RATE)), __LINE__);
        }
        $this->DISCOUNT_RATE = $dISCOUNT_RATE;
        return $this;
    }
    /**
     * Get EMAIL1 value
     * @return string|null
     */
    public function getEMAIL1()
    {
        return $this->EMAIL1;
    }
    /**
     * Set EMAIL1 value
     * @param string $eMAIL1
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setEMAIL1($eMAIL1 = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL1) && !is_string($eMAIL1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMAIL1, true), gettype($eMAIL1)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($eMAIL1) && mb_strlen($eMAIL1) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($eMAIL1)), __LINE__);
        }
        $this->EMAIL1 = $eMAIL1;
        return $this;
    }
    /**
     * Get EMAIL2 value
     * @return string|null
     */
    public function getEMAIL2()
    {
        return $this->EMAIL2;
    }
    /**
     * Set EMAIL2 value
     * @param string $eMAIL2
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setEMAIL2($eMAIL2 = null)
    {
        // validation for constraint: string
        if (!is_null($eMAIL2) && !is_string($eMAIL2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMAIL2, true), gettype($eMAIL2)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($eMAIL2) && mb_strlen($eMAIL2) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($eMAIL2)), __LINE__);
        }
        $this->EMAIL2 = $eMAIL2;
        return $this;
    }
    /**
     * Get FINISH_DATE value
     * @return string|null
     */
    public function getFINISH_DATE()
    {
        return $this->FINISH_DATE;
    }
    /**
     * Set FINISH_DATE value
     * @param string $fINISH_DATE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setFINISH_DATE($fINISH_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($fINISH_DATE) && !is_string($fINISH_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fINISH_DATE, true), gettype($fINISH_DATE)), __LINE__);
        }
        $this->FINISH_DATE = $fINISH_DATE;
        return $this;
    }
    /**
     * Get HINTCITYID value
     * @return string|null
     */
    public function getHINTCITYID()
    {
        return $this->HINTCITYID;
    }
    /**
     * Set HINTCITYID value
     * @param string $hINTCITYID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setHINTCITYID($hINTCITYID = null)
    {
        // validation for constraint: string
        if (!is_null($hINTCITYID) && !is_string($hINTCITYID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hINTCITYID, true), gettype($hINTCITYID)), __LINE__);
        }
        $this->HINTCITYID = $hINTCITYID;
        return $this;
    }
    /**
     * Get HINTTOWNID value
     * @return string|null
     */
    public function getHINTTOWNID()
    {
        return $this->HINTTOWNID;
    }
    /**
     * Set HINTTOWNID value
     * @param string $hINTTOWNID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setHINTTOWNID($hINTTOWNID = null)
    {
        // validation for constraint: string
        if (!is_null($hINTTOWNID) && !is_string($hINTTOWNID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hINTTOWNID, true), gettype($hINTTOWNID)), __LINE__);
        }
        $this->HINTTOWNID = $hINTTOWNID;
        return $this;
    }
    /**
     * Get LOVORGANIZATIONID value
     * @return float|null
     */
    public function getLOVORGANIZATIONID()
    {
        return $this->LOVORGANIZATIONID;
    }
    /**
     * Set LOVORGANIZATIONID value
     * @param float $lOVORGANIZATIONID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setLOVORGANIZATIONID($lOVORGANIZATIONID = null)
    {
        // validation for constraint: float
        if (!is_null($lOVORGANIZATIONID) && !(is_float($lOVORGANIZATIONID) || is_numeric($lOVORGANIZATIONID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lOVORGANIZATIONID, true), gettype($lOVORGANIZATIONID)), __LINE__);
        }
        $this->LOVORGANIZATIONID = $lOVORGANIZATIONID;
        return $this;
    }
    /**
     * Get LOVUNITGROUPID value
     * @return float|null
     */
    public function getLOVUNITGROUPID()
    {
        return $this->LOVUNITGROUPID;
    }
    /**
     * Set LOVUNITGROUPID value
     * @param float $lOVUNITGROUPID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setLOVUNITGROUPID($lOVUNITGROUPID = null)
    {
        // validation for constraint: float
        if (!is_null($lOVUNITGROUPID) && !(is_float($lOVUNITGROUPID) || is_numeric($lOVUNITGROUPID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lOVUNITGROUPID, true), gettype($lOVUNITGROUPID)), __LINE__);
        }
        $this->LOVUNITGROUPID = $lOVUNITGROUPID;
        return $this;
    }
    /**
     * Get LOVUNITTYPEID value
     * @return float|null
     */
    public function getLOVUNITTYPEID()
    {
        return $this->LOVUNITTYPEID;
    }
    /**
     * Set LOVUNITTYPEID value
     * @param float $lOVUNITTYPEID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setLOVUNITTYPEID($lOVUNITTYPEID = null)
    {
        // validation for constraint: float
        if (!is_null($lOVUNITTYPEID) && !(is_float($lOVUNITTYPEID) || is_numeric($lOVUNITTYPEID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lOVUNITTYPEID, true), gettype($lOVUNITTYPEID)), __LINE__);
        }
        $this->LOVUNITTYPEID = $lOVUNITTYPEID;
        return $this;
    }
    /**
     * Get MANIFESTUNITID value
     * @return float|null
     */
    public function getMANIFESTUNITID()
    {
        return $this->MANIFESTUNITID;
    }
    /**
     * Set MANIFESTUNITID value
     * @param float $mANIFESTUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setMANIFESTUNITID($mANIFESTUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($mANIFESTUNITID) && !(is_float($mANIFESTUNITID) || is_numeric($mANIFESTUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($mANIFESTUNITID, true), gettype($mANIFESTUNITID)), __LINE__);
        }
        $this->MANIFESTUNITID = $mANIFESTUNITID;
        return $this;
    }
    /**
     * Get MERSIS_NUMBER value
     * @return string|null
     */
    public function getMERSIS_NUMBER()
    {
        return $this->MERSIS_NUMBER;
    }
    /**
     * Set MERSIS_NUMBER value
     * @param string $mERSIS_NUMBER
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setMERSIS_NUMBER($mERSIS_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($mERSIS_NUMBER) && !is_string($mERSIS_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mERSIS_NUMBER, true), gettype($mERSIS_NUMBER)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($mERSIS_NUMBER) && mb_strlen($mERSIS_NUMBER) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($mERSIS_NUMBER)), __LINE__);
        }
        $this->MERSIS_NUMBER = $mERSIS_NUMBER;
        return $this;
    }
    /**
     * Get MOBILE_PHONE1 value
     * @return string|null
     */
    public function getMOBILE_PHONE1()
    {
        return $this->MOBILE_PHONE1;
    }
    /**
     * Set MOBILE_PHONE1 value
     * @param string $mOBILE_PHONE1
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setMOBILE_PHONE1($mOBILE_PHONE1 = null)
    {
        // validation for constraint: string
        if (!is_null($mOBILE_PHONE1) && !is_string($mOBILE_PHONE1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOBILE_PHONE1, true), gettype($mOBILE_PHONE1)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mOBILE_PHONE1) && mb_strlen($mOBILE_PHONE1) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mOBILE_PHONE1)), __LINE__);
        }
        $this->MOBILE_PHONE1 = $mOBILE_PHONE1;
        return $this;
    }
    /**
     * Get MOBILE_PHONE2 value
     * @return string|null
     */
    public function getMOBILE_PHONE2()
    {
        return $this->MOBILE_PHONE2;
    }
    /**
     * Set MOBILE_PHONE2 value
     * @param string $mOBILE_PHONE2
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setMOBILE_PHONE2($mOBILE_PHONE2 = null)
    {
        // validation for constraint: string
        if (!is_null($mOBILE_PHONE2) && !is_string($mOBILE_PHONE2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOBILE_PHONE2, true), gettype($mOBILE_PHONE2)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mOBILE_PHONE2) && mb_strlen($mOBILE_PHONE2) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mOBILE_PHONE2)), __LINE__);
        }
        $this->MOBILE_PHONE2 = $mOBILE_PHONE2;
        return $this;
    }
    /**
     * Get NAME value
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }
    /**
     * Set NAME value
     * @param string $nAME
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setNAME($nAME = null)
    {
        // validation for constraint: string
        if (!is_null($nAME) && !is_string($nAME)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nAME, true), gettype($nAME)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($nAME) && mb_strlen($nAME) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($nAME)), __LINE__);
        }
        $this->NAME = $nAME;
        return $this;
    }
    /**
     * Get OLD_UNITID value
     * @return string|null
     */
    public function getOLD_UNITID()
    {
        return $this->OLD_UNITID;
    }
    /**
     * Set OLD_UNITID value
     * @param string $oLD_UNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setOLD_UNITID($oLD_UNITID = null)
    {
        // validation for constraint: string
        if (!is_null($oLD_UNITID) && !is_string($oLD_UNITID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oLD_UNITID, true), gettype($oLD_UNITID)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($oLD_UNITID) && mb_strlen($oLD_UNITID) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($oLD_UNITID)), __LINE__);
        }
        $this->OLD_UNITID = $oLD_UNITID;
        return $this;
    }
    /**
     * Get OPERATION_CODE value
     * @return string|null
     */
    public function getOPERATION_CODE()
    {
        return $this->OPERATION_CODE;
    }
    /**
     * Set OPERATION_CODE value
     * @param string $oPERATION_CODE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setOPERATION_CODE($oPERATION_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($oPERATION_CODE) && !is_string($oPERATION_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oPERATION_CODE, true), gettype($oPERATION_CODE)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($oPERATION_CODE) && mb_strlen($oPERATION_CODE) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($oPERATION_CODE)), __LINE__);
        }
        $this->OPERATION_CODE = $oPERATION_CODE;
        return $this;
    }
    /**
     * Get PARENTUNITID value
     * @return float|null
     */
    public function getPARENTUNITID()
    {
        return $this->PARENTUNITID;
    }
    /**
     * Set PARENTUNITID value
     * @param float $pARENTUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setPARENTUNITID($pARENTUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($pARENTUNITID) && !(is_float($pARENTUNITID) || is_numeric($pARENTUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pARENTUNITID, true), gettype($pARENTUNITID)), __LINE__);
        }
        $this->PARENTUNITID = $pARENTUNITID;
        return $this;
    }
    /**
     * Get PHONE1 value
     * @return string|null
     */
    public function getPHONE1()
    {
        return $this->PHONE1;
    }
    /**
     * Set PHONE1 value
     * @param string $pHONE1
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setPHONE1($pHONE1 = null)
    {
        // validation for constraint: string
        if (!is_null($pHONE1) && !is_string($pHONE1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pHONE1, true), gettype($pHONE1)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($pHONE1) && mb_strlen($pHONE1) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($pHONE1)), __LINE__);
        }
        $this->PHONE1 = $pHONE1;
        return $this;
    }
    /**
     * Get PHONE2 value
     * @return string|null
     */
    public function getPHONE2()
    {
        return $this->PHONE2;
    }
    /**
     * Set PHONE2 value
     * @param string $pHONE2
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setPHONE2($pHONE2 = null)
    {
        // validation for constraint: string
        if (!is_null($pHONE2) && !is_string($pHONE2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pHONE2, true), gettype($pHONE2)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($pHONE2) && mb_strlen($pHONE2) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($pHONE2)), __LINE__);
        }
        $this->PHONE2 = $pHONE2;
        return $this;
    }
    /**
     * Get RECEIVERHUBUNITID value
     * @return float|null
     */
    public function getRECEIVERHUBUNITID()
    {
        return $this->RECEIVERHUBUNITID;
    }
    /**
     * Set RECEIVERHUBUNITID value
     * @param float $rECEIVERHUBUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setRECEIVERHUBUNITID($rECEIVERHUBUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($rECEIVERHUBUNITID) && !(is_float($rECEIVERHUBUNITID) || is_numeric($rECEIVERHUBUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rECEIVERHUBUNITID, true), gettype($rECEIVERHUBUNITID)), __LINE__);
        }
        $this->RECEIVERHUBUNITID = $rECEIVERHUBUNITID;
        return $this;
    }
    /**
     * Get REPLACEUNITID value
     * @return float|null
     */
    public function getREPLACEUNITID()
    {
        return $this->REPLACEUNITID;
    }
    /**
     * Set REPLACEUNITID value
     * @param float $rEPLACEUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setREPLACEUNITID($rEPLACEUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($rEPLACEUNITID) && !(is_float($rEPLACEUNITID) || is_numeric($rEPLACEUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rEPLACEUNITID, true), gettype($rEPLACEUNITID)), __LINE__);
        }
        $this->REPLACEUNITID = $rEPLACEUNITID;
        return $this;
    }
    /**
     * Get RINGHUBUNITID value
     * @return float|null
     */
    public function getRINGHUBUNITID()
    {
        return $this->RINGHUBUNITID;
    }
    /**
     * Set RINGHUBUNITID value
     * @param float $rINGHUBUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setRINGHUBUNITID($rINGHUBUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($rINGHUBUNITID) && !(is_float($rINGHUBUNITID) || is_numeric($rINGHUBUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rINGHUBUNITID, true), gettype($rINGHUBUNITID)), __LINE__);
        }
        $this->RINGHUBUNITID = $rINGHUBUNITID;
        return $this;
    }
    /**
     * Get ROUTETEMPLATEID value
     * @return string|null
     */
    public function getROUTETEMPLATEID()
    {
        return $this->ROUTETEMPLATEID;
    }
    /**
     * Set ROUTETEMPLATEID value
     * @param string $rOUTETEMPLATEID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setROUTETEMPLATEID($rOUTETEMPLATEID = null)
    {
        // validation for constraint: string
        if (!is_null($rOUTETEMPLATEID) && !is_string($rOUTETEMPLATEID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rOUTETEMPLATEID, true), gettype($rOUTETEMPLATEID)), __LINE__);
        }
        $this->ROUTETEMPLATEID = $rOUTETEMPLATEID;
        return $this;
    }
    /**
     * Get SENDERHUBUNITID value
     * @return float|null
     */
    public function getSENDERHUBUNITID()
    {
        return $this->SENDERHUBUNITID;
    }
    /**
     * Set SENDERHUBUNITID value
     * @param float $sENDERHUBUNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setSENDERHUBUNITID($sENDERHUBUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($sENDERHUBUNITID) && !(is_float($sENDERHUBUNITID) || is_numeric($sENDERHUBUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sENDERHUBUNITID, true), gettype($sENDERHUBUNITID)), __LINE__);
        }
        $this->SENDERHUBUNITID = $sENDERHUBUNITID;
        return $this;
    }
    /**
     * Get SHORT_CODE value
     * @return string|null
     */
    public function getSHORT_CODE()
    {
        return $this->SHORT_CODE;
    }
    /**
     * Set SHORT_CODE value
     * @param string $sHORT_CODE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setSHORT_CODE($sHORT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($sHORT_CODE) && !is_string($sHORT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sHORT_CODE, true), gettype($sHORT_CODE)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($sHORT_CODE) && mb_strlen($sHORT_CODE) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($sHORT_CODE)), __LINE__);
        }
        $this->SHORT_CODE = $sHORT_CODE;
        return $this;
    }
    /**
     * Get START_DATE value
     * @return string|null
     */
    public function getSTART_DATE()
    {
        return $this->START_DATE;
    }
    /**
     * Set START_DATE value
     * @param string $sTART_DATE
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setSTART_DATE($sTART_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($sTART_DATE) && !is_string($sTART_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sTART_DATE, true), gettype($sTART_DATE)), __LINE__);
        }
        $this->START_DATE = $sTART_DATE;
        return $this;
    }
    /**
     * Get UNITID value
     * @return float|null
     */
    public function getUNITID()
    {
        return $this->UNITID;
    }
    /**
     * Set UNITID value
     * @param float $uNITID
     * @return \Ys\ArasKargo\StructType\UNIT1
     */
    public function setUNITID($uNITID = null)
    {
        // validation for constraint: float
        if (!is_null($uNITID) && !(is_float($uNITID) || is_numeric($uNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uNITID, true), gettype($uNITID)), __LINE__);
        }
        $this->UNITID = $uNITID;
        return $this;
    }
}
