<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SERVICE StructType
 * @subpackage Structs
 */
class SERVICE extends AbstractStructBase
{
    /**
     * The HIZMET
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * @var string
     */
    public $HIZMET;
    /**
     * The HIZMETID
     * @var string
     */
    public $HIZMETID;
    /**
     * Constructor method for SERVICE
     * @uses SERVICE::setHIZMET()
     * @uses SERVICE::setHIZMETID()
     * @param string $hIZMET
     * @param string $hIZMETID
     */
    public function __construct($hIZMET = null, $hIZMETID = null)
    {
        $this
            ->setHIZMET($hIZMET)
            ->setHIZMETID($hIZMETID);
    }
    /**
     * Get HIZMET value
     * @return string|null
     */
    public function getHIZMET()
    {
        return $this->HIZMET;
    }
    /**
     * Set HIZMET value
     * @param string $hIZMET
     * @return \Ys\ArasKargo\StructType\SERVICE
     */
    public function setHIZMET($hIZMET = null)
    {
        // validation for constraint: string
        if (!is_null($hIZMET) && !is_string($hIZMET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hIZMET, true), gettype($hIZMET)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($hIZMET) && mb_strlen($hIZMET) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($hIZMET)), __LINE__);
        }
        $this->HIZMET = $hIZMET;
        return $this;
    }
    /**
     * Get HIZMETID value
     * @return string|null
     */
    public function getHIZMETID()
    {
        return $this->HIZMETID;
    }
    /**
     * Set HIZMETID value
     * @param string $hIZMETID
     * @return \Ys\ArasKargo\StructType\SERVICE
     */
    public function setHIZMETID($hIZMETID = null)
    {
        // validation for constraint: string
        if (!is_null($hIZMETID) && !is_string($hIZMETID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hIZMETID, true), gettype($hIZMETID)), __LINE__);
        }
        $this->HIZMETID = $hIZMETID;
        return $this;
    }
}
