<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecallResult StructType
 * @subpackage Structs
 */
class RecallResult extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultCode;
    /**
     * The ResultMessage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultMessage;
    /**
     * Constructor method for RecallResult
     * @uses RecallResult::setResultCode()
     * @uses RecallResult::setResultMessage()
     * @param string $resultCode
     * @param string $resultMessage
     */
    public function __construct($resultCode = null, $resultMessage = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setResultMessage($resultMessage);
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \Ys\ArasKargo\StructType\RecallResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get ResultMessage value
     * @return string|null
     */
    public function getResultMessage()
    {
        return $this->ResultMessage;
    }
    /**
     * Set ResultMessage value
     * @param string $resultMessage
     * @return \Ys\ArasKargo\StructType\RecallResult
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        $this->ResultMessage = $resultMessage;
        return $this;
    }
}
