<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PieceDetail StructType
 * @subpackage Structs
 */
class PieceDetail extends AbstractStructBase
{
    /**
     * The VolumetricWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VolumetricWeight;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Weight;
    /**
     * The BarcodeNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeNumber;
    /**
     * The ProductNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductNumber;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PieceDetail
     * @uses PieceDetail::setVolumetricWeight()
     * @uses PieceDetail::setWeight()
     * @uses PieceDetail::setBarcodeNumber()
     * @uses PieceDetail::setProductNumber()
     * @uses PieceDetail::setDescription()
     * @param string $volumetricWeight
     * @param string $weight
     * @param string $barcodeNumber
     * @param string $productNumber
     * @param string $description
     */
    public function __construct($volumetricWeight = null, $weight = null, $barcodeNumber = null, $productNumber = null, $description = null)
    {
        $this
            ->setVolumetricWeight($volumetricWeight)
            ->setWeight($weight)
            ->setBarcodeNumber($barcodeNumber)
            ->setProductNumber($productNumber)
            ->setDescription($description);
    }
    /**
     * Get VolumetricWeight value
     * @return string|null
     */
    public function getVolumetricWeight()
    {
        return $this->VolumetricWeight;
    }
    /**
     * Set VolumetricWeight value
     * @param string $volumetricWeight
     * @return \Ys\ArasKargo\StructType\PieceDetail
     */
    public function setVolumetricWeight($volumetricWeight = null)
    {
        // validation for constraint: string
        if (!is_null($volumetricWeight) && !is_string($volumetricWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($volumetricWeight, true), gettype($volumetricWeight)), __LINE__);
        }
        $this->VolumetricWeight = $volumetricWeight;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Ys\ArasKargo\StructType\PieceDetail
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get BarcodeNumber value
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->BarcodeNumber;
    }
    /**
     * Set BarcodeNumber value
     * @param string $barcodeNumber
     * @return \Ys\ArasKargo\StructType\PieceDetail
     */
    public function setBarcodeNumber($barcodeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeNumber) && !is_string($barcodeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeNumber, true), gettype($barcodeNumber)), __LINE__);
        }
        $this->BarcodeNumber = $barcodeNumber;
        return $this;
    }
    /**
     * Get ProductNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->ProductNumber;
    }
    /**
     * Set ProductNumber value
     * @param string $productNumber
     * @return \Ys\ArasKargo\StructType\PieceDetail
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->ProductNumber = $productNumber;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ys\ArasKargo\StructType\PieceDetail
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
}
