<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Piece StructType
 * @subpackage Structs
 */
class Piece extends AbstractStructBase
{
    /**
     * The VolumetricWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VolumetricWeight;
    /**
     * The Weight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Weight;
    /**
     * The BarcodeNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BarcodeNumber;
    /**
     * The ProductNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductNumber;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The IntegrationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntegrationCode;
    /**
     * The TotalPieceCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TotalPieceCount;
    /**
     * Constructor method for Piece
     * @uses Piece::setVolumetricWeight()
     * @uses Piece::setWeight()
     * @uses Piece::setBarcodeNumber()
     * @uses Piece::setProductNumber()
     * @uses Piece::setDescription()
     * @uses Piece::setIntegrationCode()
     * @uses Piece::setTotalPieceCount()
     * @param string $volumetricWeight
     * @param string $weight
     * @param string $barcodeNumber
     * @param string $productNumber
     * @param string $description
     * @param string $integrationCode
     * @param string $totalPieceCount
     */
    public function __construct($volumetricWeight = null, $weight = null, $barcodeNumber = null, $productNumber = null, $description = null, $integrationCode = null, $totalPieceCount = null)
    {
        $this
            ->setVolumetricWeight($volumetricWeight)
            ->setWeight($weight)
            ->setBarcodeNumber($barcodeNumber)
            ->setProductNumber($productNumber)
            ->setDescription($description)
            ->setIntegrationCode($integrationCode)
            ->setTotalPieceCount($totalPieceCount);
    }
    /**
     * Get VolumetricWeight value
     * @return string|null
     */
    public function getVolumetricWeight()
    {
        return $this->VolumetricWeight;
    }
    /**
     * Set VolumetricWeight value
     * @param string $volumetricWeight
     * @return \Ys\ArasKargo\StructType\Piece
     */
    public function setVolumetricWeight($volumetricWeight = null)
    {
        // validation for constraint: string
        if (!is_null($volumetricWeight) && !is_string($volumetricWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($volumetricWeight, true), gettype($volumetricWeight)), __LINE__);
        }
        $this->VolumetricWeight = $volumetricWeight;
        return $this;
    }
    /**
     * Get Weight value
     * @return string|null
     */
    public function getWeight()
    {
        return $this->Weight;
    }
    /**
     * Set Weight value
     * @param string $weight
     * @return \Ys\ArasKargo\StructType\Piece
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: string
        if (!is_null($weight) && !is_string($weight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->Weight = $weight;
        return $this;
    }
    /**
     * Get BarcodeNumber value
     * @return string|null
     */
    public function getBarcodeNumber()
    {
        return $this->BarcodeNumber;
    }
    /**
     * Set BarcodeNumber value
     * @param string $barcodeNumber
     * @return \Ys\ArasKargo\StructType\Piece
     */
    public function setBarcodeNumber($barcodeNumber = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeNumber) && !is_string($barcodeNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeNumber, true), gettype($barcodeNumber)), __LINE__);
        }
        $this->BarcodeNumber = $barcodeNumber;
        return $this;
    }
    /**
     * Get ProductNumber value
     * @return string|null
     */
    public function getProductNumber()
    {
        return $this->ProductNumber;
    }
    /**
     * Set ProductNumber value
     * @param string $productNumber
     * @return \Ys\ArasKargo\StructType\Piece
     */
    public function setProductNumber($productNumber = null)
    {
        // validation for constraint: string
        if (!is_null($productNumber) && !is_string($productNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNumber, true), gettype($productNumber)), __LINE__);
        }
        $this->ProductNumber = $productNumber;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Ys\ArasKargo\StructType\Piece
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get IntegrationCode value
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->IntegrationCode;
    }
    /**
     * Set IntegrationCode value
     * @param string $integrationCode
     * @return \Ys\ArasKargo\StructType\Piece
     */
    public function setIntegrationCode($integrationCode = null)
    {
        // validation for constraint: string
        if (!is_null($integrationCode) && !is_string($integrationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrationCode, true), gettype($integrationCode)), __LINE__);
        }
        $this->IntegrationCode = $integrationCode;
        return $this;
    }
    /**
     * Get TotalPieceCount value
     * @return string|null
     */
    public function getTotalPieceCount()
    {
        return $this->TotalPieceCount;
    }
    /**
     * Set TotalPieceCount value
     * @param string $totalPieceCount
     * @return \Ys\ArasKargo\StructType\Piece
     */
    public function setTotalPieceCount($totalPieceCount = null)
    {
        // validation for constraint: string
        if (!is_null($totalPieceCount) && !is_string($totalPieceCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalPieceCount, true), gettype($totalPieceCount)), __LINE__);
        }
        $this->TotalPieceCount = $totalPieceCount;
        return $this;
    }
}
