<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IrsaliyeData StructType
 * Meta information extracted from the WSDL
 * - IsDataSet: true
 * - UseCurrentLocale: true
 * @subpackage Structs
 */
class IrsaliyeData extends AbstractStructBase
{
    /**
     * The IrsData
     * Meta information extracted from the WSDL
     * - choice: IrsData | GunlukDesi | YoldakiAracData | UlasimMatrisi | Plaka | SeferData
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ys\ArasKargo\StructType\IrsData[]
     */
    public $IrsData;
    /**
     * The GunlukDesi
     * Meta information extracted from the WSDL
     * - choice: IrsData | GunlukDesi | YoldakiAracData | UlasimMatrisi | Plaka | SeferData
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ys\ArasKargo\StructType\GunlukDesi[]
     */
    public $GunlukDesi;
    /**
     * The YoldakiAracData
     * Meta information extracted from the WSDL
     * - choice: IrsData | GunlukDesi | YoldakiAracData | UlasimMatrisi | Plaka | SeferData
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ys\ArasKargo\StructType\YoldakiAracData[]
     */
    public $YoldakiAracData;
    /**
     * The UlasimMatrisi
     * Meta information extracted from the WSDL
     * - choice: IrsData | GunlukDesi | YoldakiAracData | UlasimMatrisi | Plaka | SeferData
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ys\ArasKargo\StructType\UlasimMatrisi[]
     */
    public $UlasimMatrisi;
    /**
     * The Plaka
     * Meta information extracted from the WSDL
     * - choice: IrsData | GunlukDesi | YoldakiAracData | UlasimMatrisi | Plaka | SeferData
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ys\ArasKargo\StructType\Plaka[]
     */
    public $Plaka;
    /**
     * The SeferData
     * Meta information extracted from the WSDL
     * - choice: IrsData | GunlukDesi | YoldakiAracData | UlasimMatrisi | Plaka | SeferData
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var \Ys\ArasKargo\StructType\SeferData[]
     */
    public $SeferData;
    /**
     * Constructor method for IrsaliyeData
     * @uses IrsaliyeData::setIrsData()
     * @uses IrsaliyeData::setGunlukDesi()
     * @uses IrsaliyeData::setYoldakiAracData()
     * @uses IrsaliyeData::setUlasimMatrisi()
     * @uses IrsaliyeData::setPlaka()
     * @uses IrsaliyeData::setSeferData()
     * @param \Ys\ArasKargo\StructType\IrsData[] $irsData
     * @param \Ys\ArasKargo\StructType\GunlukDesi[] $gunlukDesi
     * @param \Ys\ArasKargo\StructType\YoldakiAracData[] $yoldakiAracData
     * @param \Ys\ArasKargo\StructType\UlasimMatrisi[] $ulasimMatrisi
     * @param \Ys\ArasKargo\StructType\Plaka[] $plaka
     * @param \Ys\ArasKargo\StructType\SeferData[] $seferData
     */
    public function __construct(array $irsData = array(), array $gunlukDesi = array(), array $yoldakiAracData = array(), array $ulasimMatrisi = array(), array $plaka = array(), array $seferData = array())
    {
        $this
            ->setIrsData($irsData)
            ->setGunlukDesi($gunlukDesi)
            ->setYoldakiAracData($yoldakiAracData)
            ->setUlasimMatrisi($ulasimMatrisi)
            ->setPlaka($plaka)
            ->setSeferData($seferData);
    }
    /**
     * Get IrsData value
     * @return \Ys\ArasKargo\StructType\IrsData[]|null
     */
    public function getIrsData()
    {
        return isset($this->IrsData) ? $this->IrsData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setIrsData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIrsData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIrsDataForArrayConstraintsFromSetIrsData(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $irsaliyeDataIrsDataItem) {
            // validation for constraint: itemType
            if (!$irsaliyeDataIrsDataItem instanceof \Ys\ArasKargo\StructType\IrsData) {
                $invalidValues[] = is_object($irsaliyeDataIrsDataItem) ? get_class($irsaliyeDataIrsDataItem) : sprintf('%s(%s)', gettype($irsaliyeDataIrsDataItem), var_export($irsaliyeDataIrsDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The IrsData property can only contain items of type \Ys\ArasKargo\StructType\IrsData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setIrsData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIrsData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateIrsDataForChoiceConstraintsFromSetIrsData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'GunlukDesi',
            'YoldakiAracData',
            'UlasimMatrisi',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IrsData can\'t be set as the property %s is already set. Only one property must be set among these properties: IrsData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set IrsData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\IrsData[] $irsData
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function setIrsData(array $irsData = array())
    {
        // validation for constraint: array
        if ('' !== ($irsDataArrayErrorMessage = self::validateIrsDataForArrayConstraintsFromSetIrsData($irsData))) {
            throw new \InvalidArgumentException($irsDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($irsDataChoiceErrorMessage = self::validateIrsDataForChoiceConstraintsFromSetIrsData($irsData))) {
            throw new \InvalidArgumentException($irsDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($irsData) || (is_array($irsData) && empty($irsData))) {
            unset($this->IrsData);
        } else {
            $this->IrsData = $irsData;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToIrsData method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToIrsData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToIrsData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'GunlukDesi',
            'YoldakiAracData',
            'UlasimMatrisi',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property IrsData can\'t be set as the property %s is already set. Only one property must be set among these properties: IrsData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to IrsData value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\IrsData $item
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function addToIrsData(\Ys\ArasKargo\StructType\IrsData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\IrsData) {
            throw new \InvalidArgumentException(sprintf('The IrsData property can only contain items of type \Ys\ArasKargo\StructType\IrsData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToIrsData($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->IrsData[] = $item;
        return $this;
    }
    /**
     * Get GunlukDesi value
     * @return \Ys\ArasKargo\StructType\GunlukDesi[]|null
     */
    public function getGunlukDesi()
    {
        return isset($this->GunlukDesi) ? $this->GunlukDesi : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGunlukDesi method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGunlukDesi method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGunlukDesiForArrayConstraintsFromSetGunlukDesi(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $irsaliyeDataGunlukDesiItem) {
            // validation for constraint: itemType
            if (!$irsaliyeDataGunlukDesiItem instanceof \Ys\ArasKargo\StructType\GunlukDesi) {
                $invalidValues[] = is_object($irsaliyeDataGunlukDesiItem) ? get_class($irsaliyeDataGunlukDesiItem) : sprintf('%s(%s)', gettype($irsaliyeDataGunlukDesiItem), var_export($irsaliyeDataGunlukDesiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GunlukDesi property can only contain items of type \Ys\ArasKargo\StructType\GunlukDesi, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGunlukDesi method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGunlukDesi method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGunlukDesiForChoiceConstraintsFromSetGunlukDesi($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'YoldakiAracData',
            'UlasimMatrisi',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GunlukDesi can\'t be set as the property %s is already set. Only one property must be set among these properties: GunlukDesi, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set GunlukDesi value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\GunlukDesi[] $gunlukDesi
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function setGunlukDesi(array $gunlukDesi = array())
    {
        // validation for constraint: array
        if ('' !== ($gunlukDesiArrayErrorMessage = self::validateGunlukDesiForArrayConstraintsFromSetGunlukDesi($gunlukDesi))) {
            throw new \InvalidArgumentException($gunlukDesiArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($gunlukDesiChoiceErrorMessage = self::validateGunlukDesiForChoiceConstraintsFromSetGunlukDesi($gunlukDesi))) {
            throw new \InvalidArgumentException($gunlukDesiChoiceErrorMessage, __LINE__);
        }
        if (is_null($gunlukDesi) || (is_array($gunlukDesi) && empty($gunlukDesi))) {
            unset($this->GunlukDesi);
        } else {
            $this->GunlukDesi = $gunlukDesi;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToGunlukDesi method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToGunlukDesi method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToGunlukDesi($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'YoldakiAracData',
            'UlasimMatrisi',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property GunlukDesi can\'t be set as the property %s is already set. Only one property must be set among these properties: GunlukDesi, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to GunlukDesi value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\GunlukDesi $item
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function addToGunlukDesi(\Ys\ArasKargo\StructType\GunlukDesi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\GunlukDesi) {
            throw new \InvalidArgumentException(sprintf('The GunlukDesi property can only contain items of type \Ys\ArasKargo\StructType\GunlukDesi, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToGunlukDesi($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->GunlukDesi[] = $item;
        return $this;
    }
    /**
     * Get YoldakiAracData value
     * @return \Ys\ArasKargo\StructType\YoldakiAracData[]|null
     */
    public function getYoldakiAracData()
    {
        return isset($this->YoldakiAracData) ? $this->YoldakiAracData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setYoldakiAracData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setYoldakiAracData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateYoldakiAracDataForArrayConstraintsFromSetYoldakiAracData(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $irsaliyeDataYoldakiAracDataItem) {
            // validation for constraint: itemType
            if (!$irsaliyeDataYoldakiAracDataItem instanceof \Ys\ArasKargo\StructType\YoldakiAracData) {
                $invalidValues[] = is_object($irsaliyeDataYoldakiAracDataItem) ? get_class($irsaliyeDataYoldakiAracDataItem) : sprintf('%s(%s)', gettype($irsaliyeDataYoldakiAracDataItem), var_export($irsaliyeDataYoldakiAracDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The YoldakiAracData property can only contain items of type \Ys\ArasKargo\StructType\YoldakiAracData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setYoldakiAracData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setYoldakiAracData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateYoldakiAracDataForChoiceConstraintsFromSetYoldakiAracData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'UlasimMatrisi',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property YoldakiAracData can\'t be set as the property %s is already set. Only one property must be set among these properties: YoldakiAracData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set YoldakiAracData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\YoldakiAracData[] $yoldakiAracData
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function setYoldakiAracData(array $yoldakiAracData = array())
    {
        // validation for constraint: array
        if ('' !== ($yoldakiAracDataArrayErrorMessage = self::validateYoldakiAracDataForArrayConstraintsFromSetYoldakiAracData($yoldakiAracData))) {
            throw new \InvalidArgumentException($yoldakiAracDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($yoldakiAracDataChoiceErrorMessage = self::validateYoldakiAracDataForChoiceConstraintsFromSetYoldakiAracData($yoldakiAracData))) {
            throw new \InvalidArgumentException($yoldakiAracDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($yoldakiAracData) || (is_array($yoldakiAracData) && empty($yoldakiAracData))) {
            unset($this->YoldakiAracData);
        } else {
            $this->YoldakiAracData = $yoldakiAracData;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToYoldakiAracData method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToYoldakiAracData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToYoldakiAracData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'UlasimMatrisi',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property YoldakiAracData can\'t be set as the property %s is already set. Only one property must be set among these properties: YoldakiAracData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to YoldakiAracData value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\YoldakiAracData $item
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function addToYoldakiAracData(\Ys\ArasKargo\StructType\YoldakiAracData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\YoldakiAracData) {
            throw new \InvalidArgumentException(sprintf('The YoldakiAracData property can only contain items of type \Ys\ArasKargo\StructType\YoldakiAracData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToYoldakiAracData($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->YoldakiAracData[] = $item;
        return $this;
    }
    /**
     * Get UlasimMatrisi value
     * @return \Ys\ArasKargo\StructType\UlasimMatrisi[]|null
     */
    public function getUlasimMatrisi()
    {
        return isset($this->UlasimMatrisi) ? $this->UlasimMatrisi : null;
    }
    /**
     * This method is responsible for validating the values passed to the setUlasimMatrisi method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUlasimMatrisi method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUlasimMatrisiForArrayConstraintsFromSetUlasimMatrisi(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $irsaliyeDataUlasimMatrisiItem) {
            // validation for constraint: itemType
            if (!$irsaliyeDataUlasimMatrisiItem instanceof \Ys\ArasKargo\StructType\UlasimMatrisi) {
                $invalidValues[] = is_object($irsaliyeDataUlasimMatrisiItem) ? get_class($irsaliyeDataUlasimMatrisiItem) : sprintf('%s(%s)', gettype($irsaliyeDataUlasimMatrisiItem), var_export($irsaliyeDataUlasimMatrisiItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The UlasimMatrisi property can only contain items of type \Ys\ArasKargo\StructType\UlasimMatrisi, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setUlasimMatrisi method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUlasimMatrisi method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUlasimMatrisiForChoiceConstraintsFromSetUlasimMatrisi($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'YoldakiAracData',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UlasimMatrisi can\'t be set as the property %s is already set. Only one property must be set among these properties: UlasimMatrisi, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UlasimMatrisi value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\UlasimMatrisi[] $ulasimMatrisi
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function setUlasimMatrisi(array $ulasimMatrisi = array())
    {
        // validation for constraint: array
        if ('' !== ($ulasimMatrisiArrayErrorMessage = self::validateUlasimMatrisiForArrayConstraintsFromSetUlasimMatrisi($ulasimMatrisi))) {
            throw new \InvalidArgumentException($ulasimMatrisiArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($ulasimMatrisiChoiceErrorMessage = self::validateUlasimMatrisiForChoiceConstraintsFromSetUlasimMatrisi($ulasimMatrisi))) {
            throw new \InvalidArgumentException($ulasimMatrisiChoiceErrorMessage, __LINE__);
        }
        if (is_null($ulasimMatrisi) || (is_array($ulasimMatrisi) && empty($ulasimMatrisi))) {
            unset($this->UlasimMatrisi);
        } else {
            $this->UlasimMatrisi = $ulasimMatrisi;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToUlasimMatrisi method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToUlasimMatrisi method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToUlasimMatrisi($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'YoldakiAracData',
            'Plaka',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UlasimMatrisi can\'t be set as the property %s is already set. Only one property must be set among these properties: UlasimMatrisi, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to UlasimMatrisi value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\UlasimMatrisi $item
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function addToUlasimMatrisi(\Ys\ArasKargo\StructType\UlasimMatrisi $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\UlasimMatrisi) {
            throw new \InvalidArgumentException(sprintf('The UlasimMatrisi property can only contain items of type \Ys\ArasKargo\StructType\UlasimMatrisi, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToUlasimMatrisi($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->UlasimMatrisi[] = $item;
        return $this;
    }
    /**
     * Get Plaka value
     * @return \Ys\ArasKargo\StructType\Plaka[]|null
     */
    public function getPlaka()
    {
        return isset($this->Plaka) ? $this->Plaka : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPlaka method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlaka method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePlakaForArrayConstraintsFromSetPlaka(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $irsaliyeDataPlakaItem) {
            // validation for constraint: itemType
            if (!$irsaliyeDataPlakaItem instanceof \Ys\ArasKargo\StructType\Plaka) {
                $invalidValues[] = is_object($irsaliyeDataPlakaItem) ? get_class($irsaliyeDataPlakaItem) : sprintf('%s(%s)', gettype($irsaliyeDataPlakaItem), var_export($irsaliyeDataPlakaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Plaka property can only contain items of type \Ys\ArasKargo\StructType\Plaka, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setPlaka method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPlaka method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validatePlakaForChoiceConstraintsFromSetPlaka($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'YoldakiAracData',
            'UlasimMatrisi',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Plaka can\'t be set as the property %s is already set. Only one property must be set among these properties: Plaka, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Plaka value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\Plaka[] $plaka
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function setPlaka(array $plaka = array())
    {
        // validation for constraint: array
        if ('' !== ($plakaArrayErrorMessage = self::validatePlakaForArrayConstraintsFromSetPlaka($plaka))) {
            throw new \InvalidArgumentException($plakaArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($plakaChoiceErrorMessage = self::validatePlakaForChoiceConstraintsFromSetPlaka($plaka))) {
            throw new \InvalidArgumentException($plakaChoiceErrorMessage, __LINE__);
        }
        if (is_null($plaka) || (is_array($plaka) && empty($plaka))) {
            unset($this->Plaka);
        } else {
            $this->Plaka = $plaka;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToPlaka method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToPlaka method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToPlaka($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'YoldakiAracData',
            'UlasimMatrisi',
            'SeferData',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Plaka can\'t be set as the property %s is already set. Only one property must be set among these properties: Plaka, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to Plaka value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\Plaka $item
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function addToPlaka(\Ys\ArasKargo\StructType\Plaka $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\Plaka) {
            throw new \InvalidArgumentException(sprintf('The Plaka property can only contain items of type \Ys\ArasKargo\StructType\Plaka, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToPlaka($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->Plaka[] = $item;
        return $this;
    }
    /**
     * Get SeferData value
     * @return \Ys\ArasKargo\StructType\SeferData[]|null
     */
    public function getSeferData()
    {
        return isset($this->SeferData) ? $this->SeferData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSeferData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeferData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeferDataForArrayConstraintsFromSetSeferData(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $irsaliyeDataSeferDataItem) {
            // validation for constraint: itemType
            if (!$irsaliyeDataSeferDataItem instanceof \Ys\ArasKargo\StructType\SeferData) {
                $invalidValues[] = is_object($irsaliyeDataSeferDataItem) ? get_class($irsaliyeDataSeferDataItem) : sprintf('%s(%s)', gettype($irsaliyeDataSeferDataItem), var_export($irsaliyeDataSeferDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeferData property can only contain items of type \Ys\ArasKargo\StructType\SeferData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setSeferData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeferData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSeferDataForChoiceConstraintsFromSetSeferData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'YoldakiAracData',
            'UlasimMatrisi',
            'Plaka',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeferData can\'t be set as the property %s is already set. Only one property must be set among these properties: SeferData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set SeferData value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\SeferData[] $seferData
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function setSeferData(array $seferData = array())
    {
        // validation for constraint: array
        if ('' !== ($seferDataArrayErrorMessage = self::validateSeferDataForArrayConstraintsFromSetSeferData($seferData))) {
            throw new \InvalidArgumentException($seferDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($seferDataChoiceErrorMessage = self::validateSeferDataForChoiceConstraintsFromSetSeferData($seferData))) {
            throw new \InvalidArgumentException($seferDataChoiceErrorMessage, __LINE__);
        }
        if (is_null($seferData) || (is_array($seferData) && empty($seferData))) {
            unset($this->SeferData);
        } else {
            $this->SeferData = $seferData;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToSeferData method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToSeferData method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToSeferData($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = array(
            'IrsData',
            'GunlukDesi',
            'YoldakiAracData',
            'UlasimMatrisi',
            'Plaka',
        );
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property SeferData can\'t be set as the property %s is already set. Only one property must be set among these properties: SeferData, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to SeferData value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\SeferData $item
     * @return \Ys\ArasKargo\StructType\IrsaliyeData
     */
    public function addToSeferData(\Ys\ArasKargo\StructType\SeferData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\SeferData) {
            throw new \InvalidArgumentException(sprintf('The SeferData property can only contain items of type \Ys\ArasKargo\StructType\SeferData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(IrsData, GunlukDesi, YoldakiAracData, UlasimMatrisi, Plaka, SeferData)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToSeferData($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->SeferData[] = $item;
        return $this;
    }
}
