<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IrsData StructType
 * @subpackage Structs
 */
class IrsData extends AbstractStructBase
{
    /**
     * The ADET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ADET;
    /**
     * The ALICI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $ALICI;
    /**
     * The CIKIS_SUBE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $CIKIS_SUBE;
    /**
     * The DESI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DESI;
    /**
     * The GONDERICI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $GONDERICI;
    /**
     * The IRSALIYE_SERI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $IRSALIYE_SERI;
    /**
     * The IRSALIYE_NUMARA
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $IRSALIYE_NUMARA;
    /**
     * The IRSALIYE_TARIH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IRSALIYE_TARIH;
    /**
     * The MUSTERI_OZEL_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $MUSTERI_OZEL_KODU;
    /**
     * The ODEME_TIPI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $ODEME_TIPI;
    /**
     * The REFERANS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $REFERANS;
    /**
     * The TESLIM_ALAN
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_ALAN;
    /**
     * The TESLIM_SAATI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_SAATI;
    /**
     * The TESLIM_TARIHI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $TESLIM_TARIHI;
    /**
     * The TUTAR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TUTAR;
    /**
     * The VARIS_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * @var string
     */
    public $VARIS_KODU;
    /**
     * The VARIS_SUBE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * @var string
     */
    public $VARIS_SUBE;
    /**
     * The TIP_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $TIP_KODU;
    /**
     * The DURUM_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $DURUM_KODU;
    /**
     * The DURUMU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 259
     * - minOccurs: 0
     * @var string
     */
    public $DURUMU;
    /**
     * The IADE_SEBEBI
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 128
     * - minOccurs: 0
     * @var string
     */
    public $IADE_SEBEBI;
    /**
     * The KARGO_TAKIP_NO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KARGO_TAKIP_NO;
    /**
     * Constructor method for IrsData
     * @uses IrsData::setADET()
     * @uses IrsData::setALICI()
     * @uses IrsData::setCIKIS_SUBE()
     * @uses IrsData::setDESI()
     * @uses IrsData::setGONDERICI()
     * @uses IrsData::setIRSALIYE_SERI()
     * @uses IrsData::setIRSALIYE_NUMARA()
     * @uses IrsData::setIRSALIYE_TARIH()
     * @uses IrsData::setMUSTERI_OZEL_KODU()
     * @uses IrsData::setODEME_TIPI()
     * @uses IrsData::setREFERANS()
     * @uses IrsData::setTESLIM_ALAN()
     * @uses IrsData::setTESLIM_SAATI()
     * @uses IrsData::setTESLIM_TARIHI()
     * @uses IrsData::setTUTAR()
     * @uses IrsData::setVARIS_KODU()
     * @uses IrsData::setVARIS_SUBE()
     * @uses IrsData::setTIP_KODU()
     * @uses IrsData::setDURUM_KODU()
     * @uses IrsData::setDURUMU()
     * @uses IrsData::setIADE_SEBEBI()
     * @uses IrsData::setKARGO_TAKIP_NO()
     * @param float $aDET
     * @param string $aLICI
     * @param string $cIKIS_SUBE
     * @param float $dESI
     * @param string $gONDERICI
     * @param string $iRSALIYE_SERI
     * @param string $iRSALIYE_NUMARA
     * @param string $iRSALIYE_TARIH
     * @param string $mUSTERI_OZEL_KODU
     * @param string $oDEME_TIPI
     * @param string $rEFERANS
     * @param string $tESLIM_ALAN
     * @param string $tESLIM_SAATI
     * @param string $tESLIM_TARIHI
     * @param float $tUTAR
     * @param string $vARIS_KODU
     * @param string $vARIS_SUBE
     * @param string $tIP_KODU
     * @param string $dURUM_KODU
     * @param string $dURUMU
     * @param string $iADE_SEBEBI
     * @param float $kARGO_TAKIP_NO
     */
    public function __construct($aDET = null, $aLICI = null, $cIKIS_SUBE = null, $dESI = null, $gONDERICI = null, $iRSALIYE_SERI = null, $iRSALIYE_NUMARA = null, $iRSALIYE_TARIH = null, $mUSTERI_OZEL_KODU = null, $oDEME_TIPI = null, $rEFERANS = null, $tESLIM_ALAN = null, $tESLIM_SAATI = null, $tESLIM_TARIHI = null, $tUTAR = null, $vARIS_KODU = null, $vARIS_SUBE = null, $tIP_KODU = null, $dURUM_KODU = null, $dURUMU = null, $iADE_SEBEBI = null, $kARGO_TAKIP_NO = null)
    {
        $this
            ->setADET($aDET)
            ->setALICI($aLICI)
            ->setCIKIS_SUBE($cIKIS_SUBE)
            ->setDESI($dESI)
            ->setGONDERICI($gONDERICI)
            ->setIRSALIYE_SERI($iRSALIYE_SERI)
            ->setIRSALIYE_NUMARA($iRSALIYE_NUMARA)
            ->setIRSALIYE_TARIH($iRSALIYE_TARIH)
            ->setMUSTERI_OZEL_KODU($mUSTERI_OZEL_KODU)
            ->setODEME_TIPI($oDEME_TIPI)
            ->setREFERANS($rEFERANS)
            ->setTESLIM_ALAN($tESLIM_ALAN)
            ->setTESLIM_SAATI($tESLIM_SAATI)
            ->setTESLIM_TARIHI($tESLIM_TARIHI)
            ->setTUTAR($tUTAR)
            ->setVARIS_KODU($vARIS_KODU)
            ->setVARIS_SUBE($vARIS_SUBE)
            ->setTIP_KODU($tIP_KODU)
            ->setDURUM_KODU($dURUM_KODU)
            ->setDURUMU($dURUMU)
            ->setIADE_SEBEBI($iADE_SEBEBI)
            ->setKARGO_TAKIP_NO($kARGO_TAKIP_NO);
    }
    /**
     * Get ADET value
     * @return float|null
     */
    public function getADET()
    {
        return $this->ADET;
    }
    /**
     * Set ADET value
     * @param float $aDET
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setADET($aDET = null)
    {
        // validation for constraint: float
        if (!is_null($aDET) && !(is_float($aDET) || is_numeric($aDET))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aDET, true), gettype($aDET)), __LINE__);
        }
        $this->ADET = $aDET;
        return $this;
    }
    /**
     * Get ALICI value
     * @return string|null
     */
    public function getALICI()
    {
        return $this->ALICI;
    }
    /**
     * Set ALICI value
     * @param string $aLICI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setALICI($aLICI = null)
    {
        // validation for constraint: string
        if (!is_null($aLICI) && !is_string($aLICI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aLICI, true), gettype($aLICI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($aLICI) && mb_strlen($aLICI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($aLICI)), __LINE__);
        }
        $this->ALICI = $aLICI;
        return $this;
    }
    /**
     * Get CIKIS_SUBE value
     * @return string|null
     */
    public function getCIKIS_SUBE()
    {
        return $this->CIKIS_SUBE;
    }
    /**
     * Set CIKIS_SUBE value
     * @param string $cIKIS_SUBE
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setCIKIS_SUBE($cIKIS_SUBE = null)
    {
        // validation for constraint: string
        if (!is_null($cIKIS_SUBE) && !is_string($cIKIS_SUBE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cIKIS_SUBE, true), gettype($cIKIS_SUBE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($cIKIS_SUBE) && mb_strlen($cIKIS_SUBE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($cIKIS_SUBE)), __LINE__);
        }
        $this->CIKIS_SUBE = $cIKIS_SUBE;
        return $this;
    }
    /**
     * Get DESI value
     * @return float|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }
    /**
     * Set DESI value
     * @param float $dESI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setDESI($dESI = null)
    {
        // validation for constraint: float
        if (!is_null($dESI) && !(is_float($dESI) || is_numeric($dESI))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dESI, true), gettype($dESI)), __LINE__);
        }
        $this->DESI = $dESI;
        return $this;
    }
    /**
     * Get GONDERICI value
     * @return string|null
     */
    public function getGONDERICI()
    {
        return $this->GONDERICI;
    }
    /**
     * Set GONDERICI value
     * @param string $gONDERICI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setGONDERICI($gONDERICI = null)
    {
        // validation for constraint: string
        if (!is_null($gONDERICI) && !is_string($gONDERICI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gONDERICI, true), gettype($gONDERICI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($gONDERICI) && mb_strlen($gONDERICI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($gONDERICI)), __LINE__);
        }
        $this->GONDERICI = $gONDERICI;
        return $this;
    }
    /**
     * Get IRSALIYE_SERI value
     * @return string|null
     */
    public function getIRSALIYE_SERI()
    {
        return $this->IRSALIYE_SERI;
    }
    /**
     * Set IRSALIYE_SERI value
     * @param string $iRSALIYE_SERI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setIRSALIYE_SERI($iRSALIYE_SERI = null)
    {
        // validation for constraint: string
        if (!is_null($iRSALIYE_SERI) && !is_string($iRSALIYE_SERI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSALIYE_SERI, true), gettype($iRSALIYE_SERI)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($iRSALIYE_SERI) && mb_strlen($iRSALIYE_SERI) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($iRSALIYE_SERI)), __LINE__);
        }
        $this->IRSALIYE_SERI = $iRSALIYE_SERI;
        return $this;
    }
    /**
     * Get IRSALIYE_NUMARA value
     * @return string|null
     */
    public function getIRSALIYE_NUMARA()
    {
        return $this->IRSALIYE_NUMARA;
    }
    /**
     * Set IRSALIYE_NUMARA value
     * @param string $iRSALIYE_NUMARA
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setIRSALIYE_NUMARA($iRSALIYE_NUMARA = null)
    {
        // validation for constraint: string
        if (!is_null($iRSALIYE_NUMARA) && !is_string($iRSALIYE_NUMARA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSALIYE_NUMARA, true), gettype($iRSALIYE_NUMARA)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($iRSALIYE_NUMARA) && mb_strlen($iRSALIYE_NUMARA) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($iRSALIYE_NUMARA)), __LINE__);
        }
        $this->IRSALIYE_NUMARA = $iRSALIYE_NUMARA;
        return $this;
    }
    /**
     * Get IRSALIYE_TARIH value
     * @return string|null
     */
    public function getIRSALIYE_TARIH()
    {
        return $this->IRSALIYE_TARIH;
    }
    /**
     * Set IRSALIYE_TARIH value
     * @param string $iRSALIYE_TARIH
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setIRSALIYE_TARIH($iRSALIYE_TARIH = null)
    {
        // validation for constraint: string
        if (!is_null($iRSALIYE_TARIH) && !is_string($iRSALIYE_TARIH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iRSALIYE_TARIH, true), gettype($iRSALIYE_TARIH)), __LINE__);
        }
        $this->IRSALIYE_TARIH = $iRSALIYE_TARIH;
        return $this;
    }
    /**
     * Get MUSTERI_OZEL_KODU value
     * @return string|null
     */
    public function getMUSTERI_OZEL_KODU()
    {
        return $this->MUSTERI_OZEL_KODU;
    }
    /**
     * Set MUSTERI_OZEL_KODU value
     * @param string $mUSTERI_OZEL_KODU
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setMUSTERI_OZEL_KODU($mUSTERI_OZEL_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($mUSTERI_OZEL_KODU) && !is_string($mUSTERI_OZEL_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mUSTERI_OZEL_KODU, true), gettype($mUSTERI_OZEL_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($mUSTERI_OZEL_KODU) && mb_strlen($mUSTERI_OZEL_KODU) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($mUSTERI_OZEL_KODU)), __LINE__);
        }
        $this->MUSTERI_OZEL_KODU = $mUSTERI_OZEL_KODU;
        return $this;
    }
    /**
     * Get ODEME_TIPI value
     * @return string|null
     */
    public function getODEME_TIPI()
    {
        return $this->ODEME_TIPI;
    }
    /**
     * Set ODEME_TIPI value
     * @param string $oDEME_TIPI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setODEME_TIPI($oDEME_TIPI = null)
    {
        // validation for constraint: string
        if (!is_null($oDEME_TIPI) && !is_string($oDEME_TIPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oDEME_TIPI, true), gettype($oDEME_TIPI)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($oDEME_TIPI) && mb_strlen($oDEME_TIPI) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($oDEME_TIPI)), __LINE__);
        }
        $this->ODEME_TIPI = $oDEME_TIPI;
        return $this;
    }
    /**
     * Get REFERANS value
     * @return string|null
     */
    public function getREFERANS()
    {
        return $this->REFERANS;
    }
    /**
     * Set REFERANS value
     * @param string $rEFERANS
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setREFERANS($rEFERANS = null)
    {
        // validation for constraint: string
        if (!is_null($rEFERANS) && !is_string($rEFERANS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rEFERANS, true), gettype($rEFERANS)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($rEFERANS) && mb_strlen($rEFERANS) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($rEFERANS)), __LINE__);
        }
        $this->REFERANS = $rEFERANS;
        return $this;
    }
    /**
     * Get TESLIM_ALAN value
     * @return string|null
     */
    public function getTESLIM_ALAN()
    {
        return $this->TESLIM_ALAN;
    }
    /**
     * Set TESLIM_ALAN value
     * @param string $tESLIM_ALAN
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setTESLIM_ALAN($tESLIM_ALAN = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_ALAN) && !is_string($tESLIM_ALAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_ALAN, true), gettype($tESLIM_ALAN)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($tESLIM_ALAN) && mb_strlen($tESLIM_ALAN) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($tESLIM_ALAN)), __LINE__);
        }
        $this->TESLIM_ALAN = $tESLIM_ALAN;
        return $this;
    }
    /**
     * Get TESLIM_SAATI value
     * @return string|null
     */
    public function getTESLIM_SAATI()
    {
        return $this->TESLIM_SAATI;
    }
    /**
     * Set TESLIM_SAATI value
     * @param string $tESLIM_SAATI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setTESLIM_SAATI($tESLIM_SAATI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_SAATI) && !is_string($tESLIM_SAATI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_SAATI, true), gettype($tESLIM_SAATI)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($tESLIM_SAATI) && mb_strlen($tESLIM_SAATI) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($tESLIM_SAATI)), __LINE__);
        }
        $this->TESLIM_SAATI = $tESLIM_SAATI;
        return $this;
    }
    /**
     * Get TESLIM_TARIHI value
     * @return string|null
     */
    public function getTESLIM_TARIHI()
    {
        return $this->TESLIM_TARIHI;
    }
    /**
     * Set TESLIM_TARIHI value
     * @param string $tESLIM_TARIHI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setTESLIM_TARIHI($tESLIM_TARIHI = null)
    {
        // validation for constraint: string
        if (!is_null($tESLIM_TARIHI) && !is_string($tESLIM_TARIHI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tESLIM_TARIHI, true), gettype($tESLIM_TARIHI)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tESLIM_TARIHI) && mb_strlen($tESLIM_TARIHI) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tESLIM_TARIHI)), __LINE__);
        }
        $this->TESLIM_TARIHI = $tESLIM_TARIHI;
        return $this;
    }
    /**
     * Get TUTAR value
     * @return float|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }
    /**
     * Set TUTAR value
     * @param float $tUTAR
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setTUTAR($tUTAR = null)
    {
        // validation for constraint: float
        if (!is_null($tUTAR) && !(is_float($tUTAR) || is_numeric($tUTAR))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tUTAR, true), gettype($tUTAR)), __LINE__);
        }
        $this->TUTAR = $tUTAR;
        return $this;
    }
    /**
     * Get VARIS_KODU value
     * @return string|null
     */
    public function getVARIS_KODU()
    {
        return $this->VARIS_KODU;
    }
    /**
     * Set VARIS_KODU value
     * @param string $vARIS_KODU
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setVARIS_KODU($vARIS_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_KODU) && !is_string($vARIS_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_KODU, true), gettype($vARIS_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($vARIS_KODU) && mb_strlen($vARIS_KODU) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($vARIS_KODU)), __LINE__);
        }
        $this->VARIS_KODU = $vARIS_KODU;
        return $this;
    }
    /**
     * Get VARIS_SUBE value
     * @return string|null
     */
    public function getVARIS_SUBE()
    {
        return $this->VARIS_SUBE;
    }
    /**
     * Set VARIS_SUBE value
     * @param string $vARIS_SUBE
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setVARIS_SUBE($vARIS_SUBE = null)
    {
        // validation for constraint: string
        if (!is_null($vARIS_SUBE) && !is_string($vARIS_SUBE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vARIS_SUBE, true), gettype($vARIS_SUBE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($vARIS_SUBE) && mb_strlen($vARIS_SUBE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($vARIS_SUBE)), __LINE__);
        }
        $this->VARIS_SUBE = $vARIS_SUBE;
        return $this;
    }
    /**
     * Get TIP_KODU value
     * @return string|null
     */
    public function getTIP_KODU()
    {
        return $this->TIP_KODU;
    }
    /**
     * Set TIP_KODU value
     * @param string $tIP_KODU
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setTIP_KODU($tIP_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($tIP_KODU) && !is_string($tIP_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tIP_KODU, true), gettype($tIP_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($tIP_KODU) && mb_strlen($tIP_KODU) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($tIP_KODU)), __LINE__);
        }
        $this->TIP_KODU = $tIP_KODU;
        return $this;
    }
    /**
     * Get DURUM_KODU value
     * @return string|null
     */
    public function getDURUM_KODU()
    {
        return $this->DURUM_KODU;
    }
    /**
     * Set DURUM_KODU value
     * @param string $dURUM_KODU
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setDURUM_KODU($dURUM_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($dURUM_KODU) && !is_string($dURUM_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dURUM_KODU, true), gettype($dURUM_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($dURUM_KODU) && mb_strlen($dURUM_KODU) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($dURUM_KODU)), __LINE__);
        }
        $this->DURUM_KODU = $dURUM_KODU;
        return $this;
    }
    /**
     * Get DURUMU value
     * @return string|null
     */
    public function getDURUMU()
    {
        return $this->DURUMU;
    }
    /**
     * Set DURUMU value
     * @param string $dURUMU
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setDURUMU($dURUMU = null)
    {
        // validation for constraint: string
        if (!is_null($dURUMU) && !is_string($dURUMU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dURUMU, true), gettype($dURUMU)), __LINE__);
        }
        // validation for constraint: maxLength(259)
        if (!is_null($dURUMU) && mb_strlen($dURUMU) > 259) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 259', mb_strlen($dURUMU)), __LINE__);
        }
        $this->DURUMU = $dURUMU;
        return $this;
    }
    /**
     * Get IADE_SEBEBI value
     * @return string|null
     */
    public function getIADE_SEBEBI()
    {
        return $this->IADE_SEBEBI;
    }
    /**
     * Set IADE_SEBEBI value
     * @param string $iADE_SEBEBI
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setIADE_SEBEBI($iADE_SEBEBI = null)
    {
        // validation for constraint: string
        if (!is_null($iADE_SEBEBI) && !is_string($iADE_SEBEBI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iADE_SEBEBI, true), gettype($iADE_SEBEBI)), __LINE__);
        }
        // validation for constraint: maxLength(128)
        if (!is_null($iADE_SEBEBI) && mb_strlen($iADE_SEBEBI) > 128) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 128', mb_strlen($iADE_SEBEBI)), __LINE__);
        }
        $this->IADE_SEBEBI = $iADE_SEBEBI;
        return $this;
    }
    /**
     * Get KARGO_TAKIP_NO value
     * @return float|null
     */
    public function getKARGO_TAKIP_NO()
    {
        return $this->KARGO_TAKIP_NO;
    }
    /**
     * Set KARGO_TAKIP_NO value
     * @param float $kARGO_TAKIP_NO
     * @return \Ys\ArasKargo\StructType\IrsData
     */
    public function setKARGO_TAKIP_NO($kARGO_TAKIP_NO = null)
    {
        // validation for constraint: float
        if (!is_null($kARGO_TAKIP_NO) && !(is_float($kARGO_TAKIP_NO) || is_numeric($kARGO_TAKIP_NO))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kARGO_TAKIP_NO, true), gettype($kARGO_TAKIP_NO)), __LINE__);
        }
        $this->KARGO_TAKIP_NO = $kARGO_TAKIP_NO;
        return $this;
    }
}
