<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HINTCITY StructType
 * @subpackage Structs
 */
class HINTCITY extends AbstractStructBase
{
    /**
     * The IL
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * @var string
     */
    public $IL;
    /**
     * The IL_KODU
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 8
     * - minOccurs: 0
     * @var string
     */
    public $IL_KODU;
    /**
     * The HINTCITYID
     * @var string
     */
    public $HINTCITYID;
    /**
     * Constructor method for HINTCITY
     * @uses HINTCITY::setIL()
     * @uses HINTCITY::setIL_KODU()
     * @uses HINTCITY::setHINTCITYID()
     * @param string $iL
     * @param string $iL_KODU
     * @param string $hINTCITYID
     */
    public function __construct($iL = null, $iL_KODU = null, $hINTCITYID = null)
    {
        $this
            ->setIL($iL)
            ->setIL_KODU($iL_KODU)
            ->setHINTCITYID($hINTCITYID);
    }
    /**
     * Get IL value
     * @return string|null
     */
    public function getIL()
    {
        return $this->IL;
    }
    /**
     * Set IL value
     * @param string $iL
     * @return \Ys\ArasKargo\StructType\HINTCITY
     */
    public function setIL($iL = null)
    {
        // validation for constraint: string
        if (!is_null($iL) && !is_string($iL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iL, true), gettype($iL)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($iL) && mb_strlen($iL) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($iL)), __LINE__);
        }
        $this->IL = $iL;
        return $this;
    }
    /**
     * Get IL_KODU value
     * @return string|null
     */
    public function getIL_KODU()
    {
        return $this->IL_KODU;
    }
    /**
     * Set IL_KODU value
     * @param string $iL_KODU
     * @return \Ys\ArasKargo\StructType\HINTCITY
     */
    public function setIL_KODU($iL_KODU = null)
    {
        // validation for constraint: string
        if (!is_null($iL_KODU) && !is_string($iL_KODU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iL_KODU, true), gettype($iL_KODU)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($iL_KODU) && mb_strlen($iL_KODU) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($iL_KODU)), __LINE__);
        }
        $this->IL_KODU = $iL_KODU;
        return $this;
    }
    /**
     * Get HINTCITYID value
     * @return string|null
     */
    public function getHINTCITYID()
    {
        return $this->HINTCITYID;
    }
    /**
     * Set HINTCITYID value
     * @param string $hINTCITYID
     * @return \Ys\ArasKargo\StructType\HINTCITY
     */
    public function setHINTCITYID($hINTCITYID = null)
    {
        // validation for constraint: string
        if (!is_null($hINTCITYID) && !is_string($hINTCITYID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hINTCITYID, true), gettype($hINTCITYID)), __LINE__);
        }
        $this->HINTCITYID = $hINTCITYID;
        return $this;
    }
}
