<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BarcodeResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BarcodeResult
 * @subpackage Structs
 */
class BarcodeResult extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ResultCode;
    /**
     * The Images
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\ArasKargo\ArrayType\ArrayOfBase64Binary
     */
    public $Images;
    /**
     * The ZebraZpl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\ArasKargo\ArrayType\ArrayOfString
     */
    public $ZebraZpl;
    /**
     * The ZebraEpl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\ArasKargo\ArrayType\ArrayOfString
     */
    public $ZebraEpl;
    /**
     * The BarcodeModelLst
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Ys\ArasKargo\ArrayType\ArrayOfBarcodeModel
     */
    public $BarcodeModelLst;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * Constructor method for BarcodeResult
     * @uses BarcodeResult::setResultCode()
     * @uses BarcodeResult::setImages()
     * @uses BarcodeResult::setZebraZpl()
     * @uses BarcodeResult::setZebraEpl()
     * @uses BarcodeResult::setBarcodeModelLst()
     * @uses BarcodeResult::setMessage()
     * @param int $resultCode
     * @param \Ys\ArasKargo\ArrayType\ArrayOfBase64Binary $images
     * @param \Ys\ArasKargo\ArrayType\ArrayOfString $zebraZpl
     * @param \Ys\ArasKargo\ArrayType\ArrayOfString $zebraEpl
     * @param \Ys\ArasKargo\ArrayType\ArrayOfBarcodeModel $barcodeModelLst
     * @param string $message
     */
    public function __construct($resultCode = null, \Ys\ArasKargo\ArrayType\ArrayOfBase64Binary $images = null, \Ys\ArasKargo\ArrayType\ArrayOfString $zebraZpl = null, \Ys\ArasKargo\ArrayType\ArrayOfString $zebraEpl = null, \Ys\ArasKargo\ArrayType\ArrayOfBarcodeModel $barcodeModelLst = null, $message = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setImages($images)
            ->setZebraZpl($zebraZpl)
            ->setZebraEpl($zebraEpl)
            ->setBarcodeModelLst($barcodeModelLst)
            ->setMessage($message);
    }
    /**
     * Get ResultCode value
     * @return int
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param int $resultCode
     * @return \Ys\ArasKargo\StructType\BarcodeResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: int
        if (!is_null($resultCode) && !(is_int($resultCode) || ctype_digit($resultCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Images value
     * @return \Ys\ArasKargo\ArrayType\ArrayOfBase64Binary|null
     */
    public function getImages()
    {
        return $this->Images;
    }
    /**
     * Set Images value
     * @param \Ys\ArasKargo\ArrayType\ArrayOfBase64Binary $images
     * @return \Ys\ArasKargo\StructType\BarcodeResult
     */
    public function setImages(\Ys\ArasKargo\ArrayType\ArrayOfBase64Binary $images = null)
    {
        $this->Images = $images;
        return $this;
    }
    /**
     * Get ZebraZpl value
     * @return \Ys\ArasKargo\ArrayType\ArrayOfString|null
     */
    public function getZebraZpl()
    {
        return $this->ZebraZpl;
    }
    /**
     * Set ZebraZpl value
     * @param \Ys\ArasKargo\ArrayType\ArrayOfString $zebraZpl
     * @return \Ys\ArasKargo\StructType\BarcodeResult
     */
    public function setZebraZpl(\Ys\ArasKargo\ArrayType\ArrayOfString $zebraZpl = null)
    {
        $this->ZebraZpl = $zebraZpl;
        return $this;
    }
    /**
     * Get ZebraEpl value
     * @return \Ys\ArasKargo\ArrayType\ArrayOfString|null
     */
    public function getZebraEpl()
    {
        return $this->ZebraEpl;
    }
    /**
     * Set ZebraEpl value
     * @param \Ys\ArasKargo\ArrayType\ArrayOfString $zebraEpl
     * @return \Ys\ArasKargo\StructType\BarcodeResult
     */
    public function setZebraEpl(\Ys\ArasKargo\ArrayType\ArrayOfString $zebraEpl = null)
    {
        $this->ZebraEpl = $zebraEpl;
        return $this;
    }
    /**
     * Get BarcodeModelLst value
     * @return \Ys\ArasKargo\ArrayType\ArrayOfBarcodeModel|null
     */
    public function getBarcodeModelLst()
    {
        return $this->BarcodeModelLst;
    }
    /**
     * Set BarcodeModelLst value
     * @param \Ys\ArasKargo\ArrayType\ArrayOfBarcodeModel $barcodeModelLst
     * @return \Ys\ArasKargo\StructType\BarcodeResult
     */
    public function setBarcodeModelLst(\Ys\ArasKargo\ArrayType\ArrayOfBarcodeModel $barcodeModelLst = null)
    {
        $this->BarcodeModelLst = $barcodeModelLst;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Ys\ArasKargo\StructType\BarcodeResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
