<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BATCHWAYBILLTRANSACTION StructType
 * @subpackage Structs
 */
class BATCHWAYBILLTRANSACTION extends AbstractStructBase
{
    /**
     * The BARCODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 64
     * - minOccurs: 0
     * @var string
     */
    public $BARCODE;
    /**
     * The TRANSACTION_DATE
     * @var string
     */
    public $TRANSACTION_DATE;
    /**
     * The LOVSHIPMENTLINETRANSTYPEID
     * @var float
     */
    public $LOVSHIPMENTLINETRANSTYPEID;
    /**
     * The BATCHWAYBILLTRANSACTIONID
     * @var string
     */
    public $BATCHWAYBILLTRANSACTIONID;
    /**
     * The AUDIT_CREATE_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_CREATE_DATE;
    /**
     * The AUDITCREATEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEDBY;
    /**
     * The AUDITCREATEUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITCREATEUNITID;
    /**
     * The AUDIT_MODIFY_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_MODIFY_DATE;
    /**
     * The AUDITMODIFIEDBY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFIEDBY;
    /**
     * The AUDITMODIFYUNITID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $AUDITMODIFYUNITID;
    /**
     * The AUDIT_DELETED
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $AUDIT_DELETED;
    /**
     * The APPLICATION_VERSION
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $APPLICATION_VERSION;
    /**
     * The APPLICATIONID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $APPLICATIONID;
    /**
     * The LOVORGANIZATIONID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $LOVORGANIZATIONID;
    /**
     * The BARCODETYPE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $BARCODETYPE;
    /**
     * The TTIBAGBARGODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $TTIBAGBARGODE;
    /**
     * The RECORD_TYPE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $RECORD_TYPE;
    /**
     * The PROCESS_STATUS
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PROCESS_STATUS;
    /**
     * The DATE2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DATE2;
    /**
     * The PLATE_NUMBER
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 16
     * - minOccurs: 0
     * @var string
     */
    public $PLATE_NUMBER;
    /**
     * The NEXT_STOP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $NEXT_STOP;
    /**
     * The SHIPMENT_CODE
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 32
     * - minOccurs: 0
     * @var string
     */
    public $SHIPMENT_CODE;
    /**
     * The PIECE_NUMBER
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PIECE_NUMBER;
    /**
     * The PIECE_COUNT
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PIECE_COUNT;
    /**
     * The TRANSFER_STATUS
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TRANSFER_STATUS;
    /**
     * The TRANSFER_DATE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TRANSFER_DATE;
    /**
     * Constructor method for BATCHWAYBILLTRANSACTION
     * @uses BATCHWAYBILLTRANSACTION::setBARCODE()
     * @uses BATCHWAYBILLTRANSACTION::setTRANSACTION_DATE()
     * @uses BATCHWAYBILLTRANSACTION::setLOVSHIPMENTLINETRANSTYPEID()
     * @uses BATCHWAYBILLTRANSACTION::setBATCHWAYBILLTRANSACTIONID()
     * @uses BATCHWAYBILLTRANSACTION::setAUDIT_CREATE_DATE()
     * @uses BATCHWAYBILLTRANSACTION::setAUDITCREATEDBY()
     * @uses BATCHWAYBILLTRANSACTION::setAUDITCREATEUNITID()
     * @uses BATCHWAYBILLTRANSACTION::setAUDIT_MODIFY_DATE()
     * @uses BATCHWAYBILLTRANSACTION::setAUDITMODIFIEDBY()
     * @uses BATCHWAYBILLTRANSACTION::setAUDITMODIFYUNITID()
     * @uses BATCHWAYBILLTRANSACTION::setAUDIT_DELETED()
     * @uses BATCHWAYBILLTRANSACTION::setAPPLICATION_VERSION()
     * @uses BATCHWAYBILLTRANSACTION::setAPPLICATIONID()
     * @uses BATCHWAYBILLTRANSACTION::setLOVORGANIZATIONID()
     * @uses BATCHWAYBILLTRANSACTION::setBARCODETYPE()
     * @uses BATCHWAYBILLTRANSACTION::setTTIBAGBARGODE()
     * @uses BATCHWAYBILLTRANSACTION::setRECORD_TYPE()
     * @uses BATCHWAYBILLTRANSACTION::setPROCESS_STATUS()
     * @uses BATCHWAYBILLTRANSACTION::setDATE2()
     * @uses BATCHWAYBILLTRANSACTION::setPLATE_NUMBER()
     * @uses BATCHWAYBILLTRANSACTION::setNEXT_STOP()
     * @uses BATCHWAYBILLTRANSACTION::setSHIPMENT_CODE()
     * @uses BATCHWAYBILLTRANSACTION::setPIECE_NUMBER()
     * @uses BATCHWAYBILLTRANSACTION::setPIECE_COUNT()
     * @uses BATCHWAYBILLTRANSACTION::setTRANSFER_STATUS()
     * @uses BATCHWAYBILLTRANSACTION::setTRANSFER_DATE()
     * @param string $bARCODE
     * @param string $tRANSACTION_DATE
     * @param float $lOVSHIPMENTLINETRANSTYPEID
     * @param string $bATCHWAYBILLTRANSACTIONID
     * @param string $aUDIT_CREATE_DATE
     * @param float $aUDITCREATEDBY
     * @param float $aUDITCREATEUNITID
     * @param string $aUDIT_MODIFY_DATE
     * @param float $aUDITMODIFIEDBY
     * @param float $aUDITMODIFYUNITID
     * @param string $aUDIT_DELETED
     * @param string $aPPLICATION_VERSION
     * @param float $aPPLICATIONID
     * @param float $lOVORGANIZATIONID
     * @param string $bARCODETYPE
     * @param string $tTIBAGBARGODE
     * @param string $rECORD_TYPE
     * @param float $pROCESS_STATUS
     * @param string $dATE2
     * @param string $pLATE_NUMBER
     * @param float $nEXT_STOP
     * @param string $sHIPMENT_CODE
     * @param float $pIECE_NUMBER
     * @param float $pIECE_COUNT
     * @param string $tRANSFER_STATUS
     * @param string $tRANSFER_DATE
     */
    public function __construct($bARCODE = null, $tRANSACTION_DATE = null, $lOVSHIPMENTLINETRANSTYPEID = null, $bATCHWAYBILLTRANSACTIONID = null, $aUDIT_CREATE_DATE = null, $aUDITCREATEDBY = null, $aUDITCREATEUNITID = null, $aUDIT_MODIFY_DATE = null, $aUDITMODIFIEDBY = null, $aUDITMODIFYUNITID = null, $aUDIT_DELETED = null, $aPPLICATION_VERSION = null, $aPPLICATIONID = null, $lOVORGANIZATIONID = null, $bARCODETYPE = null, $tTIBAGBARGODE = null, $rECORD_TYPE = null, $pROCESS_STATUS = null, $dATE2 = null, $pLATE_NUMBER = null, $nEXT_STOP = null, $sHIPMENT_CODE = null, $pIECE_NUMBER = null, $pIECE_COUNT = null, $tRANSFER_STATUS = null, $tRANSFER_DATE = null)
    {
        $this
            ->setBARCODE($bARCODE)
            ->setTRANSACTION_DATE($tRANSACTION_DATE)
            ->setLOVSHIPMENTLINETRANSTYPEID($lOVSHIPMENTLINETRANSTYPEID)
            ->setBATCHWAYBILLTRANSACTIONID($bATCHWAYBILLTRANSACTIONID)
            ->setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE)
            ->setAUDITCREATEDBY($aUDITCREATEDBY)
            ->setAUDITCREATEUNITID($aUDITCREATEUNITID)
            ->setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE)
            ->setAUDITMODIFIEDBY($aUDITMODIFIEDBY)
            ->setAUDITMODIFYUNITID($aUDITMODIFYUNITID)
            ->setAUDIT_DELETED($aUDIT_DELETED)
            ->setAPPLICATION_VERSION($aPPLICATION_VERSION)
            ->setAPPLICATIONID($aPPLICATIONID)
            ->setLOVORGANIZATIONID($lOVORGANIZATIONID)
            ->setBARCODETYPE($bARCODETYPE)
            ->setTTIBAGBARGODE($tTIBAGBARGODE)
            ->setRECORD_TYPE($rECORD_TYPE)
            ->setPROCESS_STATUS($pROCESS_STATUS)
            ->setDATE2($dATE2)
            ->setPLATE_NUMBER($pLATE_NUMBER)
            ->setNEXT_STOP($nEXT_STOP)
            ->setSHIPMENT_CODE($sHIPMENT_CODE)
            ->setPIECE_NUMBER($pIECE_NUMBER)
            ->setPIECE_COUNT($pIECE_COUNT)
            ->setTRANSFER_STATUS($tRANSFER_STATUS)
            ->setTRANSFER_DATE($tRANSFER_DATE);
    }
    /**
     * Get BARCODE value
     * @return string|null
     */
    public function getBARCODE()
    {
        return $this->BARCODE;
    }
    /**
     * Set BARCODE value
     * @param string $bARCODE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setBARCODE($bARCODE = null)
    {
        // validation for constraint: string
        if (!is_null($bARCODE) && !is_string($bARCODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bARCODE, true), gettype($bARCODE)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($bARCODE) && mb_strlen($bARCODE) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($bARCODE)), __LINE__);
        }
        $this->BARCODE = $bARCODE;
        return $this;
    }
    /**
     * Get TRANSACTION_DATE value
     * @return string|null
     */
    public function getTRANSACTION_DATE()
    {
        return $this->TRANSACTION_DATE;
    }
    /**
     * Set TRANSACTION_DATE value
     * @param string $tRANSACTION_DATE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setTRANSACTION_DATE($tRANSACTION_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSACTION_DATE) && !is_string($tRANSACTION_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRANSACTION_DATE, true), gettype($tRANSACTION_DATE)), __LINE__);
        }
        $this->TRANSACTION_DATE = $tRANSACTION_DATE;
        return $this;
    }
    /**
     * Get LOVSHIPMENTLINETRANSTYPEID value
     * @return float|null
     */
    public function getLOVSHIPMENTLINETRANSTYPEID()
    {
        return $this->LOVSHIPMENTLINETRANSTYPEID;
    }
    /**
     * Set LOVSHIPMENTLINETRANSTYPEID value
     * @param float $lOVSHIPMENTLINETRANSTYPEID
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setLOVSHIPMENTLINETRANSTYPEID($lOVSHIPMENTLINETRANSTYPEID = null)
    {
        // validation for constraint: float
        if (!is_null($lOVSHIPMENTLINETRANSTYPEID) && !(is_float($lOVSHIPMENTLINETRANSTYPEID) || is_numeric($lOVSHIPMENTLINETRANSTYPEID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lOVSHIPMENTLINETRANSTYPEID, true), gettype($lOVSHIPMENTLINETRANSTYPEID)), __LINE__);
        }
        $this->LOVSHIPMENTLINETRANSTYPEID = $lOVSHIPMENTLINETRANSTYPEID;
        return $this;
    }
    /**
     * Get BATCHWAYBILLTRANSACTIONID value
     * @return string|null
     */
    public function getBATCHWAYBILLTRANSACTIONID()
    {
        return $this->BATCHWAYBILLTRANSACTIONID;
    }
    /**
     * Set BATCHWAYBILLTRANSACTIONID value
     * @param string $bATCHWAYBILLTRANSACTIONID
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setBATCHWAYBILLTRANSACTIONID($bATCHWAYBILLTRANSACTIONID = null)
    {
        // validation for constraint: string
        if (!is_null($bATCHWAYBILLTRANSACTIONID) && !is_string($bATCHWAYBILLTRANSACTIONID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bATCHWAYBILLTRANSACTIONID, true), gettype($bATCHWAYBILLTRANSACTIONID)), __LINE__);
        }
        $this->BATCHWAYBILLTRANSACTIONID = $bATCHWAYBILLTRANSACTIONID;
        return $this;
    }
    /**
     * Get AUDIT_CREATE_DATE value
     * @return string|null
     */
    public function getAUDIT_CREATE_DATE()
    {
        return $this->AUDIT_CREATE_DATE;
    }
    /**
     * Set AUDIT_CREATE_DATE value
     * @param string $aUDIT_CREATE_DATE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAUDIT_CREATE_DATE($aUDIT_CREATE_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_CREATE_DATE) && !is_string($aUDIT_CREATE_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_CREATE_DATE, true), gettype($aUDIT_CREATE_DATE)), __LINE__);
        }
        $this->AUDIT_CREATE_DATE = $aUDIT_CREATE_DATE;
        return $this;
    }
    /**
     * Get AUDITCREATEDBY value
     * @return float|null
     */
    public function getAUDITCREATEDBY()
    {
        return $this->AUDITCREATEDBY;
    }
    /**
     * Set AUDITCREATEDBY value
     * @param float $aUDITCREATEDBY
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAUDITCREATEDBY($aUDITCREATEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEDBY) && !(is_float($aUDITCREATEDBY) || is_numeric($aUDITCREATEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEDBY, true), gettype($aUDITCREATEDBY)), __LINE__);
        }
        $this->AUDITCREATEDBY = $aUDITCREATEDBY;
        return $this;
    }
    /**
     * Get AUDITCREATEUNITID value
     * @return float|null
     */
    public function getAUDITCREATEUNITID()
    {
        return $this->AUDITCREATEUNITID;
    }
    /**
     * Set AUDITCREATEUNITID value
     * @param float $aUDITCREATEUNITID
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAUDITCREATEUNITID($aUDITCREATEUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITCREATEUNITID) && !(is_float($aUDITCREATEUNITID) || is_numeric($aUDITCREATEUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITCREATEUNITID, true), gettype($aUDITCREATEUNITID)), __LINE__);
        }
        $this->AUDITCREATEUNITID = $aUDITCREATEUNITID;
        return $this;
    }
    /**
     * Get AUDIT_MODIFY_DATE value
     * @return string|null
     */
    public function getAUDIT_MODIFY_DATE()
    {
        return $this->AUDIT_MODIFY_DATE;
    }
    /**
     * Set AUDIT_MODIFY_DATE value
     * @param string $aUDIT_MODIFY_DATE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAUDIT_MODIFY_DATE($aUDIT_MODIFY_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_MODIFY_DATE) && !is_string($aUDIT_MODIFY_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_MODIFY_DATE, true), gettype($aUDIT_MODIFY_DATE)), __LINE__);
        }
        $this->AUDIT_MODIFY_DATE = $aUDIT_MODIFY_DATE;
        return $this;
    }
    /**
     * Get AUDITMODIFIEDBY value
     * @return float|null
     */
    public function getAUDITMODIFIEDBY()
    {
        return $this->AUDITMODIFIEDBY;
    }
    /**
     * Set AUDITMODIFIEDBY value
     * @param float $aUDITMODIFIEDBY
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAUDITMODIFIEDBY($aUDITMODIFIEDBY = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFIEDBY) && !(is_float($aUDITMODIFIEDBY) || is_numeric($aUDITMODIFIEDBY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFIEDBY, true), gettype($aUDITMODIFIEDBY)), __LINE__);
        }
        $this->AUDITMODIFIEDBY = $aUDITMODIFIEDBY;
        return $this;
    }
    /**
     * Get AUDITMODIFYUNITID value
     * @return float|null
     */
    public function getAUDITMODIFYUNITID()
    {
        return $this->AUDITMODIFYUNITID;
    }
    /**
     * Set AUDITMODIFYUNITID value
     * @param float $aUDITMODIFYUNITID
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAUDITMODIFYUNITID($aUDITMODIFYUNITID = null)
    {
        // validation for constraint: float
        if (!is_null($aUDITMODIFYUNITID) && !(is_float($aUDITMODIFYUNITID) || is_numeric($aUDITMODIFYUNITID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aUDITMODIFYUNITID, true), gettype($aUDITMODIFYUNITID)), __LINE__);
        }
        $this->AUDITMODIFYUNITID = $aUDITMODIFYUNITID;
        return $this;
    }
    /**
     * Get AUDIT_DELETED value
     * @return string|null
     */
    public function getAUDIT_DELETED()
    {
        return $this->AUDIT_DELETED;
    }
    /**
     * Set AUDIT_DELETED value
     * @param string $aUDIT_DELETED
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAUDIT_DELETED($aUDIT_DELETED = null)
    {
        // validation for constraint: string
        if (!is_null($aUDIT_DELETED) && !is_string($aUDIT_DELETED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aUDIT_DELETED, true), gettype($aUDIT_DELETED)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($aUDIT_DELETED) && mb_strlen($aUDIT_DELETED) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($aUDIT_DELETED)), __LINE__);
        }
        $this->AUDIT_DELETED = $aUDIT_DELETED;
        return $this;
    }
    /**
     * Get APPLICATION_VERSION value
     * @return string|null
     */
    public function getAPPLICATION_VERSION()
    {
        return $this->APPLICATION_VERSION;
    }
    /**
     * Set APPLICATION_VERSION value
     * @param string $aPPLICATION_VERSION
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAPPLICATION_VERSION($aPPLICATION_VERSION = null)
    {
        // validation for constraint: string
        if (!is_null($aPPLICATION_VERSION) && !is_string($aPPLICATION_VERSION)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aPPLICATION_VERSION, true), gettype($aPPLICATION_VERSION)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($aPPLICATION_VERSION) && mb_strlen($aPPLICATION_VERSION) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($aPPLICATION_VERSION)), __LINE__);
        }
        $this->APPLICATION_VERSION = $aPPLICATION_VERSION;
        return $this;
    }
    /**
     * Get APPLICATIONID value
     * @return float|null
     */
    public function getAPPLICATIONID()
    {
        return $this->APPLICATIONID;
    }
    /**
     * Set APPLICATIONID value
     * @param float $aPPLICATIONID
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setAPPLICATIONID($aPPLICATIONID = null)
    {
        // validation for constraint: float
        if (!is_null($aPPLICATIONID) && !(is_float($aPPLICATIONID) || is_numeric($aPPLICATIONID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aPPLICATIONID, true), gettype($aPPLICATIONID)), __LINE__);
        }
        $this->APPLICATIONID = $aPPLICATIONID;
        return $this;
    }
    /**
     * Get LOVORGANIZATIONID value
     * @return float|null
     */
    public function getLOVORGANIZATIONID()
    {
        return $this->LOVORGANIZATIONID;
    }
    /**
     * Set LOVORGANIZATIONID value
     * @param float $lOVORGANIZATIONID
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setLOVORGANIZATIONID($lOVORGANIZATIONID = null)
    {
        // validation for constraint: float
        if (!is_null($lOVORGANIZATIONID) && !(is_float($lOVORGANIZATIONID) || is_numeric($lOVORGANIZATIONID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lOVORGANIZATIONID, true), gettype($lOVORGANIZATIONID)), __LINE__);
        }
        $this->LOVORGANIZATIONID = $lOVORGANIZATIONID;
        return $this;
    }
    /**
     * Get BARCODETYPE value
     * @return string|null
     */
    public function getBARCODETYPE()
    {
        return $this->BARCODETYPE;
    }
    /**
     * Set BARCODETYPE value
     * @param string $bARCODETYPE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setBARCODETYPE($bARCODETYPE = null)
    {
        // validation for constraint: string
        if (!is_null($bARCODETYPE) && !is_string($bARCODETYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bARCODETYPE, true), gettype($bARCODETYPE)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($bARCODETYPE) && mb_strlen($bARCODETYPE) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($bARCODETYPE)), __LINE__);
        }
        $this->BARCODETYPE = $bARCODETYPE;
        return $this;
    }
    /**
     * Get TTIBAGBARGODE value
     * @return string|null
     */
    public function getTTIBAGBARGODE()
    {
        return $this->TTIBAGBARGODE;
    }
    /**
     * Set TTIBAGBARGODE value
     * @param string $tTIBAGBARGODE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setTTIBAGBARGODE($tTIBAGBARGODE = null)
    {
        // validation for constraint: string
        if (!is_null($tTIBAGBARGODE) && !is_string($tTIBAGBARGODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tTIBAGBARGODE, true), gettype($tTIBAGBARGODE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($tTIBAGBARGODE) && mb_strlen($tTIBAGBARGODE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($tTIBAGBARGODE)), __LINE__);
        }
        $this->TTIBAGBARGODE = $tTIBAGBARGODE;
        return $this;
    }
    /**
     * Get RECORD_TYPE value
     * @return string|null
     */
    public function getRECORD_TYPE()
    {
        return $this->RECORD_TYPE;
    }
    /**
     * Set RECORD_TYPE value
     * @param string $rECORD_TYPE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setRECORD_TYPE($rECORD_TYPE = null)
    {
        // validation for constraint: string
        if (!is_null($rECORD_TYPE) && !is_string($rECORD_TYPE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rECORD_TYPE, true), gettype($rECORD_TYPE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($rECORD_TYPE) && mb_strlen($rECORD_TYPE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($rECORD_TYPE)), __LINE__);
        }
        $this->RECORD_TYPE = $rECORD_TYPE;
        return $this;
    }
    /**
     * Get PROCESS_STATUS value
     * @return float|null
     */
    public function getPROCESS_STATUS()
    {
        return $this->PROCESS_STATUS;
    }
    /**
     * Set PROCESS_STATUS value
     * @param float $pROCESS_STATUS
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setPROCESS_STATUS($pROCESS_STATUS = null)
    {
        // validation for constraint: float
        if (!is_null($pROCESS_STATUS) && !(is_float($pROCESS_STATUS) || is_numeric($pROCESS_STATUS))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pROCESS_STATUS, true), gettype($pROCESS_STATUS)), __LINE__);
        }
        $this->PROCESS_STATUS = $pROCESS_STATUS;
        return $this;
    }
    /**
     * Get DATE2 value
     * @return string|null
     */
    public function getDATE2()
    {
        return $this->DATE2;
    }
    /**
     * Set DATE2 value
     * @param string $dATE2
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setDATE2($dATE2 = null)
    {
        // validation for constraint: string
        if (!is_null($dATE2) && !is_string($dATE2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dATE2, true), gettype($dATE2)), __LINE__);
        }
        $this->DATE2 = $dATE2;
        return $this;
    }
    /**
     * Get PLATE_NUMBER value
     * @return string|null
     */
    public function getPLATE_NUMBER()
    {
        return $this->PLATE_NUMBER;
    }
    /**
     * Set PLATE_NUMBER value
     * @param string $pLATE_NUMBER
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setPLATE_NUMBER($pLATE_NUMBER = null)
    {
        // validation for constraint: string
        if (!is_null($pLATE_NUMBER) && !is_string($pLATE_NUMBER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pLATE_NUMBER, true), gettype($pLATE_NUMBER)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($pLATE_NUMBER) && mb_strlen($pLATE_NUMBER) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($pLATE_NUMBER)), __LINE__);
        }
        $this->PLATE_NUMBER = $pLATE_NUMBER;
        return $this;
    }
    /**
     * Get NEXT_STOP value
     * @return float|null
     */
    public function getNEXT_STOP()
    {
        return $this->NEXT_STOP;
    }
    /**
     * Set NEXT_STOP value
     * @param float $nEXT_STOP
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setNEXT_STOP($nEXT_STOP = null)
    {
        // validation for constraint: float
        if (!is_null($nEXT_STOP) && !(is_float($nEXT_STOP) || is_numeric($nEXT_STOP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nEXT_STOP, true), gettype($nEXT_STOP)), __LINE__);
        }
        $this->NEXT_STOP = $nEXT_STOP;
        return $this;
    }
    /**
     * Get SHIPMENT_CODE value
     * @return string|null
     */
    public function getSHIPMENT_CODE()
    {
        return $this->SHIPMENT_CODE;
    }
    /**
     * Set SHIPMENT_CODE value
     * @param string $sHIPMENT_CODE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setSHIPMENT_CODE($sHIPMENT_CODE = null)
    {
        // validation for constraint: string
        if (!is_null($sHIPMENT_CODE) && !is_string($sHIPMENT_CODE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sHIPMENT_CODE, true), gettype($sHIPMENT_CODE)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($sHIPMENT_CODE) && mb_strlen($sHIPMENT_CODE) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($sHIPMENT_CODE)), __LINE__);
        }
        $this->SHIPMENT_CODE = $sHIPMENT_CODE;
        return $this;
    }
    /**
     * Get PIECE_NUMBER value
     * @return float|null
     */
    public function getPIECE_NUMBER()
    {
        return $this->PIECE_NUMBER;
    }
    /**
     * Set PIECE_NUMBER value
     * @param float $pIECE_NUMBER
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setPIECE_NUMBER($pIECE_NUMBER = null)
    {
        // validation for constraint: float
        if (!is_null($pIECE_NUMBER) && !(is_float($pIECE_NUMBER) || is_numeric($pIECE_NUMBER))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pIECE_NUMBER, true), gettype($pIECE_NUMBER)), __LINE__);
        }
        $this->PIECE_NUMBER = $pIECE_NUMBER;
        return $this;
    }
    /**
     * Get PIECE_COUNT value
     * @return float|null
     */
    public function getPIECE_COUNT()
    {
        return $this->PIECE_COUNT;
    }
    /**
     * Set PIECE_COUNT value
     * @param float $pIECE_COUNT
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setPIECE_COUNT($pIECE_COUNT = null)
    {
        // validation for constraint: float
        if (!is_null($pIECE_COUNT) && !(is_float($pIECE_COUNT) || is_numeric($pIECE_COUNT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pIECE_COUNT, true), gettype($pIECE_COUNT)), __LINE__);
        }
        $this->PIECE_COUNT = $pIECE_COUNT;
        return $this;
    }
    /**
     * Get TRANSFER_STATUS value
     * @return string|null
     */
    public function getTRANSFER_STATUS()
    {
        return $this->TRANSFER_STATUS;
    }
    /**
     * Set TRANSFER_STATUS value
     * @param string $tRANSFER_STATUS
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setTRANSFER_STATUS($tRANSFER_STATUS = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSFER_STATUS) && !is_string($tRANSFER_STATUS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRANSFER_STATUS, true), gettype($tRANSFER_STATUS)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($tRANSFER_STATUS) && mb_strlen($tRANSFER_STATUS) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($tRANSFER_STATUS)), __LINE__);
        }
        $this->TRANSFER_STATUS = $tRANSFER_STATUS;
        return $this;
    }
    /**
     * Get TRANSFER_DATE value
     * @return string|null
     */
    public function getTRANSFER_DATE()
    {
        return $this->TRANSFER_DATE;
    }
    /**
     * Set TRANSFER_DATE value
     * @param string $tRANSFER_DATE
     * @return \Ys\ArasKargo\StructType\BATCHWAYBILLTRANSACTION
     */
    public function setTRANSFER_DATE($tRANSFER_DATE = null)
    {
        // validation for constraint: string
        if (!is_null($tRANSFER_DATE) && !is_string($tRANSFER_DATE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tRANSFER_DATE, true), gettype($tRANSFER_DATE)), __LINE__);
        }
        $this->TRANSFER_DATE = $tRANSFER_DATE;
        return $this;
    }
}
