<?php

namespace Ys\ArasKargo\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $AccountId;
    /**
     * The CustomerAddressInfoId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $CustomerAddressInfoId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The CompleteAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompleteAddress;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PhoneNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The EMail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMail;
    /**
     * The CustomerAddressId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerAddressId;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The TownName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TownName;
    /**
     * Constructor method for Address
     * @uses Address::setAccountId()
     * @uses Address::setCustomerAddressInfoId()
     * @uses Address::setUserName()
     * @uses Address::setPassword()
     * @uses Address::setCompleteAddress()
     * @uses Address::setName()
     * @uses Address::setPhoneNumber()
     * @uses Address::setEMail()
     * @uses Address::setCustomerAddressId()
     * @uses Address::setCityName()
     * @uses Address::setTownName()
     * @param string $accountId
     * @param string $customerAddressInfoId
     * @param string $userName
     * @param string $password
     * @param string $completeAddress
     * @param string $name
     * @param string $phoneNumber
     * @param string $eMail
     * @param string $customerAddressId
     * @param string $cityName
     * @param string $townName
     */
    public function __construct($accountId = null, $customerAddressInfoId = null, $userName = null, $password = null, $completeAddress = null, $name = null, $phoneNumber = null, $eMail = null, $customerAddressId = null, $cityName = null, $townName = null)
    {
        $this
            ->setAccountId($accountId)
            ->setCustomerAddressInfoId($customerAddressInfoId)
            ->setUserName($userName)
            ->setPassword($password)
            ->setCompleteAddress($completeAddress)
            ->setName($name)
            ->setPhoneNumber($phoneNumber)
            ->setEMail($eMail)
            ->setCustomerAddressId($customerAddressId)
            ->setCityName($cityName)
            ->setTownName($townName);
    }
    /**
     * Get AccountId value
     * @return string
     */
    public function getAccountId()
    {
        return $this->AccountId;
    }
    /**
     * Set AccountId value
     * @param string $accountId
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($accountId, true)), __LINE__);
        }
        $this->AccountId = $accountId;
        return $this;
    }
    /**
     * Get CustomerAddressInfoId value
     * @return string
     */
    public function getCustomerAddressInfoId()
    {
        return $this->CustomerAddressInfoId;
    }
    /**
     * Set CustomerAddressInfoId value
     * @param string $customerAddressInfoId
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setCustomerAddressInfoId($customerAddressInfoId = null)
    {
        // validation for constraint: string
        if (!is_null($customerAddressInfoId) && !is_string($customerAddressInfoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAddressInfoId, true), gettype($customerAddressInfoId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($customerAddressInfoId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $customerAddressInfoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression /[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', var_export($customerAddressInfoId, true)), __LINE__);
        }
        $this->CustomerAddressInfoId = $customerAddressInfoId;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get CompleteAddress value
     * @return string|null
     */
    public function getCompleteAddress()
    {
        return $this->CompleteAddress;
    }
    /**
     * Set CompleteAddress value
     * @param string $completeAddress
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setCompleteAddress($completeAddress = null)
    {
        // validation for constraint: string
        if (!is_null($completeAddress) && !is_string($completeAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completeAddress, true), gettype($completeAddress)), __LINE__);
        }
        $this->CompleteAddress = $completeAddress;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phoneNumber, true), gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get EMail value
     * @return string|null
     */
    public function getEMail()
    {
        return $this->EMail;
    }
    /**
     * Set EMail value
     * @param string $eMail
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        $this->EMail = $eMail;
        return $this;
    }
    /**
     * Get CustomerAddressId value
     * @return string|null
     */
    public function getCustomerAddressId()
    {
        return $this->CustomerAddressId;
    }
    /**
     * Set CustomerAddressId value
     * @param string $customerAddressId
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setCustomerAddressId($customerAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($customerAddressId) && !is_string($customerAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerAddressId, true), gettype($customerAddressId)), __LINE__);
        }
        $this->CustomerAddressId = $customerAddressId;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get TownName value
     * @return string|null
     */
    public function getTownName()
    {
        return $this->TownName;
    }
    /**
     * Set TownName value
     * @param string $townName
     * @return \Ys\ArasKargo\StructType\Address
     */
    public function setTownName($townName = null)
    {
        // validation for constraint: string
        if (!is_null($townName) && !is_string($townName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($townName, true), gettype($townName)), __LINE__);
        }
        $this->TownName = $townName;
        return $this;
    }
}
