<?php

namespace Ys\ArasKargo\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CancelRecall
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasKargo\StructType\CancelRecall $parameters
     * @return \Ys\ArasKargo\StructType\CancelRecallResponse|bool
     */
    public function CancelRecall(\Ys\ArasKargo\StructType\CancelRecall $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('CancelRecall', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelCargoLineInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasKargo\StructType\CancelCargoLineInfo $parameters
     * @return \Ys\ArasKargo\StructType\CancelCargoLineInfoResponse|bool
     */
    public function CancelCargoLineInfo(\Ys\ArasKargo\StructType\CancelCargoLineInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('CancelCargoLineInfo', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelDispatch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasKargo\StructType\CancelDispatch $parameters
     * @return \Ys\ArasKargo\StructType\CancelDispatchResponse|bool
     */
    public function CancelDispatch(\Ys\ArasKargo\StructType\CancelDispatch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->__soapCall('CancelDispatch', array(
                $parameters,
            ), array(), array(), $this->outputHeaders));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\ArasKargo\StructType\CancelCargoLineInfoResponse|\Ys\ArasKargo\StructType\CancelDispatchResponse|\Ys\ArasKargo\StructType\CancelRecallResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
