<?php

namespace Ys\ArasKargo\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Call ServiceType
 * @subpackage Services
 */
class Call extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CallCourier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Ys\ArasKargo\StructType\CallCourier $parameters
     * @return \Ys\ArasKargo\StructType\CallCourierResponse|bool
     */
    public function CallCourier(\Ys\ArasKargo\StructType\CallCourier $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CallCourier($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Ys\ArasKargo\StructType\CallCourierResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
