<?php


namespace Ys\ArasKargo\Entities;


class Type2DataTable
{

    #region fields

    /**
     * @var string|null
     */
    public $MUSTERI_OZEL_KODU;

    /**
     * @var string|null
     */
    public $MUSTERI_KODU;

    /**
     * @var string|null
     */
    public $IRSALIYE_NUMARA;

    /**
     * @var string|null
     */
    public $NAME;

    /**
     * @var string|null
     */
    public $GONDERICI_ADI;

    /**
     * @var string|null
     */
    public $ALICI_ADI;

    /**
     * @var string|null
     */
    public $CIKIS_SUBESI;

    /**
     * @var string|null
     */
    public $VARIS_SUBESI;

    /**
     * @var string|null
     */
    public $DUZENLEME_TARIHI;

    /**
     * @var string|null
     */
    public $SEHIR;

    /**
     * @var string|null
     */
    public $TUTAR;

    /**
     * @var string|null
     */
    public $ADET;

    /**
     * @var string|null
     */
    public $DESI;

    /**
     * @var string|null
     */
    public $IADE;

    /**
     * @var string|null
     */
    public $KARGO_KODU;

    /**
     * @var string|null
     */
    public $TRACKINGNUMBER;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getMUSTERI_OZEL_KODU()
    {
        return $this->MUSTERI_OZEL_KODU;
    }

    /**
     * @param string|null $MUSTERI_OZEL_KODU
     * @return Type2DataTable
     */
    public function setMUSTERI_OZEL_KODU($MUSTERI_OZEL_KODU)
    {
        $this->MUSTERI_OZEL_KODU = $MUSTERI_OZEL_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }

    /**
     * @param string|null $MUSTERI_KODU
     * @return Type2DataTable
     */
    public function setMUSTERI_KODU($MUSTERI_KODU)
    {
        $this->MUSTERI_KODU = $MUSTERI_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIRSALIYE_NUMARA()
    {
        return $this->IRSALIYE_NUMARA;
    }

    /**
     * @param string|null $IRSALIYE_NUMARA
     * @return Type2DataTable
     */
    public function setIRSALIYE_NUMARA($IRSALIYE_NUMARA)
    {
        $this->IRSALIYE_NUMARA = $IRSALIYE_NUMARA;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getNAME()
    {
        return $this->NAME;
    }

    /**
     * @param string|null $NAME
     * @return Type2DataTable
     */
    public function setNAME($NAME)
    {
        $this->NAME = $NAME;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getGONDERICI_ADI()
    {
        return $this->GONDERICI_ADI;
    }

    /**
     * @param string|null $GONDERICI_ADI
     * @return Type2DataTable
     */
    public function setGONDERICI_ADI($GONDERICI_ADI)
    {
        $this->GONDERICI_ADI = $GONDERICI_ADI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }

    /**
     * @param string|null $ALICI_ADI
     * @return Type2DataTable
     */
    public function setALICI_ADI($ALICI_ADI)
    {
        $this->ALICI_ADI = $ALICI_ADI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCIKIS_SUBESI()
    {
        return $this->CIKIS_SUBESI;
    }

    /**
     * @param string|null $CIKIS_SUBESI
     * @return Type2DataTable
     */
    public function setCIKIS_SUBESI($CIKIS_SUBESI)
    {
        $this->CIKIS_SUBESI = $CIKIS_SUBESI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVARIS_SUBESI()
    {
        return $this->VARIS_SUBESI;
    }

    /**
     * @param string|null $VARIS_SUBESI
     * @return Type2DataTable
     */
    public function setVARIS_SUBESI($VARIS_SUBESI)
    {
        $this->VARIS_SUBESI = $VARIS_SUBESI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDUZENLEME_TARIHI()
    {
        return $this->DUZENLEME_TARIHI;
    }

    /**
     * @param string|null $DUZENLEME_TARIHI
     * @return Type2DataTable
     */
    public function setDUZENLEME_TARIHI($DUZENLEME_TARIHI)
    {
        $this->DUZENLEME_TARIHI = $DUZENLEME_TARIHI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }

    /**
     * @param string|null $SEHIR
     * @return Type2DataTable
     */
    public function setSEHIR($SEHIR)
    {
        $this->SEHIR = $SEHIR;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }

    /**
     * @param string|null $TUTAR
     * @return Type2DataTable
     */
    public function setTUTAR($TUTAR)
    {
        $this->TUTAR = $TUTAR;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getADET()
    {
        return $this->ADET;
    }

    /**
     * @param string|null $ADET
     * @return Type2DataTable
     */
    public function setADET($ADET)
    {
        $this->ADET = $ADET;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }

    /**
     * @param string|null $DESI
     * @return Type2DataTable
     */
    public function setDESI($DESI)
    {
        $this->DESI = $DESI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIADE()
    {
        return $this->IADE;
    }

    /**
     * @param string|null $IADE
     * @return Type2DataTable
     */
    public function setIADE($IADE)
    {
        $this->IADE = $IADE;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getKARGO_KODU()
    {
        return $this->KARGO_KODU;
    }

    /**
     * @param string|null $KARGO_KODU
     * @return Type2DataTable
     */
    public function setKARGO_KODU($KARGO_KODU)
    {
        $this->KARGO_KODU = $KARGO_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTRACKINGNUMBER()
    {
        return $this->TRACKINGNUMBER;
    }

    /**
     * @param string|null $TRACKINGNUMBER
     * @return Type2DataTable
     */
    public function setTRACKINGNUMBER($TRACKINGNUMBER)
    {
        $this->TRACKINGNUMBER = $TRACKINGNUMBER;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param \DOMNode $domNode
     * @return null|Type2DataTable
     */
    public static function fromDomNode($domNode){
        if(empty($domNode)){
            return null;
        }
        while ($domNode->nodeName != 'TYPE2DATATABLE' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'TYPE2DATATABLE' || ! $domNode->hasChildNodes()){
            return null;
        }
        $type2Dt = new Type2DataTable();
        $nd =  $domNode->firstChild;

        while ($nd != null){
            $key = $nd->nodeName;
            $method = "set" . $key;
            if(method_exists($type2Dt,$method)){
                $type2Dt->$method($nd->nodeValue);
            }
            
            $nd = $nd->nextSibling;
        }
        return $type2Dt;
    }

    /**
     * @param \DOMNode $domNode
     * @return array|Type2DataTable[]
     */
    public static function fromDomNodeArray($domNode){
        if(empty($domNode)){
            return array();
        }
        while ($domNode->nodeName != 'NewDataSet' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'NewDataSet' || ! $domNode->hasChildNodes()){
            return array();
        }
        $res = array();
        foreach ($domNode->childNodes as $node){
            $itm = static::fromDomNode($node);
            if($itm != null){
                $res[] = $itm;
            }
        }

        return $res;
    }

    #endregion statics

}