<?php


namespace Ys\ArasKargo\Entities;


use Ys\ArasKargo\Xml\XmlNode;
use Ys\ArasKargo\Xml\ItoXml;

class QueryInfo implements ItoXml
{

    #region fields

    /**
     * @var int
     */
    protected $queryType;

    /**
     * @var array
     */
    protected $parameters = array();


    #endregion fields

    #region ctor

    /**
     * QueryInfo constructor.
     * @param int $queryType
     */
    public function __construct($queryType)
    {
        $this->queryType = $queryType;
    }

    #endregion ctor

    #region properties

    /**
     * @return int
     */
    public function getQueryType()
    {
        return $this->queryType;
    }

    /**
     * @param int $queryType
     * @return QueryInfo
     */
    public function setQueryType($queryType)
    {
        $this->queryType = $queryType;
        return $this;
    }

    /**
     * @return array
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    /**
     * @param array $parameters
     * @return QueryInfo
     */
    public function setParameters($parameters)
    {
        $this->parameters = $parameters;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIntegrationCode()
    {
        return $this->getParam('IntegrationCode');
    }

    /**
     * @param string $integrationCode
     * @return $this
     */
    public function setIntegrationCode($integrationCode)
    {
        $this->setParam('IntegrationCode', $integrationCode);
        return $this;
    }

    #endregion properties

    #region methods

    /**
     * @param string $key
     * @return mixed|null
     */
    public function getParam($key)
    {
        if (isset($this->parameters[$key])) {
            return $this->parameters[$key];
        }
        return null;
    }

    /**
     * @param string $key
     * @param mixed $val
     * @return $this
     */
    public function setParam($key, $val)
    {
        $this->parameters[$key] = $val;
        return $this;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->toXml();
    }
    #endregion methods

    #region ItoXml

    /**
     * @return XmlNode
     */
    public function toXmlNode()
    {
        $qiNode = new XmlNode('QueryInfo');
        $qiNode->addChild(new XmlNode('QueryType', $this->getQueryType()));

        foreach ($this->parameters as $k => $v) {
            $qiNode->addChild(new XmlNode($k, $v));
        }
        return $qiNode;

    }

    /**
     * @return string
     */
    public function toXml()
    {
        return $this->toXmlNode()->toXmlString();
    }



    #endregion ItoXml

}