<?php


namespace Ys\ArasKargo\Entities;


use Ys\ArasKargo\Xml\XmlNode;
use Ys\ArasKargo\Xml\ItoXml;

class LoginInfo implements ItoXml
{
    #region fields

    /**
     * @var string
     */
    protected $userName;

    /**
     * @var string
     */
    protected $password;

    /**
     * @var string
     */
    protected $customerCode;

    #endregion fields

    #region ctor

    /**
     * LoginInfo constructor.
     * @param string $userName
     * @param string $password
     * @param string $customerCode
     */
    public function __construct($userName = '', $password = '',$customerCode = '' )
    {
        $this->userName = $userName;
        $this->password = $password;
        $this->customerCode = $customerCode;
    }

    #endregion ctor

    #region Properties

    /**
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }

    /**
     * @param string $userName
     * @return LoginInfo
     */
    public function setUserName($userName)
    {
        $this->userName = $userName;
        return $this;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param string $password
     * @return LoginInfo
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * @return string
     */
    public function getCustomerCode()
    {
        return $this->customerCode;
    }

    /**
     * @param string $customerCode
     * @return LoginInfo
     */
    public function setCustomerCode($customerCode)
    {
        $this->customerCode = $customerCode;
        return $this;
    }

    #endregion Properties

    #region Methods

    /**
     * @return string
     */
    public function __toString()
    {
        return $this->toXml();
    }

    #endregion Methods

    #region ItoXml

    /**
     * @return XmlNode
     */
    public function toXmlNode()
    {
        $lgInf = new XmlNode('LoginInfo');
        $lgInf->addChild(new XmlNode('UserName',$this->getUserName()))
            ->addChild(new XmlNode('Password',$this->getPassword()))
            ->addChild(new XmlNode('CustomerCode',$this->getCustomerCode()));
        return $lgInf;
    }

    /**
     * @return string
     */
    public function toXml()
    {
        return $this->toXmlNode()->toXmlString();
    }

    #endregion ItoXml
}