<?php


namespace Ys\ArasKargo\Entities;


class CargoData8
{

    #region fields

    /**
     * @var string|null
     */
    public $SUBE_ADI;

    /**
     * @var string|null
     */
    public $SUBE_ADRESI;

    /**
     * @var string|null
     */
    public $ILCE;

    /**
     * @var string|null
     */
    public $TELEFON;

    /**
     * @var string|null
     */
    public $EMAIL;

    /**
     * @var string|null
     */
    public $BAGLI_BOLGE;

    /**
     * @var string|null
     */
    public $KORDINAT;

    /**
     * @var string|null
     */
    public $SUBE_ID;

    /**
     * @var string|null
     */
    public $SUBE_KODU;

    /**
     * @var string|null
     */
    public $IL_KODU;

    /**
     * @var string|null
     */
    public $ILCE_KODU;

    /**
     * @var string|null
     */
    public $SABIT_CEP;

    /**
     * @var string|null
     */
    public $CAN_BE_AGENCY;

    /**
     * @var string|null
     */
    public $ILCE_ID;

    /**
     * @var string|null
     */
    public $LOVADDRESSTYPEID;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getSUBE_ADI()
    {
        return $this->SUBE_ADI;
    }

    /**
     * @param string|null $SUBE_ADI
     * @return CargoData8
     */
    public function setSUBE_ADI($SUBE_ADI)
    {
        $this->SUBE_ADI = $SUBE_ADI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSUBE_ADRESI()
    {
        return $this->SUBE_ADRESI;
    }

    /**
     * @param string|null $SUBE_ADRESI
     * @return CargoData8
     */
    public function setSUBE_ADRESI($SUBE_ADRESI)
    {
        $this->SUBE_ADRESI = $SUBE_ADRESI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getILCE()
    {
        return $this->ILCE;
    }

    /**
     * @param string|null $ILCE
     * @return CargoData8
     */
    public function setILCE($ILCE)
    {
        $this->ILCE = $ILCE;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTELEFON()
    {
        return $this->TELEFON;
    }

    /**
     * @param string|null $TELEFON
     * @return CargoData8
     */
    public function setTELEFON($TELEFON)
    {
        $this->TELEFON = $TELEFON;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getEMAIL()
    {
        return $this->EMAIL;
    }

    /**
     * @param string|null $EMAIL
     * @return CargoData8
     */
    public function setEMAIL($EMAIL)
    {
        $this->EMAIL = $EMAIL;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBAGLI_BOLGE()
    {
        return $this->BAGLI_BOLGE;
    }

    /**
     * @param string|null $BAGLI_BOLGE
     * @return CargoData8
     */
    public function setBAGLI_BOLGE($BAGLI_BOLGE)
    {
        $this->BAGLI_BOLGE = $BAGLI_BOLGE;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getKORDINAT()
    {
        return $this->KORDINAT;
    }

    /**
     * @param string|null $KORDINAT
     * @return CargoData8
     */
    public function setKORDINAT($KORDINAT)
    {
        $this->KORDINAT = $KORDINAT;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSUBE_ID()
    {
        return $this->SUBE_ID;
    }

    /**
     * @param string|null $SUBE_ID
     * @return CargoData8
     */
    public function setSUBE_ID($SUBE_ID)
    {
        $this->SUBE_ID = $SUBE_ID;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSUBE_KODU()
    {
        return $this->SUBE_KODU;
    }

    /**
     * @param string|null $SUBE_KODU
     * @return CargoData8
     */
    public function setSUBE_KODU($SUBE_KODU)
    {
        $this->SUBE_KODU = $SUBE_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIL_KODU()
    {
        return $this->IL_KODU;
    }

    /**
     * @param string|null $IL_KODU
     * @return CargoData8
     */
    public function setIL_KODU($IL_KODU)
    {
        $this->IL_KODU = $IL_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getILCE_KODU()
    {
        return $this->ILCE_KODU;
    }

    /**
     * @param string|null $ILCE_KODU
     * @return CargoData8
     */
    public function setILCE_KODU($ILCE_KODU)
    {
        $this->ILCE_KODU = $ILCE_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSABIT_CEP()
    {
        return $this->SABIT_CEP;
    }

    /**
     * @param string|null $SABIT_CEP
     * @return CargoData8
     */
    public function setSABIT_CEP($SABIT_CEP)
    {
        $this->SABIT_CEP = $SABIT_CEP;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCAN_BE_AGENCY()
    {
        return $this->CAN_BE_AGENCY;
    }

    /**
     * @param string|null $CAN_BE_AGENCY
     * @return CargoData8
     */
    public function setCAN_BE_AGENCY($CAN_BE_AGENCY)
    {
        $this->CAN_BE_AGENCY = $CAN_BE_AGENCY;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getILCE_ID()
    {
        return $this->ILCE_ID;
    }

    /**
     * @param string|null $ILCE_ID
     * @return CargoData8
     */
    public function setILCE_ID($ILCE_ID)
    {
        $this->ILCE_ID = $ILCE_ID;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getLOVADDRESSTYPEID()
    {
        return $this->LOVADDRESSTYPEID;
    }

    /**
     * @param string|null $LOVADDRESSTYPEID
     * @return CargoData8
     */
    public function setLOVADDRESSTYPEID($LOVADDRESSTYPEID)
    {
        $this->LOVADDRESSTYPEID = $LOVADDRESSTYPEID;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param \DOMNode $domNode
     * @return null|CargoData8
     */
    public static function fromDomNode($domNode){
        if(empty($domNode)){
            return null;
        }
        while ($domNode->nodeName != 'CARGODATA8' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'CARGODATA8' || ! $domNode->hasChildNodes()){
            return null;
        }
        $cd8 = new CargoData8();
        $nd =  $domNode->firstChild;

        while ($nd != null){
            $key = $nd->nodeName;
            $method = "set" . $key;
            if(method_exists($cd8,$method)){
                $cd8->$method($nd->nodeValue);
            }

            $nd = $nd->nextSibling;
        }
        return $cd8;
    }

    /**
     * @param \DOMNode $domNode
     * @return array|CargoData8[]
     */
    public static function fromDomNodeArray($domNode){
        if(empty($domNode)){
            return array();
        }
        while ($domNode->nodeName != 'NewDataSet' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'NewDataSet' || ! $domNode->hasChildNodes()){
            return array();
        }
        $res = array();
        foreach ($domNode->childNodes as $node){
            $itm = static::fromDomNode($node);
            if($itm != null){
                $res[] = $itm;
            }
        }

        return $res;
    }

    #endregion statics

}