<?php


namespace Ys\ArasKargo\Entities;


class CargoData6
{

    #region fields

    /**
     * @var string|null
     */
    public $ISLEM_TARIHI;

    /**
     * @var string|null
     */
    public $BIRIM;

    /**
     * @var string|null
     */
    public $ISLEM;

    /**
     * @var string|null
     */
    public $ACIKLAMA;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getISLEM_TARIHI()
    {
        return $this->ISLEM_TARIHI;
    }

    /**
     * @param string|null $ISLEM_TARIHI
     * @return CargoData6
     */
    public function setISLEM_TARIHI($ISLEM_TARIHI)
    {
        $this->ISLEM_TARIHI = $ISLEM_TARIHI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBIRIM()
    {
        return $this->BIRIM;
    }

    /**
     * @param string|null $BIRIM
     * @return CargoData6
     */
    public function setBIRIM($BIRIM)
    {
        $this->BIRIM = $BIRIM;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getISLEM()
    {
        return $this->ISLEM;
    }

    /**
     * @param string|null $ISLEM
     * @return CargoData6
     */
    public function setISLEM($ISLEM)
    {
        $this->ISLEM = $ISLEM;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getACIKLAMA()
    {
        return $this->ACIKLAMA;
    }

    /**
     * @param string|null $ACIKLAMA
     * @return CargoData6
     */
    public function setACIKLAMA($ACIKLAMA)
    {
        $this->ACIKLAMA = $ACIKLAMA;
        return $this;
    }


    #endregion properties

    #region statics

    /**
     * @param \DOMNode $domNode
     * @return null|CargoData6
     */
    public static function fromDomNode($domNode){
        if(empty($domNode)){
            return null;
        }
        while ($domNode->nodeName != 'CARGODATA6' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'CARGODATA6' || ! $domNode->hasChildNodes()){
            return null;
        }
        $cd6 = new CargoData6();
        $nd =  $domNode->firstChild;

        while ($nd != null){
            $key = $nd->nodeName;
            $method = "set" . $key;
            if(method_exists($cd6,$method)){
                $cd6->$method($nd->nodeValue);
            }

            $nd = $nd->nextSibling;
        }
        return $cd6;
    }

    /**
     * @param \DOMNode $domNode
     * @return array|CargoData6[]
     */
    public static function fromDomNodeArray($domNode){
        if(empty($domNode)){
            return array();
        }
        while ($domNode->nodeName != 'NewDataSet' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'NewDataSet' || ! $domNode->hasChildNodes()){
            return array();
        }
        $res = array();
        foreach ($domNode->childNodes as $node){
            $itm = static::fromDomNode($node);
            if($itm != null){
                $res[] = $itm;
            }
        }

        return $res;
    }

    #endregion statics

}