<?php


namespace Ys\ArasKargo\Entities;


class CargoData2
{
    #region fields

    /**
     * @var string|null
     */
    public $MUSTERI_KODU;

    /**
     * @var string|null
     */
    public $IRSALIYE_NUMARA;

    /**
     * @var string|null
     */
    public $ALICI_ADI;

    /**
     * @var string|null
     */
    public $SEVK_IRSALIYE;

    /**
     * @var string|null
     */
    public $CIKIS_SUBESI;

    /**
     * @var string|null
     */
    public $VARIS_SUBESI;

    /**
     * @var string|null
     */
    public $REFERANSNO;

    /**
     * @var string|null
     */
    public $DUZENLEME_TARIHI;

    /**
     * @var string|null
     */
    public $SEHIR;

    /**
     * @var string|null
     */
    public $TUTAR;

    /**
     * @var string|null
     */
    public $ADET;

    /**
     * @var string|null
     */
    public $DESI;

    /**
     * @var string|null
     */
    public $ODEME_TURU;

    /**
     * @var string|null
     */
    public $TESLIM_ALAN;

    /**
     * @var string|null
     */
    public $TESLIM_TARIHI;

    /**
     * @var string|null
     */
    public $TESLIM_SAATI;

    /**
     * @var string|null
     */
    public $IADE;

    /**
     * @var string|null
     */
    public $MUSTERI_OZEL_KODU;

    /**
     * @var string|null
     */
    public $KARGO_KODU;

    /**
     * @var string|null
     */
    public $DURUM_KODU;

    /**
     * @var string|null
     */
    public $TIP_KODU;

    /**
     * @var string|null
     */
    public $DURUMU;

    /**
     * @var string|null
     */
    public $HACIMSEL_AGIRLIK;

    /**
     * @var string|null
     */
    public $AGIRLIK;
    

    #endregion fields
    
    #region ctor
    
    public function __construct()
    {
    }



    #endregion ctor
    
    #region props

    /**
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }

    /**
     * @param string|null $MUSTERI_KODU
     * @return CargoData2
     */
    public function setMUSTERI_KODU($MUSTERI_KODU)
    {
        $this->MUSTERI_KODU = $MUSTERI_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIRSALIYE_NUMARA()
    {
        return $this->IRSALIYE_NUMARA;
    }

    /**
     * @param string|null $IRSALIYE_NUMARA
     * @return CargoData2
     */
    public function setIRSALIYE_NUMARA($IRSALIYE_NUMARA)
    {
        $this->IRSALIYE_NUMARA = $IRSALIYE_NUMARA;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }

    /**
     * @param string|null $ALICI_ADI
     * @return CargoData2
     */
    public function setALICI_ADI($ALICI_ADI)
    {
        $this->ALICI_ADI = $ALICI_ADI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSEVK_IRSALIYE()
    {
        return $this->SEVK_IRSALIYE;
    }

    /**
     * @param string|null $SEVK_IRSALIYE
     * @return CargoData2
     */
    public function setSEVK_IRSALIYE($SEVK_IRSALIYE)
    {
        $this->SEVK_IRSALIYE = $SEVK_IRSALIYE;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCIKIS_SUBESI()
    {
        return $this->CIKIS_SUBESI;
    }

    /**
     * @param string|null $CIKIS_SUBESI
     * @return CargoData2
     */
    public function setCIKIS_SUBESI($CIKIS_SUBESI)
    {
        $this->CIKIS_SUBESI = $CIKIS_SUBESI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getVARIS_SUBESI()
    {
        return $this->VARIS_SUBESI;
    }

    /**
     * @param string|null $VARIS_SUBESI
     * @return CargoData2
     */
    public function setVARIS_SUBESI($VARIS_SUBESI)
    {
        $this->VARIS_SUBESI = $VARIS_SUBESI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getREFERANSNO()
    {
        return $this->REFERANSNO;
    }

    /**
     * @param string|null $REFERANSNO
     * @return CargoData2
     */
    public function setREFERANSNO($REFERANSNO)
    {
        $this->REFERANSNO = $REFERANSNO;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDUZENLEME_TARIHI()
    {
        return $this->DUZENLEME_TARIHI;
    }

    /**
     * @param string|null $DUZENLEME_TARIHI
     * @return CargoData2
     */
    public function setDUZENLEME_TARIHI($DUZENLEME_TARIHI)
    {
        $this->DUZENLEME_TARIHI = $DUZENLEME_TARIHI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSEHIR()
    {
        return $this->SEHIR;
    }

    /**
     * @param string|null $SEHIR
     * @return CargoData2
     */
    public function setSEHIR($SEHIR)
    {
        $this->SEHIR = $SEHIR;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTUTAR()
    {
        return $this->TUTAR;
    }

    /**
     * @param string|null $TUTAR
     * @return CargoData2
     */
    public function setTUTAR($TUTAR)
    {
        $this->TUTAR = $TUTAR;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getADET()
    {
        return $this->ADET;
    }

    /**
     * @param string|null $ADET
     * @return CargoData2
     */
    public function setADET($ADET)
    {
        $this->ADET = $ADET;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDESI()
    {
        return $this->DESI;
    }

    /**
     * @param string|null $DESI
     * @return CargoData2
     */
    public function setDESI($DESI)
    {
        $this->DESI = $DESI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getODEME_TURU()
    {
        return $this->ODEME_TURU;
    }

    /**
     * @param string|null $ODEME_TURU
     * @return CargoData2
     */
    public function setODEME_TURU($ODEME_TURU)
    {
        $this->ODEME_TURU = $ODEME_TURU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTESLIM_ALAN()
    {
        return $this->TESLIM_ALAN;
    }

    /**
     * @param string|null $TESLIM_ALAN
     * @return CargoData2
     */
    public function setTESLIM_ALAN($TESLIM_ALAN)
    {
        $this->TESLIM_ALAN = $TESLIM_ALAN;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTESLIM_TARIHI()
    {
        return $this->TESLIM_TARIHI;
    }

    /**
     * @param string|null $TESLIM_TARIHI
     * @return CargoData2
     */
    public function setTESLIM_TARIHI($TESLIM_TARIHI)
    {
        $this->TESLIM_TARIHI = $TESLIM_TARIHI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTESLIM_SAATI()
    {
        return $this->TESLIM_SAATI;
    }

    /**
     * @param string|null $TESLIM_SAATI
     * @return CargoData2
     */
    public function setTESLIM_SAATI($TESLIM_SAATI)
    {
        $this->TESLIM_SAATI = $TESLIM_SAATI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIADE()
    {
        return $this->IADE;
    }

    /**
     * @param string|null $IADE
     * @return CargoData2
     */
    public function setIADE($IADE)
    {
        $this->IADE = $IADE;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMUSTERI_OZEL_KODU()
    {
        return $this->MUSTERI_OZEL_KODU;
    }

    /**
     * @param string|null $MUSTERI_OZEL_KODU
     * @return CargoData2
     */
    public function setMUSTERI_OZEL_KODU($MUSTERI_OZEL_KODU)
    {
        $this->MUSTERI_OZEL_KODU = $MUSTERI_OZEL_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getKARGO_KODU()
    {
        return $this->KARGO_KODU;
    }

    /**
     * @param string|null $KARGO_KODU
     * @return CargoData2
     */
    public function setKARGO_KODU($KARGO_KODU)
    {
        $this->KARGO_KODU = $KARGO_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDURUM_KODU()
    {
        return $this->DURUM_KODU;
    }

    /**
     * @param string|null $DURUM_KODU
     * @return CargoData2
     */
    public function setDURUM_KODU($DURUM_KODU)
    {
        $this->DURUM_KODU = $DURUM_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getTIP_KODU()
    {
        return $this->TIP_KODU;
    }

    /**
     * @param string|null $TIP_KODU
     * @return CargoData2
     */
    public function setTIP_KODU($TIP_KODU)
    {
        $this->TIP_KODU = $TIP_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDURUMU()
    {
        return $this->DURUMU;
    }

    /**
     * @param string|null $DURUMU
     * @return CargoData2
     */
    public function setDURUMU($DURUMU)
    {
        $this->DURUMU = $DURUMU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getHACIMSEL_AGIRLIK()
    {
        return $this->HACIMSEL_AGIRLIK;
    }

    /**
     * @param string|null $HACIMSEL_AGIRLIK
     * @return CargoData2
     */
    public function setHACIMSEL_AGIRLIK($HACIMSEL_AGIRLIK)
    {
        $this->HACIMSEL_AGIRLIK = $HACIMSEL_AGIRLIK;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getAGIRLIK()
    {
        return $this->AGIRLIK;
    }

    /**
     * @param string|null $AGIRLIK
     * @return CargoData2
     */
    public function setAGIRLIK($AGIRLIK)
    {
        $this->AGIRLIK = $AGIRLIK;
        return $this;
    }

    #endregion props

    #region statics

    /**
     * @param \DOMNode $domNode
     * @return null|CargoData2
     */
    public static function fromDomNode($domNode){
        if(empty($domNode)){
            return null;
        }
        while ($domNode->nodeName != 'CARGODATA2' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'CARGODATA2' || ! $domNode->hasChildNodes()){
            return null;
        }
        $cd2 = new CargoData2();
        $nd =  $domNode->firstChild;

        while ($nd != null){
            $key = $nd->nodeName;
            $method = "set" . $key;
            if(method_exists($cd2,$method)){
                $cd2->$method($nd->nodeValue);
            }

            $nd = $nd->nextSibling;
        }
        return $cd2;
    }

    /**
     * @param \DOMNode $domNode
     * @return array|CargoData2[]
     */
    public static function fromDomNodeArray($domNode){
        if(empty($domNode)){
            return array();
        }
        while ($domNode->nodeName != 'NewDataSet' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'NewDataSet' || ! $domNode->hasChildNodes()){
            return array();
        }
        $res = array();
        foreach ($domNode->childNodes as $node){
            $itm = static::fromDomNode($node);
            if($itm != null){
                $res[] = $itm;
            }
        }

        return $res;
    }

    #endregion statics

}