<?php


namespace Ys\ArasKargo\Entities;


class CargoData1
{

    #region fields

    /**
     * @var string|null
     */
    public $MUSTERI_OZEL_KODU;

    /**
     * @var string|null
     */
    public $MUSTERI_KODU;

    /**
     * @var string|null
     */
    public $IRSALIYE_NUMARA;

    /**
     * @var string|null
     */
    public $ALICI_ADI;

    /**
     * @var string|null
     */
    public $YONLENDIRME_TARIHI;

    /**
     * @var string|null
     */
    public $YONLENDIREN_BIRIM;

    /**
     * @var string|null
     */
    public $YONLENDIRILEN_BIRIM;

    /**
     * @var string|null
     */
    public $YONLENDIRME_KODU;

    /**
     * @var string|null
     */
    public $YONLENDIRME_NEDENI;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties


    /**
     * @return string|null
     */
    public function getMUSTERI_OZEL_KODU()
    {
        return $this->MUSTERI_OZEL_KODU;
    }

    /**
     * @param string|null $MUSTERI_OZEL_KODU
     * @return CargoData1
     */
    public function setMUSTERI_OZEL_KODU($MUSTERI_OZEL_KODU)
    {
        $this->MUSTERI_OZEL_KODU = $MUSTERI_OZEL_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }

    /**
     * @param string|null $MUSTERI_KODU
     * @return CargoData1
     */
    public function setMUSTERI_KODU($MUSTERI_KODU)
    {
        $this->MUSTERI_KODU = $MUSTERI_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIRSALIYE_NUMARA()
    {
        return $this->IRSALIYE_NUMARA;
    }

    /**
     * @param string|null $IRSALIYE_NUMARA
     * @return CargoData1
     */
    public function setIRSALIYE_NUMARA($IRSALIYE_NUMARA)
    {
        $this->IRSALIYE_NUMARA = $IRSALIYE_NUMARA;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }

    /**
     * @param string|null $ALICI_ADI
     * @return CargoData1
     */
    public function setALICI_ADI($ALICI_ADI)
    {
        $this->ALICI_ADI = $ALICI_ADI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getYONLENDIRME_TARIHI()
    {
        return $this->YONLENDIRME_TARIHI;
    }

    /**
     * @param string|null $YONLENDIRME_TARIHI
     * @return CargoData1
     */
    public function setYONLENDIRME_TARIHI($YONLENDIRME_TARIHI)
    {
        $this->YONLENDIRME_TARIHI = $YONLENDIRME_TARIHI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getYONLENDIREN_BIRIM()
    {
        return $this->YONLENDIREN_BIRIM;
    }

    /**
     * @param string|null $YONLENDIREN_BIRIM
     * @return CargoData1
     */
    public function setYONLENDIREN_BIRIM($YONLENDIREN_BIRIM)
    {
        $this->YONLENDIREN_BIRIM = $YONLENDIREN_BIRIM;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getYONLENDIRILEN_BIRIM()
    {
        return $this->YONLENDIRILEN_BIRIM;
    }

    /**
     * @param string|null $YONLENDIRILEN_BIRIM
     * @return CargoData1
     */
    public function setYONLENDIRILEN_BIRIM($YONLENDIRILEN_BIRIM)
    {
        $this->YONLENDIRILEN_BIRIM = $YONLENDIRILEN_BIRIM;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getYONLENDIRME_KODU()
    {
        return $this->YONLENDIRME_KODU;
    }

    /**
     * @param string|null $YONLENDIRME_KODU
     * @return CargoData1
     */
    public function setYONLENDIRME_KODU($YONLENDIRME_KODU)
    {
        $this->YONLENDIRME_KODU = $YONLENDIRME_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getYONLENDIRME_NEDENI()
    {
        return $this->YONLENDIRME_NEDENI;
    }

    /**
     * @param string|null $YONLENDIRME_NEDENI
     * @return CargoData1
     */
    public function setYONLENDIRME_NEDENI($YONLENDIRME_NEDENI)
    {
        $this->YONLENDIRME_NEDENI = $YONLENDIRME_NEDENI;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param \DOMNode $domNode
     * @return null|CargoData1
     */
    public static function fromDomNode($domNode){
        if(empty($domNode)){
            return null;
        }
        while ($domNode->nodeName != 'CARGODATA1' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'CARGODATA1' || ! $domNode->hasChildNodes()){
            return null;
        }
        $cd1 = new CargoData1();
        $nd =  $domNode->firstChild;

        while ($nd != null){
            $key = $nd->nodeName;
            $method = "set" . $key;
            if(method_exists($cd1,$method)){
                $cd1->$method($nd->nodeValue);
            }

            $nd = $nd->nextSibling;
        }
        return $cd1;
    }

    /**
     * @param \DOMNode $domNode
     * @return array|CargoData1[]
     */
    public static function fromDomNodeArray($domNode){
        if(empty($domNode)){
            return array();
        }
        while ($domNode->nodeName != 'NewDataSet' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'NewDataSet' || ! $domNode->hasChildNodes()){
            return array();
        }
        $res = array();
        foreach ($domNode->childNodes as $node){
            $itm = static::fromDomNode($node);
            if($itm != null){
                $res[] = $itm;
            }
        }

        return $res;
    }

    #endregion statics

}