<?php


namespace Ys\ArasKargo\Entities;


class CargoData
{

    #region fields

    /**
     * @var string|null
     */
    public $MUSTERI_KODU;

    /**
     * @var string|null
     */
    public $IRSALIYE_NUMARA;

    /**
     * @var string|null
     */
    public $ALICI_ADI;

    /**
     * @var string|null
     */
    public $SUBE_ADI;

    /**
     * @var string|null
     */
    public $CIKIS_TARIHI;

    /**
     * @var string|null
     */
    public $DEVIR_ACIKLAMA;

    /**
     * @var string|null
     */
    public $DEVIR_NEDENI;

    /**
     * @var string|null
     */
    public $DEVIR_KODU;

    /**
     * @var string|null
     */
    public $MUSTERI_OZEL_KODU;

    #endregion fields

    #region ctor

    public function __construct()
    {
    }

    #endregion ctor

    #region properties

    /**
     * @return string|null
     */
    public function getMUSTERI_KODU()
    {
        return $this->MUSTERI_KODU;
    }

    /**
     * @param string|null $MUSTERI_KODU
     * @return CargoData
     */
    public function setMUSTERI_KODU($MUSTERI_KODU)
    {
        $this->MUSTERI_KODU = $MUSTERI_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getIRSALIYE_NUMARA()
    {
        return $this->IRSALIYE_NUMARA;
    }

    /**
     * @param string|null $IRSALIYE_NUMARA
     * @return CargoData
     */
    public function setIRSALIYE_NUMARA($IRSALIYE_NUMARA)
    {
        $this->IRSALIYE_NUMARA = $IRSALIYE_NUMARA;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getALICI_ADI()
    {
        return $this->ALICI_ADI;
    }

    /**
     * @param string|null $ALICI_ADI
     * @return CargoData
     */
    public function setALICI_ADI($ALICI_ADI)
    {
        $this->ALICI_ADI = $ALICI_ADI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSUBE_ADI()
    {
        return $this->SUBE_ADI;
    }

    /**
     * @param string|null $SUBE_ADI
     * @return CargoData
     */
    public function setSUBE_ADI($SUBE_ADI)
    {
        $this->SUBE_ADI = $SUBE_ADI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getCIKIS_TARIHI()
    {
        return $this->CIKIS_TARIHI;
    }

    /**
     * @param string|null $CIKIS_TARIHI
     * @return CargoData
     */
    public function setCIKIS_TARIHI($CIKIS_TARIHI)
    {
        $this->CIKIS_TARIHI = $CIKIS_TARIHI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDEVIR_ACIKLAMA()
    {
        return $this->DEVIR_ACIKLAMA;
    }

    /**
     * @param string|null $DEVIR_ACIKLAMA
     * @return CargoData
     */
    public function setDEVIR_ACIKLAMA($DEVIR_ACIKLAMA)
    {
        $this->DEVIR_ACIKLAMA = $DEVIR_ACIKLAMA;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDEVIR_NEDENI()
    {
        return $this->DEVIR_NEDENI;
    }

    /**
     * @param string|null $DEVIR_NEDENI
     * @return CargoData
     */
    public function setDEVIR_NEDENI($DEVIR_NEDENI)
    {
        $this->DEVIR_NEDENI = $DEVIR_NEDENI;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getDEVIR_KODU()
    {
        return $this->DEVIR_KODU;
    }

    /**
     * @param string|null $DEVIR_KODU
     * @return CargoData
     */
    public function setDEVIR_KODU($DEVIR_KODU)
    {
        $this->DEVIR_KODU = $DEVIR_KODU;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getMUSTERI_OZEL_KODU()
    {
        return $this->MUSTERI_OZEL_KODU;
    }

    /**
     * @param string|null $MUSTERI_OZEL_KODU
     * @return CargoData
     */
    public function setMUSTERI_OZEL_KODU($MUSTERI_OZEL_KODU)
    {
        $this->MUSTERI_OZEL_KODU = $MUSTERI_OZEL_KODU;
        return $this;
    }

    #endregion properties

    #region statics

    /**
     * @param \DOMNode $domNode
     * @return null|CargoData
     */
    public static function fromDomNode($domNode){
        if(empty($domNode)){
            return null;
        }
        while ($domNode->nodeName != 'CARGODATA' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'CARGODATA' || ! $domNode->hasChildNodes()){
            return null;
        }
        $cd = new CargoData();
        $nd =  $domNode->firstChild;

        while ($nd != null){
            $key = $nd->nodeName;
            $method = "set" . $key;
            if(method_exists($cd,$method)){
                $cd->$method($nd->nodeValue);
            }

            $nd = $nd->nextSibling;
        }
        return $cd;
    }

    /**
     * @param \DOMNode $domNode
     * @return array|CargoData[]
     */
    public static function fromDomNodeArray($domNode){
        if(empty($domNode)){
            return array();
        }
        while ($domNode->nodeName != 'NewDataSet' && $domNode->hasChildNodes()){
            $domNode = $domNode->firstChild;
        }
        if($domNode->nodeName != 'NewDataSet' || ! $domNode->hasChildNodes()){
            return array();
        }
        $res = array();
        foreach ($domNode->childNodes as $node){
            $itm = static::fromDomNode($node);
            if($itm != null){
                $res[] = $itm;
            }
        }

        return $res;
    }

    #endregion statics

}