<?php

namespace Ys\ArasKargo\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCustomerAddress ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfCustomerAddress
 * @subpackage Arrays
 */
class ArrayOfCustomerAddress extends AbstractStructArrayBase
{
    /**
     * The CustomerAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Ys\ArasKargo\StructType\CustomerAddress[]
     */
    public $CustomerAddress;
    /**
     * Constructor method for ArrayOfCustomerAddress
     * @uses ArrayOfCustomerAddress::setCustomerAddress()
     * @param \Ys\ArasKargo\StructType\CustomerAddress[] $customerAddress
     */
    public function __construct(array $customerAddress = array())
    {
        $this
            ->setCustomerAddress($customerAddress);
    }
    /**
     * Get CustomerAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Ys\ArasKargo\StructType\CustomerAddress[]|null
     */
    public function getCustomerAddress()
    {
        return isset($this->CustomerAddress) ? $this->CustomerAddress : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomerAddress method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomerAddress method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerAddressForArrayConstraintsFromSetCustomerAddress(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $arrayOfCustomerAddressCustomerAddressItem) {
            // validation for constraint: itemType
            if (!$arrayOfCustomerAddressCustomerAddressItem instanceof \Ys\ArasKargo\StructType\CustomerAddress) {
                $invalidValues[] = is_object($arrayOfCustomerAddressCustomerAddressItem) ? get_class($arrayOfCustomerAddressCustomerAddressItem) : sprintf('%s(%s)', gettype($arrayOfCustomerAddressCustomerAddressItem), var_export($arrayOfCustomerAddressCustomerAddressItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CustomerAddress property can only contain items of type \Ys\ArasKargo\StructType\CustomerAddress, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CustomerAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\CustomerAddress[] $customerAddress
     * @return \Ys\ArasKargo\ArrayType\ArrayOfCustomerAddress
     */
    public function setCustomerAddress(array $customerAddress = array())
    {
        // validation for constraint: array
        if ('' !== ($customerAddressArrayErrorMessage = self::validateCustomerAddressForArrayConstraintsFromSetCustomerAddress($customerAddress))) {
            throw new \InvalidArgumentException($customerAddressArrayErrorMessage, __LINE__);
        }
        if (is_null($customerAddress) || (is_array($customerAddress) && empty($customerAddress))) {
            unset($this->CustomerAddress);
        } else {
            $this->CustomerAddress = $customerAddress;
        }
        return $this;
    }
    /**
     * Add item to CustomerAddress value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\CustomerAddress $item
     * @return \Ys\ArasKargo\ArrayType\ArrayOfCustomerAddress
     */
    public function addToCustomerAddress(\Ys\ArasKargo\StructType\CustomerAddress $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\CustomerAddress) {
            throw new \InvalidArgumentException(sprintf('The CustomerAddress property can only contain items of type \Ys\ArasKargo\StructType\CustomerAddress, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CustomerAddress[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Ys\ArasKargo\StructType\CustomerAddress|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Ys\ArasKargo\StructType\CustomerAddress|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Ys\ArasKargo\StructType\CustomerAddress|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Ys\ArasKargo\StructType\CustomerAddress|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Ys\ArasKargo\StructType\CustomerAddress|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CustomerAddress
     */
    public function getAttributeName()
    {
        return 'CustomerAddress';
    }
}
