<?php

namespace Ys\ArasKargo\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAddressDto ArrayType
 * @subpackage Arrays
 */
class ArrayOfAddressDto extends AbstractStructArrayBase
{
    /**
     * The AddressDto
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Ys\ArasKargo\StructType\AddressDto[]
     */
    public $AddressDto;
    /**
     * Constructor method for ArrayOfAddressDto
     * @uses ArrayOfAddressDto::setAddressDto()
     * @param \Ys\ArasKargo\StructType\AddressDto[] $addressDto
     */
    public function __construct(array $addressDto = array())
    {
        $this
            ->setAddressDto($addressDto);
    }
    /**
     * Get AddressDto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Ys\ArasKargo\StructType\AddressDto[]|null
     */
    public function getAddressDto()
    {
        return isset($this->AddressDto) ? $this->AddressDto : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressDto method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressDto method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressDtoForArrayConstraintsFromSetAddressDto(array $values = array())
    {
        $message = '';
        $invalidValues = array();
        foreach ($values as $arrayOfAddressDtoAddressDtoItem) {
            // validation for constraint: itemType
            if (!$arrayOfAddressDtoAddressDtoItem instanceof \Ys\ArasKargo\StructType\AddressDto) {
                $invalidValues[] = is_object($arrayOfAddressDtoAddressDtoItem) ? get_class($arrayOfAddressDtoAddressDtoItem) : sprintf('%s(%s)', gettype($arrayOfAddressDtoAddressDtoItem), var_export($arrayOfAddressDtoAddressDtoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressDto property can only contain items of type \Ys\ArasKargo\StructType\AddressDto, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressDto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\AddressDto[] $addressDto
     * @return \Ys\ArasKargo\ArrayType\ArrayOfAddressDto
     */
    public function setAddressDto(array $addressDto = array())
    {
        // validation for constraint: array
        if ('' !== ($addressDtoArrayErrorMessage = self::validateAddressDtoForArrayConstraintsFromSetAddressDto($addressDto))) {
            throw new \InvalidArgumentException($addressDtoArrayErrorMessage, __LINE__);
        }
        if (is_null($addressDto) || (is_array($addressDto) && empty($addressDto))) {
            unset($this->AddressDto);
        } else {
            $this->AddressDto = $addressDto;
        }
        return $this;
    }
    /**
     * Add item to AddressDto value
     * @throws \InvalidArgumentException
     * @param \Ys\ArasKargo\StructType\AddressDto $item
     * @return \Ys\ArasKargo\ArrayType\ArrayOfAddressDto
     */
    public function addToAddressDto(\Ys\ArasKargo\StructType\AddressDto $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Ys\ArasKargo\StructType\AddressDto) {
            throw new \InvalidArgumentException(sprintf('The AddressDto property can only contain items of type \Ys\ArasKargo\StructType\AddressDto, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressDto[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Ys\ArasKargo\StructType\AddressDto|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Ys\ArasKargo\StructType\AddressDto|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Ys\ArasKargo\StructType\AddressDto|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Ys\ArasKargo\StructType\AddressDto|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Ys\ArasKargo\StructType\AddressDto|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AddressDto
     */
    public function getAttributeName()
    {
        return 'AddressDto';
    }
}
