<?php

namespace Gek\UyumBahceGet\StructType;

use InvalidArgumentException;
use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for X509IssuerSerialType StructType
 * @subpackage Structs
 */
class X509IssuerSerialType extends AbstractStructBase
{
    /**
     * The X509IssuerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $X509IssuerName;
    /**
     * The X509SerialNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $X509SerialNumber;

    /**
     * Constructor method for X509IssuerSerialType
     * @param string $x509IssuerName
     * @param int $x509SerialNumber
     * @uses X509IssuerSerialType::setX509IssuerName()
     * @uses X509IssuerSerialType::setX509SerialNumber()
     */
    public function __construct($x509IssuerName = null, $x509SerialNumber = null)
    {
        $this
            ->setX509IssuerName($x509IssuerName)
            ->setX509SerialNumber($x509SerialNumber);
    }

    /**
     * Get X509IssuerName value
     * @return string|null
     */
    public function getX509IssuerName()
    {
        return $this->X509IssuerName;
    }

    /**
     * Set X509IssuerName value
     * @param string $x509IssuerName
     * @return X509IssuerSerialType
     */
    public function setX509IssuerName($x509IssuerName = null)
    {
        // validation for constraint: string
        if (!is_null($x509IssuerName) && !is_string($x509IssuerName)) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($x509IssuerName, true), gettype($x509IssuerName)), __LINE__);
        }
        $this->X509IssuerName = $x509IssuerName;
        return $this;
    }

    /**
     * Get X509SerialNumber value
     * @return int|null
     */
    public function getX509SerialNumber()
    {
        return $this->X509SerialNumber;
    }

    /**
     * Set X509SerialNumber value
     * @param int $x509SerialNumber
     * @return X509IssuerSerialType
     */
    public function setX509SerialNumber($x509SerialNumber = null)
    {
        // validation for constraint: int
        if (!is_null($x509SerialNumber) && !(is_int($x509SerialNumber) || ctype_digit($x509SerialNumber))) {
            throw new InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($x509SerialNumber, true), gettype($x509SerialNumber)), __LINE__);
        }
        $this->X509SerialNumber = $x509SerialNumber;
        return $this;
    }
}
