<?php

namespace Gek\UyumBahceGet\StructType;

use WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WhoAmIInfo StructType
 * @subpackage Structs
 */
class WhoAmIInfo extends AbstractStructBase
{
    /**
     * The User
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var UserShortInfo
     */
    public $User;
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var CustomerWithoutServiceInformation
     */
    public $Customer;

    /**
     * Constructor method for WhoAmIInfo
     * @param UserShortInfo $user
     * @param CustomerWithoutServiceInformation $customer
     * @uses WhoAmIInfo::setUser()
     * @uses WhoAmIInfo::setCustomer()
     */
    public function __construct(UserShortInfo $user = null, CustomerWithoutServiceInformation $customer = null)
    {
        $this
            ->setUser($user)
            ->setCustomer($customer);
    }

    /**
     * Get User value
     * @return UserShortInfo|null
     */
    public function getUser()
    {
        return $this->User;
    }

    /**
     * Set User value
     * @param UserShortInfo $user
     * @return WhoAmIInfo
     */
    public function setUser(UserShortInfo $user = null)
    {
        $this->User = $user;
        return $this;
    }

    /**
     * Get Customer value
     * @return CustomerWithoutServiceInformation|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }

    /**
     * Set Customer value
     * @param CustomerWithoutServiceInformation $customer
     * @return WhoAmIInfo
     */
    public function setCustomer(CustomerWithoutServiceInformation $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
}
